/******************************************************************************\
*                                                                              *
*  c't OS/2 Editor v0.7                                                        *
*                                                                              *
*  Modul:     edit.cpp                                                         *
*  Aufgabe:   Hauptprogramm (Initialisierung, etc.)                            *
*                                                                              *
\******************************************************************************/
#include "common.h"
#pragma hdrstop
#include "toolbar.h"
#include "debug.h"
#include "edit.h"
#include "aclient.h"
#include "enhframe.h"
#include "statbar.h"
#include "ctedit.h"
#include "editor.h"
#include "api.h"

/* Name     : main
** Task     : Hauptfunktion
** Input    : Mehr als ein Parameter wird erst spter untersttzt
*/


void xmain(int argc, char *argv[])
  {
  int i;
#ifdef __EMX__
  _wildcard(&argc, &argv);
#endif

  // Suche nach allen Editormodulen
  loadAllDll();
  // Initialisiere alle DLL
  CallDllInit();

  // Das wird der Editor
  Editor *edit;

  if (argc<=2)
     {
     // neues editorobjekt
     edit=new Editor;
     if (argc>1)
        edit->setInitFile(argv[1]);

     // Fenster erzeugen
     edit->process(edit);
     delete edit;
     }
  else
     {
     for (int i=1; i<argc; i++)
        {
        edit=new Editor;
        edit->setInitFile(argv[i]);
        edit->run();
        DosSleep(0);
        }
    int count=0;
    while (1)
       {
       TID id=0;
       DosWaitThread(&id, DCWW_WAIT);
       if (threadsRunning==0)
          break;
       DosSleep(0);
       }
    }
  } /* xmain */

void main(int argc, char *argv[])
  {
  char *parv[4096];
  int parc=0;

  parv[parc]=new char[strlen(argv[0])+1];
  strcpy(parv[parc], argv[0]);
  parc++;

  for (int i=1; i<argc && parc<4096; i++)
     {
     HDIR   fh=HDIR_CREATE;
     FILEFINDBUF3 buf;
     ULONG  fc=1,count;
     APIRET rc;
     char   basepath[CCHMAXPATH];

     strcpy(basepath, argv[i]);
     for (char *s=basepath+strlen(basepath)-1; s>=basepath; s--)
        if (*s=='\\') { *(s+1)=0; break; } /* endif: *s=='\\' */
     if (s<basepath)
        basepath[0]=0;

     rc=DosFindFirst((PSZ)argv[i],&fh,0x37,(PFILEFINDBUF)&buf,(USHORT)sizeof(buf),&fc,1);

     for (;rc==0;rc=DosFindNext(fh,&buf,sizeof(buf),&fc))
        {
        parv[parc]=new char[strlen(buf.achName)+strlen(basepath)+1];
        strcpy(parv[parc], basepath);
        strcat(parv[parc], buf.achName);
        printf("%s\n", parv[parc]);
        parc++;
        }
     }
  xmain(parc, parv);
  }
