#ifndef _OS2DEBUG_H_
#define _OS2DEBUG_H_

#ifdef IMPORT
  #include "impdeb.h"
#endif

#ifdef TOOLKIT20
  #define FHLOCK ULONG
  #define PFHLOCK PULONG
#endif

#ifdef __cplusplus
extern "C" {
#endif
#define DosBeep(A,B) \
        DebugDosBeep(__FUNCTION__,__FILE__,__LINE__,A,B)
APIRET DebugDosBeep(char *_func, char *_file, int _line, ULONG freq, ULONG dur);
#define DosGetInfoBlocks(A,B) \
        DebugDosGetInfoBlocks(__FUNCTION__,__FILE__,__LINE__,A,B)
APIRET DebugDosGetInfoBlocks(char *_func, char *_file, int _line, PTIB *pptib, PPIB *pppib);
#define DosSleep(A) \
        DebugDosSleep(__FUNCTION__,__FILE__,__LINE__,A)
APIRET DebugDosSleep(char *_func, char *_file, int _line, ULONG msec);
#define DosExecPgm(A,B,C,D,E,F,G) \
        DebugDosExecPgm(__FUNCTION__,__FILE__,__LINE__,A,B,C,D,E,F,G)
APIRET DebugDosExecPgm(char *_func, char *_file, int _line, PCHAR pObjname, LONG cbObjname, ULONG execFlag, PCSZ pArg, PCSZ pEnv, PRESULTCODES pRes, PCSZ pName);
#define DosKillProcess(A,B) \
        DebugDosKillProcess(__FUNCTION__,__FILE__,__LINE__,A,B)
APIRET DebugDosKillProcess(char *_func, char *_file, int _line, ULONG action, PID pid);
#define DosOpen(A,B,C,D,E,F,G,H) \
        DebugDosOpen(__FUNCTION__,__FILE__,__LINE__,A,B,C,D,E,F,G,H)
APIRET DebugDosOpen(char *_func, char *_file, int _line, PCSZ pszFileName, PHFILE pHf, PULONG pulAction, ULONG cbFile, ULONG ulAttribute, ULONG fsOpenFlags, ULONG fsOpenMode, PEAOP2 peaop2);
#define DosClose(A) \
        DebugDosClose(__FUNCTION__,__FILE__,__LINE__,A)
APIRET DebugDosClose(char *_func, char *_file, int _line, HFILE hFile);
#define DosRead(A,B,C,D) \
        DebugDosRead(__FUNCTION__,__FILE__,__LINE__,A,B,C,D)
APIRET DebugDosRead(char *_func, char *_file, int _line, HFILE hFile, PVOID pBuffer, ULONG cbRead, PULONG pcbActual);
#define DosWrite(A,B,C,D) \
        DebugDosWrite(__FUNCTION__,__FILE__,__LINE__,A,B,C,D)
APIRET DebugDosWrite(char *_func, char *_file, int _line, HFILE hFile, PVOID pBuffer, ULONG cbWrite, PULONG pcbActual);
#define DosDupHandle(A,B) \
        DebugDosDupHandle(__FUNCTION__,__FILE__,__LINE__,A,B)
APIRET DebugDosDupHandle(char *_func, char *_file, int _line, HFILE hFile, PHFILE pHfile);
#define DosFindFirst(A,B,C,D,E,F,G) \
        DebugDosFindFirst(__FUNCTION__,__FILE__,__LINE__,A,B,C,D,E,F,G)
APIRET DebugDosFindFirst(char *_func, char *_file, int _line, PCSZ pszFileSpec, PHDIR phdir, ULONG flAttribute, PVOID pfindbuf, ULONG cbBuf, PULONG pcFileNames, ULONG ulInfoLevel);
#define DosFindNext(A,B,C,D) \
        DebugDosFindNext(__FUNCTION__,__FILE__,__LINE__,A,B,C,D)
APIRET DebugDosFindNext(char *_func, char *_file, int _line, HDIR hDir, PVOID pfindbuf, ULONG cbfindbuf, PULONG pcFilenames);
#define DosQueryCurrentDisk(A,B) \
        DebugDosQueryCurrentDisk(__FUNCTION__,__FILE__,__LINE__,A,B)
APIRET DebugDosQueryCurrentDisk(char *_func, char *_file, int _line, PULONG pdisknum, PULONG plogical);
#define DosQueryMem(A,B,C) \
        DebugDosQueryMem(__FUNCTION__,__FILE__,__LINE__,A,B,C)
APIRET DebugDosQueryMem(char *_func, char *_file, int _line, PVOID pb, PULONG pcb, PULONG pFlag);
#define DosCreateMutexSem(A,B,C,D) \
        DebugDosCreateMutexSem(__FUNCTION__,__FILE__,__LINE__,A,B,C,D)
APIRET DebugDosCreateMutexSem(char *_func, char *_file, int _line, PCSZ pszName, PHMTX phmtx, ULONG flAttr, BOOL32 fState);
#define DosCloseMutexSem(A) \
        DebugDosCloseMutexSem(__FUNCTION__,__FILE__,__LINE__,A)
APIRET DebugDosCloseMutexSem(char *_func, char *_file, int _line, HMTX hmtx);
#define DosRequestMutexSem(A,B) \
        DebugDosRequestMutexSem(__FUNCTION__,__FILE__,__LINE__,A,B)
APIRET DebugDosRequestMutexSem(char *_func, char *_file, int _line, HMTX hmtx, ULONG ulTimeout);
#define DosReleaseMutexSem(A) \
        DebugDosReleaseMutexSem(__FUNCTION__,__FILE__,__LINE__,A)
APIRET DebugDosReleaseMutexSem(char *_func, char *_file, int _line, HMTX hmtx);
#define DosLoadModule(A,B,C,D) \
        DebugDosLoadModule(__FUNCTION__,__FILE__,__LINE__,A,B,C,D)
APIRET DebugDosLoadModule(char *_func, char *_file, int _line, PCSZ pszName, ULONG cbName, PCSZ pszModname, PHMODULE phmod);
#define DosFreeModule(A) \
        DebugDosFreeModule(__FUNCTION__,__FILE__,__LINE__,A)
APIRET DebugDosFreeModule(char *_func, char *_file, int _line, HMODULE hmod);
#define DosQueryProcAddr(A,B,C,D) \
        DebugDosQueryProcAddr(__FUNCTION__,__FILE__,__LINE__,A,B,C,D)
APIRET DebugDosQueryProcAddr(char *_func, char *_file, int _line, HMODULE hmod, ULONG ordinal, PCSZ pszName, PFN* ppfn);
#define DosQueryModuleName(A,B,C) \
        DebugDosQueryModuleName(__FUNCTION__,__FILE__,__LINE__,A,B,C)
APIRET DebugDosQueryModuleName(char *_func, char *_file, int _line, HMODULE hmod, ULONG cbName, PCHAR pch);
#define DosRaiseException(A) \
        DebugDosRaiseException(__FUNCTION__,__FILE__,__LINE__,A)
APIRET DebugDosRaiseException(char *_func, char *_file, int _line, PEXCEPTIONREPORTRECORD pexcept);
#define DosCreatePipe(A,B,C) \
        DebugDosCreatePipe(__FUNCTION__,__FILE__,__LINE__,A,B,C)
APIRET DebugDosCreatePipe(char *_func, char *_file, int _line, PHFILE phfRead, PHFILE phfWrite, ULONG cb);
#define DosGetMessage(A,B,C,D,E,F,G) \
        DebugDosGetMessage(__FUNCTION__,__FILE__,__LINE__,A,B,C,D,E,F,G)
APIRET DebugDosGetMessage(char *_func, char *_file, int _line, PCHAR* pTable, ULONG cTable, PCHAR pBuf, ULONG cbBuf, ULONG msgnumber, PCSZ pszFile, PULONG pcbMsg);
#define DosErrClass(A,B,C,D) \
        DebugDosErrClass(__FUNCTION__,__FILE__,__LINE__,A,B,C,D)
APIRET DebugDosErrClass(char *_func, char *_file, int _line, ULONG code, PULONG pClass, PULONG pAction, PULONG pLocus);
#define DosScanEnv(A,B) \
        DebugDosScanEnv(__FUNCTION__,__FILE__,__LINE__,A,B)
APIRET DebugDosScanEnv(char *_func, char *_file, int _line, PCSZ pszName, PCSZ *ppszValue);
#define WinFileDlg(A,B,C) \
        DebugWinFileDlg(__FUNCTION__,__FILE__,__LINE__,A,B,C)
HWND DebugWinFileDlg(char *_func, char *_file, int _line, HWND hwndP, HWND hwndO, PFILEDLG pfild);
#define WinFontDlg(A,B,C) \
        DebugWinFontDlg(__FUNCTION__,__FILE__,__LINE__,A,B,C)
HWND DebugWinFontDlg(char *_func, char *_file, int _line, HWND hwndP, HWND hwndO, PFONTDLG pfntd);
#define WinRegisterClass(A,B,C,D,E) \
        DebugWinRegisterClass(__FUNCTION__,__FILE__,__LINE__,A,B,C,D,E)
BOOL DebugWinRegisterClass(char *_func, char *_file, int _line, HAB hab, PCSZ pszClassName, PFNWP pfnWndProc, ULONG flStyle, ULONG cbWindowData);
#define WinDefWindowProc(A,B,C,D) \
        DebugWinDefWindowProc(__FUNCTION__,__FILE__,__LINE__,A,B,C,D)
MRESULT DebugWinDefWindowProc(char *_func, char *_file, int _line, HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);
#define WinDestroyWindow(A) \
        DebugWinDestroyWindow(__FUNCTION__,__FILE__,__LINE__,A)
BOOL DebugWinDestroyWindow(char *_func, char *_file, int _line, HWND hwnd);
#define WinShowWindow(A,B) \
        DebugWinShowWindow(__FUNCTION__,__FILE__,__LINE__,A,B)
BOOL DebugWinShowWindow(char *_func, char *_file, int _line, HWND hwnd, BOOL fShow);
#define WinQueryWindowRect(A,B) \
        DebugWinQueryWindowRect(__FUNCTION__,__FILE__,__LINE__,A,B)
BOOL DebugWinQueryWindowRect(char *_func, char *_file, int _line, HWND hwnd, PRECTL prclDest);
#define WinGetPS(A) \
        DebugWinGetPS(__FUNCTION__,__FILE__,__LINE__,A)
HPS DebugWinGetPS(char *_func, char *_file, int _line, HWND hwnd);
#define WinReleasePS(A) \
        DebugWinReleasePS(__FUNCTION__,__FILE__,__LINE__,A)
BOOL DebugWinReleasePS(char *_func, char *_file, int _line, HPS hps);
#define WinEndPaint(A) \
        DebugWinEndPaint(__FUNCTION__,__FILE__,__LINE__,A)
BOOL DebugWinEndPaint(char *_func, char *_file, int _line, HPS hps);
#define WinBeginPaint(A,B,C) \
        DebugWinBeginPaint(__FUNCTION__,__FILE__,__LINE__,A,B,C)
HPS DebugWinBeginPaint(char *_func, char *_file, int _line, HWND hwnd, HPS hps, PRECTL prclPaint);
#define WinFillRect(A,B,C) \
        DebugWinFillRect(__FUNCTION__,__FILE__,__LINE__,A,B,C)
BOOL DebugWinFillRect(char *_func, char *_file, int _line, HPS hps, PRECTL prcl, LONG lColor);
#define WinInitialize(A) \
        DebugWinInitialize(__FUNCTION__,__FILE__,__LINE__,A)
HAB DebugWinInitialize(char *_func, char *_file, int _line, ULONG flOptions);
#define WinTerminate(A) \
        DebugWinTerminate(__FUNCTION__,__FILE__,__LINE__,A)
BOOL DebugWinTerminate(char *_func, char *_file, int _line, HAB hab);
#define WinQueryAnchorBlock(A) \
        DebugWinQueryAnchorBlock(__FUNCTION__,__FILE__,__LINE__,A)
HAB DebugWinQueryAnchorBlock(char *_func, char *_file, int _line, HWND hwnd);
#define WinCreateWindow(A,B,C,D,E,F,G,H,I,J,K,L,M) \
        DebugWinCreateWindow(__FUNCTION__,__FILE__,__LINE__,A,B,C,D,E,F,G,H,I,J,K,L,M)
HWND DebugWinCreateWindow(char *_func, char *_file, int _line, HWND hwndParent, PCSZ pszClass, PCSZ pszName, ULONG flStyle, LONG x, LONG y, LONG cx, LONG cy, HWND hwndOwner, HWND hwndInsertBehind, ULONG id, PVOID pCtlData, PVOID pPresParams);
#define WinIsWindowVisible(A) \
        DebugWinIsWindowVisible(__FUNCTION__,__FILE__,__LINE__,A)
BOOL DebugWinIsWindowVisible(char *_func, char *_file, int _line, HWND hwnd);
#define WinQueryWindowText(A,B,C) \
        DebugWinQueryWindowText(__FUNCTION__,__FILE__,__LINE__,A,B,C)
LONG DebugWinQueryWindowText(char *_func, char *_file, int _line, HWND hwnd, LONG cchBufferMax, PCH pchBuffer);
#define WinSetWindowText(A,B) \
        DebugWinSetWindowText(__FUNCTION__,__FILE__,__LINE__,A,B)
BOOL DebugWinSetWindowText(char *_func, char *_file, int _line, HWND hwnd, PCSZ pszText);
#define WinWindowFromID(A,B) \
        DebugWinWindowFromID(__FUNCTION__,__FILE__,__LINE__,A,B)
HWND DebugWinWindowFromID(char *_func, char *_file, int _line, HWND hwndParent, ULONG id);
#define WinIsWindow(A,B) \
        DebugWinIsWindow(__FUNCTION__,__FILE__,__LINE__,A,B)
BOOL DebugWinIsWindow(char *_func, char *_file, int _line, HAB hab, HWND hwnd);
#define WinQueryWindow(A,B) \
        DebugWinQueryWindow(__FUNCTION__,__FILE__,__LINE__,A,B)
HWND DebugWinQueryWindow(char *_func, char *_file, int _line, HWND hwnd, LONG cmd);
#define WinSetWindowPos(A,B,C,D,E,F,G) \
        DebugWinSetWindowPos(__FUNCTION__,__FILE__,__LINE__,A,B,C,D,E,F,G)
BOOL DebugWinSetWindowPos(char *_func, char *_file, int _line, HWND hwnd, HWND hwndInsertBehind, LONG x, LONG y, LONG cx, LONG cy, ULONG fl);
#define WinQueryWindowPos(A,B) \
        DebugWinQueryWindowPos(__FUNCTION__,__FILE__,__LINE__,A,B)
BOOL DebugWinQueryWindowPos(char *_func, char *_file, int _line, HWND hwnd, PSWP pswp);
#define WinUpdateWindow(A) \
        DebugWinUpdateWindow(__FUNCTION__,__FILE__,__LINE__,A)
BOOL DebugWinUpdateWindow(char *_func, char *_file, int _line, HWND hwnd);
#define WinInvalidateRect(A,B,C) \
        DebugWinInvalidateRect(__FUNCTION__,__FILE__,__LINE__,A,B,C)
BOOL DebugWinInvalidateRect(char *_func, char *_file, int _line, HWND hwnd, PRECTL pwrc, BOOL fIncludeChildren);
#define WinSubclassWindow(A,B) \
        DebugWinSubclassWindow(__FUNCTION__,__FILE__,__LINE__,A,B)
PFNWP DebugWinSubclassWindow(char *_func, char *_file, int _line, HWND hwnd, PFNWP pfnwp);
#define WinQueryClassName(A,B,C) \
        DebugWinQueryClassName(__FUNCTION__,__FILE__,__LINE__,A,B,C)
LONG DebugWinQueryClassName(char *_func, char *_file, int _line, HWND hwnd, LONG cchMax, PCH pch);
#define WinQueryWindowUShort(A,B) \
        DebugWinQueryWindowUShort(__FUNCTION__,__FILE__,__LINE__,A,B)
USHORT DebugWinQueryWindowUShort(char *_func, char *_file, int _line, HWND hwnd, LONG index);
#define WinQueryWindowULong(A,B) \
        DebugWinQueryWindowULong(__FUNCTION__,__FILE__,__LINE__,A,B)
ULONG DebugWinQueryWindowULong(char *_func, char *_file, int _line, HWND hwnd, LONG index);
#define WinSetWindowULong(A,B,C) \
        DebugWinSetWindowULong(__FUNCTION__,__FILE__,__LINE__,A,B,C)
BOOL DebugWinSetWindowULong(char *_func, char *_file, int _line, HWND hwnd, LONG index, ULONG ul);
#define WinQueryWindowPtr(A,B) \
        DebugWinQueryWindowPtr(__FUNCTION__,__FILE__,__LINE__,A,B)
PVOID DebugWinQueryWindowPtr(char *_func, char *_file, int _line, HWND hwnd, LONG index);
#define WinSetWindowPtr(A,B,C) \
        DebugWinSetWindowPtr(__FUNCTION__,__FILE__,__LINE__,A,B,C)
BOOL DebugWinSetWindowPtr(char *_func, char *_file, int _line, HWND hwnd, LONG index, PVOID p);
#define WinSetWindowBits(A,B,C,D) \
        DebugWinSetWindowBits(__FUNCTION__,__FILE__,__LINE__,A,B,C,D)
BOOL DebugWinSetWindowBits(char *_func, char *_file, int _line, HWND hwnd, LONG index, ULONG flData, ULONG flMask);
#define WinBeginEnumWindows(A) \
        DebugWinBeginEnumWindows(__FUNCTION__,__FILE__,__LINE__,A)
HENUM DebugWinBeginEnumWindows(char *_func, char *_file, int _line, HWND hwnd);
#define WinGetNextWindow(A) \
        DebugWinGetNextWindow(__FUNCTION__,__FILE__,__LINE__,A)
HWND DebugWinGetNextWindow(char *_func, char *_file, int _line, HENUM henum);
#define WinEndEnumWindows(A) \
        DebugWinEndEnumWindows(__FUNCTION__,__FILE__,__LINE__,A)
BOOL DebugWinEndEnumWindows(char *_func, char *_file, int _line, HENUM henum);
#define WinSendMsg(A,B,C,D) \
        DebugWinSendMsg(__FUNCTION__,__FILE__,__LINE__,A,B,C,D)
MRESULT DebugWinSendMsg(char *_func, char *_file, int _line, HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);
#define WinCreateMsgQueue(A,B) \
        DebugWinCreateMsgQueue(__FUNCTION__,__FILE__,__LINE__,A,B)
HMQ DebugWinCreateMsgQueue(char *_func, char *_file, int _line, HAB hab, LONG cmsg);
#define WinDestroyMsgQueue(A) \
        DebugWinDestroyMsgQueue(__FUNCTION__,__FILE__,__LINE__,A)
BOOL DebugWinDestroyMsgQueue(char *_func, char *_file, int _line, HMQ hmq);
#define WinGetMsg(A,B,C,D,E) \
        DebugWinGetMsg(__FUNCTION__,__FILE__,__LINE__,A,B,C,D,E)
BOOL DebugWinGetMsg(char *_func, char *_file, int _line, HAB hab, PQMSG pqmsg, HWND hwndFilter, ULONG msgFilterFirst, ULONG msgFilterLast);
#define WinDispatchMsg(A,B) \
        DebugWinDispatchMsg(__FUNCTION__,__FILE__,__LINE__,A,B)
MRESULT DebugWinDispatchMsg(char *_func, char *_file, int _line, HAB hab, PQMSG pqmsg);
#define WinPostMsg(A,B,C,D) \
        DebugWinPostMsg(__FUNCTION__,__FILE__,__LINE__,A,B,C,D)
BOOL DebugWinPostMsg(char *_func, char *_file, int _line, HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);
#define WinPostQueueMsg(A,B,C,D) \
        DebugWinPostQueueMsg(__FUNCTION__,__FILE__,__LINE__,A,B,C,D)
BOOL DebugWinPostQueueMsg(char *_func, char *_file, int _line, HMQ hmq, ULONG msg, MPARAM mp1, MPARAM mp2);
#define WinSetFocus(A,B) \
        DebugWinSetFocus(__FUNCTION__,__FILE__,__LINE__,A,B)
BOOL DebugWinSetFocus(char *_func, char *_file, int _line, HWND hwndDesktop, HWND hwndSetFocus);
#define WinDlgBox(A,B,C,D,E,F) \
        DebugWinDlgBox(__FUNCTION__,__FILE__,__LINE__,A,B,C,D,E,F)
ULONG DebugWinDlgBox(char *_func, char *_file, int _line, HWND hwndParent, HWND hwndOwner, PFNWP pfnDlgProc, HMODULE hmod, ULONG idDlg, PVOID pCreateParams);
#define WinDismissDlg(A,B) \
        DebugWinDismissDlg(__FUNCTION__,__FILE__,__LINE__,A,B)
BOOL DebugWinDismissDlg(char *_func, char *_file, int _line, HWND hwndDlg, ULONG usResult);
#define WinDefDlgProc(A,B,C,D) \
        DebugWinDefDlgProc(__FUNCTION__,__FILE__,__LINE__,A,B,C,D)
MRESULT DebugWinDefDlgProc(char *_func, char *_file, int _line, HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2);
#define WinMessageBox(A,B,C,D,E,F) \
        DebugWinMessageBox(__FUNCTION__,__FILE__,__LINE__,A,B,C,D,E,F)
ULONG DebugWinMessageBox(char *_func, char *_file, int _line, HWND hwndParent, HWND hwndOwner, PCSZ pszText, PCSZ pszCaption, ULONG idWindow, ULONG flStyle);
#define WinPopupMenu(A,B,C,D,E,F,G) \
        DebugWinPopupMenu(__FUNCTION__,__FILE__,__LINE__,A,B,C,D,E,F,G)
BOOL DebugWinPopupMenu(char *_func, char *_file, int _line, HWND hwndParent, HWND hwndOwner, HWND hwndMenu, LONG x, LONG y, LONG idItem, ULONG fs);
#define WinCreateStdWindow(A,B,C,D,E,F,G,H,I) \
        DebugWinCreateStdWindow(__FUNCTION__,__FILE__,__LINE__,A,B,C,D,E,F,G,H,I)
HWND DebugWinCreateStdWindow(char *_func, char *_file, int _line, HWND hwndParent, ULONG flStyle, PULONG pflCreateFlags, PCSZ pszClientClass, PCSZ pszTitle, ULONG styleClient, HMODULE hmod, ULONG idResources, PHWND phwndClient);
#define WinSetPointer(A,B) \
        DebugWinSetPointer(__FUNCTION__,__FILE__,__LINE__,A,B)
BOOL DebugWinSetPointer(char *_func, char *_file, int _line, HWND hwndDesktop, HPOINTER hptrNew);
#define WinLoadPointer(A,B,C) \
        DebugWinLoadPointer(__FUNCTION__,__FILE__,__LINE__,A,B,C)
HPOINTER DebugWinLoadPointer(char *_func, char *_file, int _line, HWND hwndDesktop, HMODULE hmod, ULONG idres);
#define WinQueryPointerPos(A,B) \
        DebugWinQueryPointerPos(__FUNCTION__,__FILE__,__LINE__,A,B)
BOOL DebugWinQueryPointerPos(char *_func, char *_file, int _line, HWND hwndDesktop, PPOINTL pptl);
#define WinSetObjectData(A,B) \
        DebugWinSetObjectData(__FUNCTION__,__FILE__,__LINE__,A,B)
BOOL DebugWinSetObjectData(char *_func, char *_file, int _line, HOBJECT hObject, PCSZ pszSetupString);
#define WinQueryObject(A) \
        DebugWinQueryObject(__FUNCTION__,__FILE__,__LINE__,A)
HOBJECT DebugWinQueryObject(char *_func, char *_file, int _line, PCSZ pszObjectID);
#ifdef __cplusplus
}
#endif

#endif
