(* Delphi-Beispiel: Packen von dBase-Dateien *)
(* Ingo T. Storm // c't 12/95 *)
unit UMainFor;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, DB, DBTables, StdCtrls, Grids, DBGrids, DBIErrs,
  ExtCtrls, DBCtrls, dbiProcs, dbiTypes,
  UCounter, UPack, UCreator;

type
  TMainForm = class(TForm) (* Beispielform fr Packfunktion *)
    DataSource1: TDataSource;
    Table1: TTable;
    DBGrid1: TDBGrid;
    bCreate: TButton;
    bDelRandom: TButton;
    bPack: TButton;
    bExit: TButton;
    bOpenClose: TButton;
    DBNavigator1: TDBNavigator;
    bPackXtern: TButton;
    OpenDialog1: TOpenDialog;
    procedure bOpenCloseClick(Sender: TObject);
    procedure bExitClick(Sender: TObject);
    procedure bCreateClick(Sender: TObject);
    procedure bDelRandomClick(Sender: TObject);
    procedure bPackClick(Sender: TObject);
    procedure bRandomizeClick(Sender: TObject);
    procedure bPackXternClick(Sender: TObject);
  private
    { Private declarations }
    FCounter : TCounter;
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

procedure TMainForm.bOpenCloseClick(Sender: TObject);
begin
  if Table1.Active then
    try
      Enabled := false;
      Table1.Close;
      bOpenClose.Caption := '&Open Database';
      bCreate.Enabled := false;
      bDelRandom.Enabled := false;
    finally
      Enabled := true
    end
  else
    try
      Enabled := false;
      Table1.Open;
      bOpenClose.Caption := '&Close Database';
      bCreate.Enabled := true;
      bDelRandom.Enabled := true;
    finally
      Enabled := true
    end
end;

procedure TMainForm.bExitClick(Sender: TObject);
begin
  Close
end;

procedure TMainForm.bCreateClick(Sender: TObject);
var
  TP1 : TPackRec;
  s   : string;
  i, num : LongInt;
begin
  s:='100';
  if InputQuery('Create how many records?','',s) then
    Enabled:=false;
    try
      try
        num := StrToInt(s);
        FCounter := TCounter.Create(self);
        FCounter.StartValue := 0;
        FCounter.EndValue := num;
        FCounter.Label1.Caption := 'Creating records...';
        FCounter.Show;
        DBGrid1.Datasource := nil;

        i := 0;
        while i<num do begin
          inc(i);
          TP1 := CreateRandomRecord;
          with TP1 do Table1.InsertRecord([Nummer,Name,Vorname,Alter,DummyText]);
          Application.ProcessMessages;
          FCounter.Advance;
          if FCounter.Abort then i:=num+1;
        end
      except
        on e:exception do MessageDlg('Bitte eine ZAHL eingeben.',mtError,[mbCancel],0);
      end
    finally
      if FCounter <> nil then begin
        FCounter.Close;
        BringToFront;
        FCounter.Destroy
      end;
      DBGrid1.DataSource := Datasource1;
      Enabled:=true;
    end

end;

procedure TMainForm.bDelRandomClick(Sender: TObject);
var
  TP1 : TPackRec;
  s   : string;
  i, num : LongInt;
begin
  s:='100';
  if InputQuery('Delete how many?','',s) then
    Enabled:=false;
    DBGrid1.DataSource := nil;
    try
      try
        num := StrToInt(s);
        FCounter := TCounter.Create(self);
        FCounter.StartValue := 0;
        FCounter.EndValue := num;
        FCounter.Label1.Caption := 'Deleting records...';
        FCounter.Show;
        i := 0;
        while i<num do begin
          inc(i);
          try
            Table1.Delete;
            Application.ProcessMessages;
            FCounter.Advance
          except
            on e:EDataBaseError do i:=num+1;
          end;
          if FCounter.Abort then i:=num+1;
        end
      except
        on e:exception do MessageDlg('Bitte eine ZAHL eingeben.',mtError,[mbCancel],0);
      end
    finally
      if FCounter <> nil then begin
        FCounter.Close;
        FCounter.Destroy
      end;
      Enabled:=true;
      DBGrid1.DataSource := Datasource1;
      BringToFront;
    end
end;

procedure TMainForm.bPackClick(Sender: TObject);
begin
  try
    enabled := false;
    PackTableInternal(Table1);
  finally
     Enabled := true
  end
end;

procedure TMainForm.bRandomizeClick(Sender: TObject);
begin
  Randomize
end;

procedure TMainForm.bPackXternClick(Sender: TObject);
var
  strAlias : string;
  strTable : string;
begin
  if OpenDialog1.Execute then
    PackTableByName( self,
                     ExtractFilePath(OpenDialog1.FileName),
                     ExtractFileName(OpenDialog1.FileName));
end;

end.
