#define STRICT               // Striktere Typprfungen einschalten
#define WIN32_LEAN_AND_MEAN  // Nur wichtige Headerfiles compilieren
#include <windows.h>
#include <stdio.h>

// Zeigt die wichtigsten Informationen in einem KEY_EVENT_RECORD
VOID ShowKeyEvent(KEY_EVENT_RECORD *event);
VOID ShowKeyEvent(KEY_EVENT_RECORD *event)
{
  if (event->bKeyDown)
    printf("Key down event: ");
  else
    printf("Key up event:   ");
  printf("AsciiChar=%d  ",event->uChar.AsciiChar);
  printf("wVirtualKeyCode=%d\n",event->wVirtualKeyCode);
  if (event->uChar.AsciiChar==27) // ESCAPE, Programm beenden
    ExitProcess(0);
}

// Zeigt die wichtigsten Informationen in einem MOUSE_EVENT_RECORD
VOID ShowMouseEvent(MOUSE_EVENT_RECORD *event);
VOID ShowMouseEvent(MOUSE_EVENT_RECORD *event)
{
  printf("Mouse event: dwMousePosition=%dx%d",
    event->dwMousePosition.X,event->dwMousePosition.Y);
  if (event->dwButtonState&1)
    printf(" Left");
  if (event->dwButtonState&2)
    printf(" Right");
  if (event->dwEventFlags==DOUBLE_CLICK)
    printf(" Double Click");
  printf(" dwControlKeyState=%d\n",event->dwControlKeyState);
}

// Dito fr einen WINDOW_BUFFER_SIZE_RECORD
VOID ShowWindowBufferSizeEvent(WINDOW_BUFFER_SIZE_RECORD *event);
VOID ShowWindowBufferSizeEvent(WINDOW_BUFFER_SIZE_RECORD *event)
{
  printf("Window buffer size event: dwSize.X=%d  dwSize.Y=%d\n",event->dwSize.X,event->dwSize.Y);
}

// Undokumentierter Event-Typ, aber dokumentierte Struktur!
VOID ShowMenuEvent(MENU_EVENT_RECORD *event);
VOID ShowMenuEvent(MENU_EVENT_RECORD *event)
{
  printf("Menu event: dwCommandId=%d\n",event->dwCommandId);
}

// Undokumentierter Event-Typ, aber dokumentierte Struktur!
VOID ShowFocusEvent(FOCUS_EVENT_RECORD *event);
VOID ShowFocusEvent(FOCUS_EVENT_RECORD *event)
{
  printf("Focus event: bSetFcous=%d\n",event->bSetFocus);
}

int main(int argc, char* argv[])
{
  HANDLE hInput=GetStdHandle(STD_INPUT_HANDLE);
  INPUT_RECORD ir;
  DWORD dwRead;
  // Input-Modus einstellen
  SetConsoleMode(hInput,ENABLE_MOUSE_INPUT|ENABLE_WINDOW_INPUT);
  while (TRUE) {
    ReadConsoleInput(hInput,&ir,1,&dwRead); // Event lesen

    switch(ir.EventType) { // Einer der fnf Event-Typen
      case KEY_EVENT:   // Keyboard
        ShowKeyEvent(&ir.Event.KeyEvent);
        break;

      case MOUSE_EVENT: // Maus
        ShowMouseEvent(&ir.Event.MouseEvent);
        break;

      case WINDOW_BUFFER_SIZE_EVENT: // Puffergre
        ShowWindowBufferSizeEvent(&ir.Event.WindowBufferSizeEvent);
        //
        break;

      case MENU_EVENT:  // Systemmenu
        ShowMenuEvent(&ir.Event.MenuEvent);
        break;

      case FOCUS_EVENT: // Fokus-Event
        ShowFocusEvent(&ir.Event.FocusEvent);
        break;

      default:
        printf("Unbekannter Input-Event: %d\n",ir.EventType);
        break;
    }
  }
  return 0;
}


