#ifndef _ACTION_H_
#define _ACTION_H_

#include "string.h"
#include "dlist.h"
#include "generic.h"
#include "thread.h"
#ifdef DTS_EDITDLL
 #include "bedit.hh"
 #define USE_EDITOR
#endif

#ifndef USE_EDITOR
  #define Editor AppEditor
#endif

class AppEditor;
typedef int (* APIENTRY ActionFnPtr)(Editor *frame);

struct ActionInit
  {
  ActionFnPtr do_action;
  char       *entry;
  char       *helptext;
  unsigned    id;
  HMODULE     hmod;
  unsigned    resid;
  };

struct ActionBase : public Thread
  {
    EString     entry;
    EString     helptext;
    unsigned    id;
    HMODULE     hmod;
    unsigned    resid;
    BOOL        async;
    Editor*     editor;
  public:
    ActionBase(char *s1, char *s2, unsigned i, HMODULE h, unsigned r);
    virtual ~ActionBase();
    virtual int action(Editor *);
    void    setAsync(BOOL b=TRUE) { async=b; }
  };

struct Action : public ActionBase
  {
    ActionFnPtr do_action;
  public:
    Action(ActionFnPtr p, char *s1, char *s2,
           int i=0, HMODULE h=0, unsigned r=0);
    Action(Action& x) : do_action(x.do_action),
        ActionBase(x.entry, x.helptext, x.id, x.hmod, x.resid) {}
    Action(ActionInit& x) : do_action(x.do_action),
        ActionBase(x.entry, x.helptext, x.id, x.hmod, x.resid) {}
    virtual int action(Editor *edit);
    virtual void threadEntry() { do_action(editor); }
    virtual ~Action();
  };


typedef ActionBase *PAction;

class ActionList
  {
    Dlist<PAction> alist;
  public:
    ActionList();
    ~ActionList();
    void append(ActionBase *p);
    ActionBase& operator[](int id);
    ActionBase *queryAction(int id);
    void clear();
    void remove(int offset);
  };

#ifndef _EDITOR_H_
#include "editor.h"
#include "action2.h"
#endif

#endif
