#ifndef _API_H_
#define _API_H_

#include "string.h"

#ifndef DTS_EDITDLL
 class AppEditor;
 typedef int (* APIENTRY ApiInitWindowFnPtr)(AppEditor *edit);
 typedef int (* APIENTRY ApiFnPtr)(AppEditor *edit, char *name);
 typedef int (* APIENTRY ApiContextMenuFnPtr)(AppEditor *edit, char *name, char *selection);
 typedef int (* APIENTRY ApiInitFnPtr)(void *vtable);
#else
 class Editor;
 typedef int (* APIENTRY ApiInitWindowFnPtr)(Editor *edit);
 typedef int (* APIENTRY ApiFnPtr)(Editor *edit, char *name);
 typedef int (* APIENTRY ApiContextMenuFnPtr)(Editor *edit, char *name, char *selection);
 typedef int (* APIENTRY ApiInitFnPtr)(void *vtable);
#endif

struct Api
  {
  HMODULE                  hmod;
  ApiInitFnPtr             Init;
  ApiFnPtr                 newName;
  ApiContextMenuFnPtr      contextMenu;
  ApiInitWindowFnPtr       newWindow;
  ApiInitWindowFnPtr       endWindow;
  EString                  name;
  Api() { Init=0; newName=0; contextMenu=0; hmod=0; }
  Api(HMODULE mod, char *n, ApiInitFnPtr p1, ApiFnPtr p2, ApiContextMenuFnPtr p3, ApiInitWindowFnPtr p4, ApiInitWindowFnPtr p5)
        : hmod(mod), name(n), Init(p1), newName(p2), contextMenu(p3), newWindow(p4),
          endWindow(p5) {}
  };

void loadAllDll();
void CallDllInit();
#ifndef DTS_EDITDLL
class AppEditor;
void CallChangeName(AppEditor *e);
void CallContextMenu(AppEditor *e, char *name, char *selection);
void CallInitWindow(AppEditor *e);
void CallDeInitWindow(AppEditor *e);
#else
class Editor;
void CallChangeName(Editor *e);
void CallContextMenu(Editor *e, char *name, char *selection);
void CallInitWindow(Editor *e);
void CallDeInitWindow(Editor *e);
#endif

#endif
