#ifndef _DEBUG_H_
#define _DEBUG_H_

#if defined (__IBMC__) || defined (__IBMCPP_)
 #ifdef TRACE
   #include <icsperf.h>
 #endif
#endif

/*
#ifdef DEBUG
 #include "os2deb.h"
#endif
*/

/* This file defines a few macros for debugging, iff DEBUG #define'd          */
/*                                                                            */
/* dprintf              - used just like printf                               */
/* dputs                - print out a string                                  */
/* ENSURE(x)            - prints a message if x evaluates to FALSE            */
/* VALIDPTR(x)          - prints a message if x is null ptr or invalid        */
/* BREAKPOINT           - set a breakpoint                                    */
/* PT                   - just print a message with function, file, line      */
/* IF_DEBUG(x)          - evaluate x iff DEBUG is #defined'd                  */

 #define ensure ENSURE
/*
 #define validptr(x)  ((VALIDPTR(x)&(0x1|0x2|0x10))==(0x1|0x2|0x10))
 #define validread(x) ((VALIDPTR(x)&(0x1|0x10))==(0x1|0x10))
*/
 #define validptr(x)  ((x)!=0)
 #define validread(x) ((x)!=0)
 #define validwin VALIDWIN

#ifdef DEBUG

#ifdef __cplusplus
  extern "C" {
#endif
 extern void APIENTRY dprintf(char *format, ...);
 extern void APIENTRY _debug_ensure(int x, char *expr, char *f, char *file, int line);
 extern int  APIENTRY  checkDOS(unsigned long rc, char *fun, char *file, int line);
 extern int  APIENTRY  checkPM(unsigned long dummy, char *fun, char *file, int line);
 extern int  APIENTRY _debug_winhandle(unsigned long hwnd, char *fun, char *file, char *line);
 extern int  APIENTRY _debug_valid_ptr(void *p, char *ptr, char *f, char *file, int line);
 extern void APIENTRY _debug_winmsg(unsigned long hwnd, unsigned long msg, void *mp1, void *mp2, char *fun, char *file, int line);
 extern void APIENTRY _debug_requestSem(void);
 extern void APIENTRY _debug_releaseSem(void);
#ifdef __cplusplus
  }
#endif

 #define dputs(x) dprintf("%s [%s (%s,%i)]\r\n", x, __FUNCTION__, __FILE__, __LINE);
 #define BREAKPOINT   { EXCEPTIONREPORTRECORD r; r.ExceptionNum=0xe004abcd; r.fHandlerFlags=0;         \
                        r.NestedExceptionReportRecord=0; \
                        r.ExceptionAddress=0; \
                        r.cParameters=0; DosRaiseException(&r); debug_output("breakpoint\r\n");}
 #define ENSURE(x)    _debug_ensure((x), #x, __FUNCTION__,__FILE__,__LINE__)
 #define VALIDPTR(p)  _debug_valid_ptr((p), #p, __FUNCTION__, __FILE__, __LINE__)
 #define PT           dprintf("CHECKPOINT %i: %s in (%s,%i)\n", __LINE__, __FUNCTION__, __FILE__, __LINE__);
 #define IF_DEBUG(x) (x)
 #define CHECKDOS(x) checkDOS((x), __FUNCTION__, __FILE__, __LINE__)
 #define CHECKPM(x)  checkPM((x), __FUNCTION__, __FILE__, __LINE__)
 #define CHECKHANDLE(x) _debug_winhandle((x), __FUNCTION__, __FILE__, __LINE__)
 #define CHECKMSG(h, m, mp1, mp2) _debug_winmsg((h),m, mp1, mp2, __FUNCTION__, __FILE__, __LINE__)
 #define DEBUG_REQUEST(x) _debug_requestSem();
 #define DEBUG_RELEASE(x) _debug_releaseSem();
 #define PMFN(a,b,c,d) PERF(a##b##c##d)
 #define PM(x) PMFN(x, "(", __FUNCTION__, ")")
 #define VALIDWIN(x) WinIsWindow(WinQueryAnchorBlock(HWND_DESKTOP),(x))
#else
#ifdef __cplusplus
 inline void APIENTRY dprintf(char *s, ...) {}
#else
 static void APIENTRY dprintf(char *s, ...) {}
#endif
 #define BREAKPOINT
 #define ENSURE(x)
 #define VALIDPTR(x)
 #define PT
 #define IF_DEBUG(x)
 #define CHECKDOS(x)
 #define CHECKPM(x)
 #define CHECKHANDLE(x)
 #define CHECKMSG(h, m, mp1, mp2)
 #define DEBUG_REQUEST(x)
 #define DEBUG_RELEASE(x)
 #define PM(x)
 #define VALIDWIN(x)
#endif

#endif
