/******************************************************************************\
*                                                                              *
*  c't OS/2 Editor v0.7                                                        *
*                                                                              *
*  Modul:     enhframe.cpp                                                     *
*  Aufgabe:   Toolbar, Statusbar, MLE als Framecontrols.                       *
*             (bevorzugte Lsung)                                              *
*                                                                              *
\******************************************************************************/
#include "common.h"
#pragma hdrstop
#include "toolbar.h"
#include "statbar.h"
#include "debug.h"
#include "ctedit.h"
#include "editor.h"

// neue frame window procedure
MRESULT EXPENTRY newFrameWndProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);
extern "C" void ctSetHelptext(HWND frame, ULONG msg, MPARAM mp1, MPARAM mp2);

// alte frame window procedure
static PFNWP oldFrameProc;

/* Define the new frame window proc */
extern "C" HWND EnhWinCreateStdWindow(HWND    hwndParent,
                           ULONG   flStyle,
                           PULONG  flags,
                           PSZ     clientClass,
                           PSZ     title,
                           ULONG   styleClient,
                           HMODULE hmod,
                           ULONG   id,
                           PHWND   hwndClient,
                           void    *parameter
                           )
  {
  FRAMECDATA fcd;
  HWND hwndFrame, hwnd;

  fcd.cb=sizeof(FRAMECDATA);
  fcd.flCreateFlags=*flags;
  fcd.hmodResources=hmod;
  fcd.idResources=id;

  /* registriere Toolbar (falls noch nicht geschehen) */
  registerToolbar(0);

  /* Mache Frame */
  hwndFrame=WinCreateWindow(HWND_DESKTOP,
                            WC_FRAME,
                            title,
                            0,0,0,0,0,
                            0,
                            HWND_TOP,
                            id,
                            &fcd,
                            0);
  ensure(validwin(hwndFrame));

  /* Toolbar */
  hwnd=WinCreateWindow(hwndFrame,
                  "ctToolbar",
                  "",
                  0,10,10,10,50,
                  hwndFrame,
                  HWND_TOP,
                  FID_TOOLBAR,
                  0,
                  0);
  ensure(validwin(hwnd));

  /* Statusbar */
  hwnd=WinCreateWindow(hwndFrame,
                  "ctStatusbar",
                  "Statusbar",
                  0,0,0,0,0,
                  hwndFrame,
                  HWND_TOP,
                  FID_STATUSBAR,
                  0,
                  0);
  ensure(validwin(hwnd));

  /* und Client */
  *hwndClient=WinCreateWindow(hwndFrame,
                              clientClass,
                              0,
                              MLS_HSCROLL|MLS_VSCROLL,
                              0,0,0,0,
                              hwndFrame,
                              HWND_BOTTOM,
                              FID_CLIENT,
                              0,0);
  ensure(validwin(*hwndClient));

  /* Subclassen (WM_CREATE kommt nicht mehr an!) */
  oldFrameProc=WinSubclassWindow(hwndFrame, newFrameWndProc);
  ensure(oldFrameProc!=0);

  /* setze window word */
  BOOL rc=WinSetWindowPtr(hwndFrame, QWL_USER, parameter);
  ensure(rc!=FALSE);
  ensure(validread(parameter));

  /* gib frame handle zurck */
  return hwndFrame;
  }


/* Name     : newFrameWndProc
** Task     : gesubclasster Frame
** Input    : HWND hwnd                 - window handle
              ULONG msg                 - Message
              MPARAM mp1                - Parameter 1
              MPARAM mp2                - Parameter 2
*/
MRESULT EXPENTRY newFrameWndProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
  {
  HWND hwndToolbar;
  MRESULT result;

  Editor *edit=(Editor *)WinQueryWindowPtr(hwnd, QWL_USER);
  if (edit)
     edit->pmmsg(hwnd, msg, mp1, mp2);

  /* Spezielle Behandlung */
  if (msg>=WM_USER || msg==WM_SAVEAPPLICATION)
     return ctEditorProc(hwnd, msg, mp1, mp2);

  switch(msg)
     {
     /* WM_CALCFRAMERECT wird geschickt, um die Gre des Frames/Clients */
     /* zu erfragen. Ist mp2==TRUE, so wird nach dem Client gefragt, so  */
     /* dessen neue Gre zurckgegeben werden mu */
     case WM_CALCFRAMERECT:
       result= (*oldFrameProc)(hwnd, msg, mp1, mp2);

       if (result && mp2)
          {
          PRECTL prectl;
          prectl = (PRECTL) mp1;
          prectl->yTop-=   (40+20);
          prectl->yBottom+=20;
          } /* endif: result && mp2 */
       return result;

     case WM_FORMATFRAME:
       {
       SHORT countSwp;
       int i;
       PRECTL prectl;
       PSWP  pswp, pswpClient=0, pswpToolbar=0, pswpStatusbar=0;
       SWP tmpSwp;
       int cy;
       SWP  swp, *sav;

       /* Gre/Position der Frame controls (s. Artikel) */
       countSwp = (int) (*oldFrameProc)(hwnd, msg, mp1, mp2);

       pswp=(PSWP)mp1;

       ensure(validwin(WinWindowFromID(hwnd, FID_TOOLBAR)));
       WinQueryWindowPos(WinWindowFromID(hwnd, FID_TOOLBAR), &swp);
       cy=swp.cy;

       sav=pswpToolbar=&pswp[countSwp-1];
       pswpStatusbar=&pswp[countSwp];
       pswpClient=&pswp[countSwp+1];

      *pswpStatusbar = *sav;
      *pswpClient = *sav;

       pswpClient->y  += 20;
       pswpClient->cy -= 20+cy;

       pswpToolbar->hwnd=WinWindowFromID(hwnd, FID_TOOLBAR);
       pswpToolbar->y  = (pswpClient->y+pswpClient->cy);
       pswpToolbar->cy = cy/*50*/;

       ensure(validwin(WinWindowFromID(hwnd, FID_STATUSBAR)));
       pswpStatusbar->hwnd=WinWindowFromID(hwnd, FID_STATUSBAR);
       pswpStatusbar->y  = pswpClient->y - 20;
       pswpStatusbar->cy = 20;
       return MRFROMSHORT(countSwp+2);
       } /* endswitch: msg */

     case WM_QUERYFRAMECTLCOUNT:
       /* Anzahl der Frame controls (jetzt mehr) */
       return MRFROMSHORT((ULONG)((*oldFrameProc)(hwnd, msg, mp1, mp2))+2);

     /* diese beiden Messages an eigene Funktion delegieren */
     case WM_COMMAND:
     case WM_CONTROL:
        return ctEditorProc(hwnd, msg, mp1, mp2);

     /* WM_MENUSELECT wird geschickt, wenn der Benutzer zwischen menitems */
     /* wechselt */
     case WM_MENUSELECT:
        ctSetHelptext(hwnd, msg, mp1, mp2);
        return (MRESULT)TRUE;

     /* Standardbehandlung */
     default:
        return (*oldFrameProc)(hwnd, msg, mp1, mp2);

     } /* newFrameWndProc */
  return FALSE;
  }
