#include "common.h"
#include "bedit.hh"
#ifdef DTS_NOIDL
#include "editor.h"
#else
#include "somedit.hh"
#endif
#include "api.h"
#include <som.hh>
#include "debug.h"

extern HMODULE module;

extern "C" int _CRT_init(void);
extern "C" void __ctordtorInit(void);
extern "C" void _CRT_term(void);
extern "C" void __ctordtorTerm(void);

void forAllModulesDo(HMODULE hmod, char *env, char *subdir, void (*fn)(char *fullname));

/* Name     : replaceClass
** Aufgabe  :
** Parameter: char *dllname             -
** Rckgabe :
*/
void replaceClass(char *dllname)
  {
  APIRET rc;
  PFN pfn;
  char loadError[100];
  char classname[100];
  static char editorclass[100];
  HMODULE mod;

  if (editorclass[0]=='\0')
     strcpy(editorclass, "SOMEditor");

  rc=DosLoadModule((PSZ)loadError, 100, (PSZ)dllname, &mod);
  if (rc) return;

  classname[0]='\0';
  rc=DosQueryProcAddr(mod, 0, (PSZ)"queryClassName", (PFN*)&pfn);
  if (rc==0)
     strcpy(classname, (char *)((*pfn)()));
  DosFreeModule(mod);

  if (classname[0])
     {
     somToken tk;
     rc=SOMLoadModule(classname, dllname, "SOMInitModule", 1, 0, &tk);
     if (rc) return;
     DosBeep(((!rc) ? 1000 : 100), 200);
     SOMClassMgrObject->somSubstituteClass(editorclass, classname);
     dprintf("Replace: %s -> %s\n", classname, editorclass);
     strcpy(editorclass, classname);
     } /* endif: classname[0] */
  } /* replaceClass */



/* Name     : initClass
** Aufgabe  :
** Rckgabe :
*/
void initClass()
  {
  int rc;
  SOMBaseEditorNewClass(1,0);
  SOMEditorNewClass(1,0);

  forAllModulesDo(module, "EDITSOMDLL", "SOMEDIT", replaceClass);
  } /* initClass */

extern "C" APIENTRY _DLL_InitTerm(unsigned long modhandle, unsigned long flag)
  {
  module=modhandle;

  switch(flag)
     {
     case 0:  if (_CRT_init()!=0) return 0;
              __ctordtorInit();
              loadAllDll();
              CallDllInit();
              initClass();
              return 1;
     case 1:  __ctordtorTerm();
              _CRT_term();
              return 1;
     default: return 0;
     } /* endswitch: flag */
  }

extern "C" void _Export APIENTRY SOMInitModule(long,long,char*)
  {
  initClass();
  }
