#ifndef _EDITOR_H_
#define _EDITOR_H_

#include <somobj.hh>
#include "common.h"
#include "debug.h"
#include "action.h"
#include "string.h"
#include "toolbar.h"
#include "statbar.h"
#include "menu.h"
#include "edit.h"
#include "ctedit.h"
#include "edit.h"
#include "api.h"
#include "sema4.h"
#include "thread.h"

void initDefaultAction(ActionList& list);
extern void save(HWND hwnd, char *name);
extern void load(HWND hwnd, char *name);
BOOL loadMLE(HWND hwnd, char *name);

#define USER_OFFSET_ID 1000

class Editor : public SOMObject
  {
    HWND       frame;
    HWND       toolbar;
    HWND       mle;
    HWND       statusbar;
    EString    name;
    ActionList actionlist;
    FATTRS     mfont;
    FATTRS     pfont;
    BOOL       font;                         /* monospaced oder proportional */
    BOOL       showToolbar;
    BOOL       indent;
    BOOL       quickmark;
    int        maxline;
    int        curline;
    int        modified;
    int        updateStatus;
    int        current_id;
    int        current_cid;
    int        curcol;
    HWND       contextMenu;
  public:
    Editor();
    virtual ~Editor() {}

// "interne" Informationen
    virtual HWND       queryFrame()                   { return frame; }
    virtual HWND       queryContextMenu()             { return contextMenu; }
    virtual HWND       queryToolbar()                 { return toolbar; }
    virtual HWND       queryMle()                     { return mle; }

// Datei (laden, speichern, exportieren, ...)
    virtual char      *queryName()                    { return (char *)name; }
    virtual char      *setName(char *x);
    virtual void       load(char *s);
    virtual void       save(char *s=0);
    virtual BOOL       getText(char *buffer, int length, int pos=0);
    virtual BOOL       getTextLine(char *buffer, int length, int line);
    virtual void       loadini();
    virtual void       saveini();

// Editieren (cut, paste, ...)
    virtual void       add(char *text, BOOL changeCurPos=FALSE, int offset=-1);  // Hinzufgen an der akt. Cursorpos
    virtual void       addLine(char *text, BOOL changeCurPos, int offset=-1);
    virtual BOOL       isChanged();
    virtual void       clear();
    virtual void       clearAll() { setText(""); }
    virtual void       copy();
    virtual void       cut();
    virtual void       paste();
    virtual void       insert(char *text);
    virtual void       discard();     // delete marked text
    virtual void       undo();
    virtual void       markall();
    virtual void       disableUpdate();
    virtual void       enableUpdate();
    virtual void       setWordWrap(BOOL w=TRUE);
    virtual BOOL       queryWordWrap();
    virtual void       setReadOnly(BOOL set=TRUE);
    virtual BOOL       queryReadOnly();
    virtual void       setChangedFlag(BOOL c);
    virtual void       resetChangedFlag() { setChangedFlag(FALSE); }
    virtual void       removeLine(int line);
    virtual int        queryNrOfLines();
    virtual void       setText(char *);
    virtual int        queryTextLength();

// Cursor
    virtual int        queryCurrentLine();
    virtual int        queryCurrentCol();
    virtual int        queryCurrentCurPos();

    virtual void       setCurrentLine(int line);
    virtual void       setCurrentCol(int col);
    virtual void       setCurrentCurPos(int pos);

// Features (Toolbar, ...)
    virtual void       setStatusText(char *s)
                          { WinSendMsg(statusbar, SB_SETTEXT, (MPARAM)s, 0); }
    virtual BOOL       queryIndent() { return indent; }
    virtual void       setIndent(BOOL b);
    virtual BOOL       queryQuickmark() { return quickmark; }
    virtual void       setQuickmark(BOOL b);
    virtual BOOL       queryHideToolbar();
    virtual void       hideToolbar(BOOL b);
    virtual ActionFnPtr addToolbarButton(ActionFnPtr p, char *s1, char *s2,
                         int *id=0, HMODULE h=0, unsigned r=0);
    virtual ActionFnPtr addMenuItem(ActionFnPtr p, int mainmenu, char *s1, char *s2,
                         int *id=0, HMODULE h=0, unsigned r=0);
    virtual int        addContextMenu(ActionFnPtr p, int mainmenu, char *entry, char *description);
    virtual BOOL       doAction(int i);
    virtual BOOL       search(char *s, int offset=-1);

// Hilfsfunktionen
    virtual void       setConditionalMenu(int submenuid, int defaultid)
                          { ::setConditionalMenu(frame, submenuid, defaultid); }
    virtual void       setMenuChecked(int id, BOOL set=TRUE)
                          { ::setMenuChecked(frame, id, set); }
// Farbe
    virtual void       setColor(int color)
                          { WinPostMsg(mle, MLM_SETBACKCOLOR, (MPARAM)color, 0); }
    virtual unsigned   queryBkColor(unsigned color=CLR_WHITE);
    virtual void       setBkColor(unsigned color=CLR_WHITE);
    virtual unsigned   queryFgColor(unsigned color=CLR_BLACK);
    virtual void       setFgColor(unsigned color=CLR_BLACK);

// Font
    virtual void       setFonttype(BOOL b) { font=b; }
    virtual BOOL       queryFonttype() { return font; }
/*
    virtual FATTRS&    queryMonoFont() { return mfont; }
    virtual FATTRS&    queryPropFont() { return pfont; }
    virtual void       setFont(char *name=0, int size=0, int monospaced=-1);
    virtual void       setFont(FATTRS& f);
*/

// "interne" Funktionen, sollten vorsichtig benutzt werden
    virtual Action    *queryAction(unsigned id);
    virtual char      *queryHelptext(unsigned id);
    virtual void       setFrame(HWND h)               { frame=h; }
    virtual void       setToolbar(HWND h)             { toolbar=h; }
    virtual void       setStatusbar(HWND h)           { statusbar=h; }
    virtual void       setMle(HWND h)                 { mle=h; }
    virtual void       setMaxLine(int i)
                          { updateStatus=updateStatus || (i!=maxline); maxline=i; }
    virtual void       setCurLine(int i)
                          { updateStatus=updateStatus || (i!=curline); curline=i; }
    virtual void       setCurColumn(int i)
                          { updateStatus=updateStatus || (i!=curcol); curcol=i; }
    virtual void       setModified(int i)
                          { updateStatus=updateStatus || (i!=modified); modified=i; }
    virtual void       updateStatusline(int force=FALSE);
    virtual void       cleanContextMenu();
    virtual void       setInitFile(char *s) { name=s; }
    virtual void       process();
    virtual void       threadEntry() { process(); }
    virtual void       usermsg(MPARAM mp1, MPARAM mp2) {}
    virtual void       charmsg(MPARAM mp1, MPARAM mp2) {}
    virtual void       init() {}
  };

#endif
