
//
// Projekt Raycast-Engine
// 1995 by Stefan Becker
//
// Error.c
// Standard-Fehlerroutinen (komplett Mac-spezifisch)
//

//
// ANSI-Headerdateien:
//

#include	<stdio.h>
#include	<stdlib.h>

//
// MacOS-Header:
//

#include	<Dialogs.h>		// Fr Mac-Alarmboxen

//
// Eigene Includes:
//

#include	"Globals.h"		// Allg. "RaycastEngine"-Definitionen

//
// Aus C-String einen Pascal-String (max. 255 Zeichen!) machen:
//

void cstr2pas(char *cstr, Str255 pstr)
{
	short	len;
	char	*pptr;

	// Legaler Aufruf?
	if(cstr==nil || pstr==nil)
		return;	// Urgcks! Finger weg!

	len = 0;						// Noch kein Zeichen kopiert
	pptr = (char*)&pstr[1];			// Zeiger auf 1. Zeichen im Pascal-String
	while(*cstr && len<255-1)		// Solange noch was da ist und weniger als 255 Z. kopiert
	{
		*pptr++ = *cstr++;			// Zeichen kopieren
		len++;						// Eben 1 Zeichen mehr als sonst
	}
	pstr[0] = len;					// Lnge in String eintragen
}

//
// Fehlermeldung in Alarmbox ausgeben:
//

void error(char *msg)
{
	Str255	str;							// Pascal-String

	cstr2pas(msg,str);						// Aus dem C-String Pascal-String machen
	ParamText(str,"\p","\p","\p");			// ^0-Parameter durch eine Nachricht ersetzen
	Alert(ALERT_ID,nil);					// Alarmbox ffnen
}

//
// Programmabruch mit Fehlermeldung in Alarmbox:
//

void fatal_error(char *msg)
{
	Str255	str;							// Pascal-String

	cstr2pas(msg,str);						// Aus dem C-String Pascal-String machen
	ParamText(str,"\p","\p","\p");			// ^0-Parameter durch eine Nachricht ersetzen
	Alert(FATAL_ALERT_ID,nil);				// Alarmbox ffnen
	ExitToShell();							// Programm beenden
}

//
// Ende von Error.c
//
