
//
// Globals.h
// Projekt-Raycast
// (C)1995 by Stefan Becker
//

#ifndef	GLOBALS_H		// Damit es nicht doppelt verwendet wird
#define	GLOBALS_H		// Prprozessor-Flagge gegen doppelte Verwendung

#define	_NO_BRESENHAM_	// Falls dies an ist, dann wird KEIN Bresenham verwendet
						// Das geht natrlich ERHEBLICH schneller.

#include	"Error.pro"	// Fehler-Handling soll IMMER gehen

//
// Konstanten:
//

#define		M_PI			3.141592653589793	// Maschinendarstellung von 

#define		TURN_LEFT		'a'	// Tasten, die fr Aktion gedrckt werden mssen
#define		TURN_RIGHT		'd'	// rechtsherum drehen
#define		WALK_FORW		'w'	// vorwrts laufen
#define		WALK_BACKW		's'	// rckwrts laufen

#define		TURN_INC		30	// Winkelnderung beim Drehen des Spielers
#define		WALK_INC		30	// Lnge eines "Spieler-Schrittes"

#define		MAZE_X			16	// Gre des begehbaren Spielfeldes
#define		MAZE_Y			16	// 16x16 Felder

#define		TEX_SIZE		128	// Gre der quadratischen Textur in Pixeln

#define		MAZE_MAX_X		(MAZE_X * TEX_SIZE)	// Grte X-Position in Pixeln
#define		MAZE_MAX_Y		(MAZE_Y * TEX_SIZE)	// Grte Y-Position in Pixeln

#define		XAUF			320	// Gre der im Fenster erzeugten Grafik in Pixeln
#define		YAUF			320

#define		BLICK_WINKEL	60	// Blickwinkel der Person in Grad

#define		ANZ_WINKEL		((360*XAUF)/BLICK_WINKEL)	// So viele Drehwinkel gibt es

#define		TEXTURE_DEPTH	8	// Bit/Pixel der Textur

#define		EPSILON			1.0E-8	// Schranke fr unscharfen Null-Test

#define		MAX_SICHT		10000	// Maximale Sichtweite

#define		PERSPEKTIVE		25000	// Wie gro sind Objekte in welcher Entfernung?

//
// IDs fr Resource-Objekte (Mac spezifisch):
//

#define		WINDOW_ID		128		// ID des im Resource vordefinierten Fensters
#define 	TEXTURE_ID		128		// ID des im Resource vordefinierten Textur-PICTs
#define		UHH_SOUND_ID	128		// ID des im Resource gespeicherten "Uhhh"-Sounds
#define		ALERT_ID		128		// ID der Standard-Alarmbox im Resource
#define		FATAL_ALERT_ID	129		// ID der Alarmbox fr fatale Fehler im Resource
#define		COPYR_ALERT_ID	130		// Copyright-Alarmbox

//
// Makros:
//

#define	ABS(x)		(((x)>=0) ? (x) : (-(x)))	// Standard-Abs-Makro
#define	MIN(x,y)	(((x)<=(y)) ? (x) : (y))	// Standard-Min-Makro
#define	MAX(x,y)	(((x)>=(y)) ? (x) : (y))	// Standard-Max-Makro

//
// Typen:
//

typedef	char	MAZE[MAZE_X][MAZE_Y+1];	// Typ einer begehbaren Landschaft
										// (+1 wegen String-Terminierung)
typedef	float	WINKEL_TAB[ANZ_WINKEL];	// Typ einer Winkel-Tabelle
typedef	float	SKIP_TAB[ANZ_WINKEL];	// Typ einer Skip-Tabelle

#endif					// Ende des Prprozessor-If

//
// Globals.h
//
