/*****************************************************************************/
/* program: display.c        * date: 29.11.94 * Autor: Hans Georg Frey       */
/*****************************************************************************/
/* Usage: Modul fr Ein- und Ausgabemasken zum Programm.                     */
/*                                                                           */
/*                                                                           */
/****************** MODIFIED *************************************************/
/* date:*  By:   * what:                                             * Vers. */
/*****************************************************************************/
/*                                                                      1.0  */
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
#include <stdio.h>                             /*  Veraltetes Listing: *     */
#include <stdlib.h>                            /******************************/
#include <stdlib.h>
#include <math.h>
#include "display.h"
#include "system.h"
#include "backp.h"

                       /* Einagabemaske des Hauptprogramms */
int EingabeMaske( NetzParameter sp_NetzParameter, int ai_NetzSchichten[] )
{
  int ret_val;

  n_clrscr();
  write_str( 15,  2, "Beenden                         (0)" );
  write_str( 15,  3, "Netz konfigurieren              (1)" );
  write_str( 15,  4, "Musterdaten laden (Kruse u.a.)  (2)" );
  write_str( 15,  5, "Eingangsdatenstrom              (3)" );
  write_str( 15,  6, "Laden eines gelernten Netzes    (4)" );
  write_str( 15,  7, "Speichern des aktuellen Netzes  (5)" );
  write_str( 15,  8, "Parameter veraendern            (6)" );
  write_str( 15,  9, "Trainieren                      (7)" );
  write_str( 15, 10, "Testen                          (8)" );
  write_str( 15, 11, "Gewichte zuruecksetzen          (9)" );

  n_gotoxy( 53, 3 );
  printf( "%2d/%2d/%2d/%2d/%2d",ai_NetzSchichten[0],ai_NetzSchichten[1]
          , ai_NetzSchichten[2],ai_NetzSchichten[3],ai_NetzSchichten[4] );
  fflush( stdout );
  write_str( 53, 4, sp_NetzParameter.c_MusterDatei );
  n_gotoxy( 5, 16 );
  printf( "Lernrate: %4.2f", sp_NetzParameter.Lernrate );
  fflush( stdout );
  n_gotoxy( 5, 17 );
  printf( "Momentum: %4.2f", sp_NetzParameter.Momentum );
  fflush( stdout );
  n_gotoxy( 5, 18 );
  printf( "seed: %lu", sp_NetzParameter.ul_Seed );
  fflush( stdout );
  n_gotoxy( 26, 16 );
  printf( "Perioden pro Ausgabe: %3d", sp_NetzParameter.i_PeriodenProAusgabe );
  fflush( stdout );
  n_gotoxy( 26, 17 );
  printf( "Flat Spot: %4.2f", sp_NetzParameter.f_FlatSpot );
  fflush( stdout );
  n_gotoxy( 26, 18 );
  printf( "Weight Decay: %6.4f", sp_NetzParameter.f_WeightDecay );
  fflush( stdout );
  if( sp_NetzParameter.b_ZufallLernen )
    write_str( 5, 19, "Pattern werden zufaellig ausgewaehlt     " );
  else
    write_str( 5, 19, "Pattern werden in Reihenfolge ausgewaehlt" );

  if( sp_NetzParameter.b_Protokoll )
    write_str( 5, 20, "Es wird ein Protokoll angelegt" );
  else
    write_str( 5, 20, "Es wird kein Protokoll angelegt" );

  do
  {
    ret_val = n_GetKey();                      /* Auswahl treffen */
  } while( ret_val < '0' || ret_val > '9' );   /* solange bis im richtigen */
                                               /* Bereich liegt */
  return( ret_val );
}

/****************************************************************************/
void EingabeNetzKonf( int ai_NetzSchichten[], char b_MusterGeladen
                     , NetzParameter* sp_NetzParameter)
{
  char i_SchichtAnzahl;                 /* Anzahl der Netzschichten */
  int  i;                               /* einfacher Zaehler */
  char buffer[80];                      /* temporaerer Speicher */

  n_clrscr();

  if( b_MusterGeladen )                /* Anzahl der Einagngs- und Ausgangs */
  {                                    /* lag bereits fest */
    write_str( 33, 6, "A C H T U N G" );
    write_str( 13, 7, "Es wurde bereits eine Musterdatei geladen. Die Anzahl" );
    write_str( 12, 8, "der Eingangs- und Ausgangsneuronen darf nicht abweichen" );
    write_str( 37, 9, "Taste" );
    n_GetKey();
    n_clrscr();
  }

  if( ai_NetzSchichten[0] != 0 )       /* Es wurde bereits eine Struktur eingegeben */
    for( i=0; i < MAX_SCHICHTEN + 1; i++ ) /* deshalb vorher alles wieder nullen. */
      ai_NetzSchichten[i] = 0;         /* Die neue Struktur wird kpl. neu eingegeben */

  write_str( 10, 10, "Bitte geben Sie die Anzahl der Schichten ein (2-5): " );

  do
  {
    i_SchichtAnzahl = getchar();      /* Anzahl eingeben, bis alles stimmt */
  } while( i_SchichtAnzahl < '2' || i_SchichtAnzahl > '5' );

  i_SchichtAnzahl -= '0';              /* umrechnen von ASCI zu einer Zahl */
  sp_NetzParameter->i_AnzahlDerSchichten = i_SchichtAnzahl;

  for( i=0; i < i_SchichtAnzahl; i++ )
  {
    sprintf( buffer, "Bitte geben Sie die Anzahl der Neuronen der Schicht %d an: "
                    , i+1 );

    write_str( 10, 10, buffer );            /* den Text ausgeben */
    ai_NetzSchichten[i] = n_GetInt();       /* den neuen Wert einlesen */
    write_str( 67, 10, "      " );          /* den Wert wieder loeschen */
  }
}

/*****************************************************************************/
void EingabeLernparameter( NetzParameter* sp_NetzParameter )
{
  int ret_val;

  write_str( 10, 14, "Bitte geben Sie die gewuenschten Werte an" );
  write_str( 5, 19, "Pattern werden zufaellig ausgewaehlt (j/n)" );
  write_str( 5, 20, "Es wird ein Protokoll angelegt (j/n)" );
  n_gotoxy( 21, 16 );
  sp_NetzParameter->Lernrate = n_GetFloat();
  n_gotoxy( 21, 17 );
  sp_NetzParameter->Momentum = n_GetFloat();
  n_gotoxy( 19, 18 );
  sp_NetzParameter->ul_Seed = (unsigned long )n_GetLong();
  n_gotoxy( 52, 16 );
  sp_NetzParameter->i_PeriodenProAusgabe = n_GetInt();
  n_gotoxy( 50, 17 );
  sp_NetzParameter->f_FlatSpot = n_GetFloat();
  n_gotoxy( 52, 18 );
  sp_NetzParameter->f_WeightDecay = n_GetFloat();
  do
  {
    n_gotoxy( 50, 19 );
    ret_val = getchar();                      /* Auswahl treffen */
  }while( ret_val != 'j' && ret_val != 'n' );

  if( ret_val == 'j' )
    sp_NetzParameter->b_ZufallLernen = TRUE;
  else
    sp_NetzParameter->b_ZufallLernen = FALSE;

  do
  {
    n_gotoxy( 50, 20 );
    ret_val = getchar();                      /* Auswahl treffen */
  }while( ret_val != 'j' && ret_val != 'n' );

  if( ret_val == 'j' )
    sp_NetzParameter->b_Protokoll = TRUE;
  else
    sp_NetzParameter->b_Protokoll = FALSE;

}

/*****************************************************************************/
int EingabeImage( ImageParameter s_ImageParameter )
{
  int ret_val;

  n_clrscr();
  write_str( 15,  2, "Zurueck zum Hauptmenue          (0)" );
  write_str( 15,  3, "Bild aufnehmen                  (1)" );
  write_str( 15,  4, "Bild testen                     (2)" );
  write_str( 15,  5, "Parameter aendern               (3)" );
  write_str( 15,  6, "Musterdatei anlegen             (4)" );
  write_str( 15,  7, "Bildadresse festlegen           (5)" );

  n_gotoxy( 15, 12 );
  printf( "Image Groesse     : %3d", s_ImageParameter.i_ImageSize );
  fflush( stdout );
  n_gotoxy( 15, 13 );
  printf( "Transform Groesse : %3d", s_ImageParameter.i_TransformSize );
  fflush( stdout );
  n_gotoxy( 15, 14 );
  printf( "Pixeldifferenz    : %3d", s_ImageParameter.i_PixelDifferenz);
  fflush( stdout );
  n_gotoxy( 15, 15 );
  printf( "Skalierung        : %5.1f", s_ImageParameter.d_Skalierung );
  fflush( stdout );
  if( s_ImageParameter.Bp_TakePic == COMP_PIC+s_ImageParameter.i_TransformSize )
    write_str( 15, 16, "Startadresse ist die des transformierten Bildes" );
  else
    write_str( 15, 16, "Startadresse ist die des komprimierten Bildes  " );

  n_gotoxy( 50, 7 );
  do
  {
    ret_val = n_GetKey();                      /* Auswahl treffen */
  } while( ret_val < '0' || ret_val > '5' );   /* solange bis im richtigen */
                                               /* Bereich liegt */

  return( ret_val );
}

/*****************************************************************************/
void  EingabeImageParameter( ImageParameter* s_ImageParameter )
{

  n_clrscr();

  write_str( 10,  3, "Es wird von einem quadratischen Bild ausgegangen" );
  write_str( 10,  6, "Bitte geben Sie die Image Groesse als Zweierpotenz ein:     " );
  s_ImageParameter->i_ImageSize = n_GetInt();
  s_ImageParameter->i_ImageSize <<= s_ImageParameter->i_ImageSize;
  write_str( 10,  7, "Bitte geben Sie die Zweierpotenz der Transform Groesse ein: " );
  s_ImageParameter->i_Potenz = n_GetInt();
  write_str( 10,  8, "Bitte geben Sie die Skalierung ein:                         " );
  s_ImageParameter->d_Skalierung = (double )n_GetFloat();

  s_ImageParameter->i_TransformSize = 1 << s_ImageParameter->i_Potenz;
  s_ImageParameter->i_PixelDifferenz =
      s_ImageParameter->i_ImageSize/s_ImageParameter->i_TransformSize;
}
