/*****************************************************************************/
/* program: transfer.c       * date: 20.11.94 * Autor: Hans Georg Frey       */
/*****************************************************************************/
/* Usage: Laden und speichern von Mustern zu backp.c                         */
/*                                                                           */
/****************** MODIFIED**************************************************/
/* date:*  By:   * what:                                             * Vers. */
/*****************************************************************************/
/*                                                                      1.0  */
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
#include <stdio.h>                             /** Veraltetes Listing: *     */
#include "backp.h"                             /******************************/
#include "transfer.h"
#include "system.h"
#include "train.h"
#include <stdlib.h>
#include <time.h>
#include <string.h>


FILE*  t_ProtokollFile;
char   b_ProtokollFileOffen=FALSE;


Pattern* PatternLaden( int ai_NetzSchichten[], NetzParameter* sp_NetzParameter )
{
  Pattern* p_Pattern;                  /* Pointer auf das aktuelle Muster */
  Pattern* p_FirstPattern;             /* Pointer auf das erste Muster */
  Pattern* p_VorherigesPattern;        /* OS9 behandelt eof nicht wie DOS */
                                       /* deshalb wird das letzte Pattern geloescht*/
                                       /* da es gar nicht existiert */
                                       /* Dies Loesung ist nicht schoen aber einfach */
  int      i_EingabeZeilen, i_EingabeSpalten;
  int      i_AusgabeZeilen, i_AusgabeSpalten;
  char     cp_PatternFile[80];         /* Name der Musterdatei */
  FILE*    t_PatternFile;              /* Filedeskriptor der Musterdatei */
  int      i, j, k;                    /* einfache Zaehler */
  int      i_PatternZaehler;           /* Anzahl der Pattern mitzaehlen */
  char     First;                      /* erstes Pattern */
  float    f_Temp;

  n_clrscr();                          /* Ist der Name der Datei schon bekannt */
  if( strlen( sp_NetzParameter->c_MusterDatei ) == 0 ) /* Wenn aus Gewichte */
  {                                    /* laden gekommen ist dem so */
    write_str( 10, 10, "Bitte geben Sie den Namen der Musterdatei ein: " );
    scanf( "%s", cp_PatternFile );      /* Name der Musterdatei lesen */
    strcat( cp_PatternFile, ".pat" );   /* Suffix fuer Pattern anhaengen */
  }
  else
    strcpy( cp_PatternFile, sp_NetzParameter->c_MusterDatei );

  if(( t_PatternFile = fopen( cp_PatternFile, "r" )) == NULL )
  {                                    /* Die Datei kann nicht geoeffnet werden */
    write_str( 20, 12, "Die Datei konnte nicht geoeffnet werden" );
    write_str( 37, 14, "Taste" );
    n_GetKey();
    return NULL;
  }

  strcpy( sp_NetzParameter->c_MusterDatei, cp_PatternFile );
  write_str( 10, 12, "Laden der Musterdatei" );
                                 /* Anzahl der Eingabe- und Ausgabeneuronen */
  fscanf( t_PatternFile, "%d", &i_EingabeZeilen  );
  fscanf( t_PatternFile, "%d", &i_EingabeSpalten );
  fscanf( t_PatternFile, "%d", &i_AusgabeZeilen  );
  fscanf( t_PatternFile, "%d", &i_AusgabeSpalten );

  First = TRUE;
  i_PatternZaehler = 0;

  while( ! feof( t_PatternFile ))
  {
#ifdef _OSK
    p_VorherigesPattern = p_Pattern;
#endif
    if( First )                        /* Die Adresse des ersten Pattern merken */
    {                                  /* Das erste mal direkt nach p_Pattern */
      if(( p_Pattern = (Pattern* )malloc( sizeof( Pattern )))==NULL)
      {                                /* kein Speicher da */
        write_str( 10, 20, "Fehler bei Speicheranforderung [97]" );
        exit( 1 );
      }
      p_FirstPattern = p_Pattern;      /* Erste Adresse der Liste merken */
      First = FALSE ;                  /* nur beim ersten durchlauf */
    }                                  /* sonst Liste verketten */
    else
    {                                  /* Speicher holen */
      if(( p_Pattern->p_next = (Pattern* )malloc(
                                  sizeof( Pattern ))) == NULL)
      {
        write_str( 10, 20, "Fehler beim allociern von Speicher [108]" );
        exit( 1 );
      }                                /* Liste verketten */
      p_Pattern = p_Pattern->p_next;
    }

    p_Pattern->p_next = NULL;          /* Da vorerst der Letzte -> NULL */

                                       /* Speicher fuer die Muster, + 1 fuer BIAS */
    if(( p_Pattern->fp_OneInput = ( float* )malloc(
          sizeof( float )*(i_EingabeZeilen*i_EingabeSpalten + 1) )) == NULL )
    {                                  /* Eingabewerte */
      write_str( 10, 20, "Fehler beim allociern von Speicher [119]" );
      exit( 1 );
    }                                  /* Ausgabewerte */
    if(( p_Pattern->fp_OneOutput = ( float* )malloc(
                 sizeof( float )*i_AusgabeZeilen*i_AusgabeSpalten )) == NULL )
    {
      write_str( 10, 20, "Fehler beim allociern von Speicher [125]" );
      exit( 1 );
    }

    k = 0;                            /* Eingabemuster einlesen */
    for( i=0; i < i_EingabeZeilen; i++ )
      for( j=0; j < i_EingabeSpalten; j++ )
      {                                /* scanf kennt nur float -> alles ein */
        fscanf( t_PatternFile, "%f", &f_Temp ); /* wenig umstaendlich */
        p_Pattern->fp_OneInput[k] = f_Temp - 0.5;
        k++;
      }
    p_Pattern->fp_OneInput[k] = 1;     /* Faktor fuer BIAS ist eins */

                                 /* Sollausgabedaten einlesen */
    k = 0;
    for( i=0; i < i_AusgabeZeilen; i++ )
      for( j=0; j < i_AusgabeSpalten; j++ )
      {                                /* scanf kennt nur float -> alles ein */
        fscanf( t_PatternFile, "%f", &f_Temp ); /* wenig umstaendlich */
        p_Pattern->fp_OneOutput[k] = f_Temp;
        k++;
      }
    i_PatternZaehler++;
    n_gotoxy( 38, 12 );
    printf( "%4d", i_PatternZaehler );
    fflush( stdout );
  } /* while( ! feof( t_PatternFile )) */

#ifdef _OSK                            /* unter OS9 gibt es Schwierigkeiten */
  free( p_Pattern );                   /* mit feof(), daher mu hier etwas */
  p_VorherigesPattern->p_next = NULL;  /* drumherum progrmmiert werden */
#endif

  sp_NetzParameter->i_AnzahlDerPattern = i_PatternZaehler-1;

  fclose( t_PatternFile );             /* Musterdatei wieder schliessen */

  if( ai_NetzSchichten[0] != 0 )       /* Es liegt schon eine Struktur vor */
  {
    ai_NetzSchichten[0] = i_EingabeZeilen * i_EingabeSpalten;
    i = 0;                             /* Wieviele Schichten hat das Netz */
    while( ai_NetzSchichten[++i] != 0 );
    i--;                               /* Ausgabeneuronen eintragen */
    ai_NetzSchichten[i] = i_AusgabeZeilen * i_AusgabeSpalten;
  }
  else                                 /* Es liegt noch keine Netzstruktur vor */
  {
    ai_NetzSchichten[0] = i_EingabeZeilen*i_EingabeSpalten;
    ai_NetzSchichten[1] = i_AusgabeZeilen*i_AusgabeSpalten;
    sp_NetzParameter->i_AnzahlDerSchichten = 2;
  }
                                       /* Pointer auf das erste Pattern wieder */
  return p_FirstPattern;               /* an das Hauptprogramm zuruerckgeben */
}

/****************************************************************************/
void PatternLoeschen( Pattern* p_Pattern )
{
  Pattern* p_LoeschPattern;

  do                                   /* Den Speicher fuer die Muster */
  {                                    /* wieder freigeben */
    p_LoeschPattern = p_Pattern->p_next;
    free( p_Pattern->fp_OneInput );
    free( p_Pattern->fp_OneOutput );
    free( p_Pattern );
    p_Pattern = p_LoeschPattern;
  } while( p_Pattern != NULL );

}
/****************************************************************************/
void ProtokollAnlegen( NetzParameter* sp_NetzParameter, int ai_NetzSchichten[] )
{
  static char       cp_FileName[80];
  time_t     secs_now;
  struct tm* time_now;
  int        i;
                                       /* Soll und kann den etwas getan werden */
  if( sp_NetzParameter->b_Protokoll && b_ProtokollFileOffen == FALSE )
  {
    time( &secs_now );                 /* Zeit merken */
    time_now = localtime( &secs_now );
    strftime( cp_FileName, sizeof( cp_FileName ), "%j%H%M.pro", time_now );
    if(( t_ProtokollFile = fopen( cp_FileName, "w" )) == NULL )
    {                                    /* Die Datei kann nicht geoeffnet werden */
      write_str( 20, 12, "Die Protokolldatei konnte nicht geoeffnet werden" );
      write_str( 37, 14, "Taste" );
      n_GetKey();
      return;
    }
    strcpy( sp_NetzParameter->c_ProDatei, cp_FileName );
    b_ProtokollFileOffen = TRUE;
    fprintf( t_ProtokollFile, " %s  %s\n", sp_NetzParameter->c_MusterDatei
                                         , cp_FileName );
    fprintf( t_ProtokollFile, "Lernrate, Momentum Zufall Schichten Pattern\n" );
    fprintf( t_ProtokollFile, "%4.2f    %4.2f    %x    %d    %d  %u %4.2f\n"
      , sp_NetzParameter->Lernrate, sp_NetzParameter->Momentum
      , sp_NetzParameter->b_ZufallLernen, sp_NetzParameter->i_AnzahlDerSchichten
      , sp_NetzParameter->i_AnzahlDerPattern
      , sp_NetzParameter->ul_Seed
      , sp_NetzParameter->f_FlatSpot );
    for( i=0; i < MAX_SCHICHTEN; i++ )
      fprintf( t_ProtokollFile, "%2d ", ai_NetzSchichten[i] );

  }
  else if( sp_NetzParameter->b_Protokoll && t_ProtokollFile != NULL )
  {
    fprintf( t_ProtokollFile, " %s  %s\n", sp_NetzParameter->c_MusterDatei
                                         , cp_FileName );
    fprintf( t_ProtokollFile, "Lernrate, Momentum Zufall Schichten Pattern" );
    fprintf( t_ProtokollFile, "%4.2f    %4.2f    %x    %d    %d  %u  %4.2f\n"
      , sp_NetzParameter->Lernrate, sp_NetzParameter->Momentum
      , sp_NetzParameter->b_ZufallLernen, sp_NetzParameter->i_AnzahlDerSchichten
      , sp_NetzParameter->i_AnzahlDerPattern
      , sp_NetzParameter->ul_Seed
      , sp_NetzParameter->f_FlatSpot );
    for( i=0; i < MAX_SCHICHTEN; i++ )
      fprintf( t_ProtokollFile, "%2d ", ai_NetzSchichten[i] );
  }
}

/****************************************************************************/
void ProtokollSchliessen()
{

  if( b_ProtokollFileOffen )           /* Protokollfile wieder schliessen */
  {
    fclose( t_ProtokollFile );
    b_ProtokollFileOffen = FALSE;
  }

}

/****************************************************************************/
void ProtokollSchreiben( float d_GesFehler, long l_Perioden )
{
  static time_t     secs_now;
  static struct tm* time_now;
  static char       str[15];

  time( &secs_now );                   /* Zeit merken */
  time_now = localtime( &secs_now );   /* Zeitstempel in File schreiben */
  strftime( str, sizeof(str), "%M.%S", time_now );
  fprintf( t_ProtokollFile, "\n%9.6f  %9ld %s", d_GesFehler, l_Perioden, str );

}

/****************************************************************************/
void GewichteSpeichern( NetzParameter sp_NetzParameter, int ai_NetzSchichten[] )
{
  FILE*  t_GewichteFile;
  char   s_GewichteFile[80];
  int    i, j, i_Counter;
  int    i_AnzahlDerGewichte;
  float* adp_Speicher[MAX_SCHICHTEN-1];
  float* fp_Temp;
  char*  cp_SchreibText;
  char   c_Temp[16];

  n_clrscr();                          /* Gewichte speichern (5) */
  write_str( 10, 10, "Bitte geben Sie den Namen der Gewichtedatei ein: " );
  scanf( "%s", s_GewichteFile );       /* Gewichtedatei oeffnen */
  strcat( s_GewichteFile, ".wgt" );
  if(( t_GewichteFile = fopen( s_GewichteFile, "w" )) == NULL )
  {                                    /* Die Datei kann nicht geoeffnet werden */
    write_str( 20, 12, "Die Gewichtedatei konnte nicht geoeffnet werden" );
    write_str( 37, 14, "Taste" );
    free( cp_SchreibText );
    n_GetKey();
    return;
  }

  bpgGewichteHolen( adp_Speicher );

  write_str( 10, 12, "Bitte haben Sie ein wenig Geduld!" );
  fprintf( t_GewichteFile, "%s\n", sp_NetzParameter.c_MusterDatei );
  for( i=0; i < MAX_SCHICHTEN; i++ )
    fprintf( t_GewichteFile, "%4d ", ai_NetzSchichten[i] );

  for( i=1; i < sp_NetzParameter.i_AnzahlDerSchichten; i++ )
  {
    i_AnzahlDerGewichte = (ai_NetzSchichten[i-1]+1)*ai_NetzSchichten[i];
    fp_Temp = adp_Speicher[i-1];
    for( j=0; j < i_AnzahlDerGewichte; j++ )
    {
      n_gotoxy( 38, 14 );
      printf( "%2d", j );
      fflush( stdout );
      fprintf( t_GewichteFile, "\n%10.8lf", *fp_Temp++ );
    }
  }

  free( cp_SchreibText );
  fclose( t_GewichteFile );

}

/****************************************************************************/
Pattern* GewichteLaden( NetzParameter* sp_NetzParameter,
                        int ai_NetzSchichten[] )
{
  FILE*    t_GewichteFile;
  char     s_GewichteFile[80];
  int      i, j, i_Counter;            /* einfache Zaehler */
  int      i_AnzahlDerGewichte;
  float    f_Temp;
  float*  adp_Speicher[MAX_SCHICHTEN-1];
  Pattern* sp_Pattern;

  n_clrscr();                          /* Gewichte wieder laden (4) */
  write_str( 10, 10, "Bitte geben Sie den Namen der Gewichtedatei ein: " );
  scanf( "%s", s_GewichteFile );       /* Gewichtedatei oefnnen */
  strcat( s_GewichteFile, ".wgt" );
  if(( t_GewichteFile = fopen( s_GewichteFile, "r" )) == NULL )
  {                                    /* Die Datei kann nicht geoeffnet werden */
    write_str( 10, 12, "Die Gewichtedatei konnte nicht geoeffnet werden" );
    write_str( 37, 14, "Taste" );
    n_GetKey();
    return NULL;
  }

  fscanf( t_GewichteFile, "%s", sp_NetzParameter->c_MusterDatei );
  sp_NetzParameter->i_AnzahlDerSchichten = 0;
  for( i=0; i < MAX_SCHICHTEN; i++ )
  {
    fscanf( t_GewichteFile, "%4d ", &ai_NetzSchichten[i] );
    if( ai_NetzSchichten[i] != 0 )
      sp_NetzParameter->i_AnzahlDerSchichten++;
  }

  sp_Pattern = PatternLaden( ai_NetzSchichten, sp_NetzParameter );
  bpgSpeicherKontrollieren( *sp_NetzParameter, ai_NetzSchichten );
  sp_NetzParameter->b_TrainiertesNetz = TRUE;
  bpgGewichteHolen( adp_Speicher );

  i_Counter = 0;
  n_clrscr();
  write_str(  10, 12, "Laden der Gewichte" );
  for( i=1; i < sp_NetzParameter->i_AnzahlDerSchichten; i++ )
  {                                    /* ACHTUNG: +1 -> BIAS */
    i_AnzahlDerGewichte = (ai_NetzSchichten[i-1]+1)*ai_NetzSchichten[i];
    for( j=0; j < i_AnzahlDerGewichte; j++ )
    {
      n_gotoxy( 38, 12 );
      printf( "%4d", ++i_Counter );
      fflush( stdout );
      fscanf( t_GewichteFile, "%f", &f_Temp );
      *(adp_Speicher[i-1]+j) = (float )f_Temp;
    }
  }
  fclose( t_GewichteFile );

  return sp_Pattern;

}
