// Modul zur berwachung des Get/SetLastError()-Fehler-
// codes unter Windows NT.
// 1996 by Matthias Withopf / c't

#define STRICT
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <stdio.h>

#define DEVELOPER   1

#ifdef __BORLANDC__
#pragma option -pc
#endif

#ifdef _MSC_VER
#define asm _asm
#endif

extern "C" void cdecl _LOGERROR(DWORD dwErrorCode);

static BOOL PatchFunction(char *FuncName,char *DLLName,char *NewFunc,
						  long Ofs,char *OrigCodeBytes,int OrigCodeLen)
{
  BOOL Result = FALSE;
  HMODULE DLLInst = GetModuleHandle(DLLName);
  if (DLLInst)
    {
      char *p = (char *)GetProcAddress(DLLInst,FuncName);
      if (p)
        if (!memcmp(p,OrigCodeBytes,OrigCodeLen))
          {
            char PatchData[5] = {'\xE9'}; // OpCode fr JMP
            p += Ofs;                     // berechne Sprungziel
            *((long *)&PatchData[1]) = (NewFunc - p - 5);
            WriteProcessMemory(GetCurrentProcess(),p,&PatchData,
							   sizeof PatchData,NULL);
            Result = TRUE;
          }
    }
  return Result;
}

extern "C" cdecl void MY_SETLASTERROR(void);
extern "C" cdecl void MY_CSRCLIENTSNDMSG(void);

BOOL __WatchError(void)
{
#ifdef DEVELOPER
  BOOL Result = FALSE;
  if (PatchFunction("SetLastError","KERNEL32.DLL",
	   (char *)MY_SETLASTERROR,0,"\x64\xA1\x18\x00\x00\x00\x8B\x4C",8)
	 )Result = TRUE;
  if (PatchFunction("CsrClientSendMessage","NTDLL.DLL",
	   (char *)MY_CSRCLIENTSNDMSG,219,
	   "\x55\x8B\xEC\x83\xEC\x10\x53\x56",8)) Result = TRUE;
  return Result;
#else
  return FALSE;
#endif
}

// Eine Mglichkeit, Meldungen zu protokollieren...

typedef struct
  {
    short int m_Code;
    char     *m_Str;
  } TWin32Msg;

// Fehlercodes aus winerror.h

static TWin32Msg Win32_Msg[] =
  {
    {   0,"The operation completed successfully"},
    {   1,"Incorrect function"},
    {   2,"The system cannot find the file specified"},
    {   3,"The system cannot find the path specified"},
    {   4,"The system cannot open the file"},
    {   5,"Access is denied"},
    {   6,"The handle is invalid"},
    {   7,"The storage control blocks were destroyed"},
    {   8,"Not enough storage is available to process this command"},
    {   9,"The storage control block address is invalid"},
    {  10,"The environment is incorrect"},
    {  11,"An attempt was made to load a program with an incorrect format"},
    {  12,"The access code is invalid"},
    {  13,"The data is invalid"},
    {  14,"Not enough storage is available to complete this operation"},
    {  15,"The system cannot find the drive specified"},
    {  16,"The directory cannot be removed"},
    {  17,"The system cannot move the file to a different disk drive"},
    {  18,"There are no more files"},
    {  19,"The media is write protected"},
    {  20,"The system cannot find the device specified"},
    {  21,"The device is not ready"},
    {  22,"The device does not recognize the command"},
    {  23,"Data error (cyclic redundancy check)"},
    {  24,"The program issued a command but the command length is incorrect"},
    {  25,"The drive cannot locate a specific area or track on the disk"},
    {  26,"The specified disk or diskette cannot be accessed"},
    {  27,"The drive cannot find the sector requested"},
    {  28,"The printer is out of paper"},
    {  29,"The system cannot write to the specified device"},
    {  30,"The system cannot read from the specified device"},
    {  31,"A device attached to the system is not functioning"},
    {  32,"The process cannot access the file because it is being used by another process"},
    {  33,"The process cannot access the file because another process has locked a portion of the file"},
    {  34,"The wrong diskette is in the drive. Insert %2 (Volume Serial Number: %3) into drive %1"},
    {  36,"Too many files opened for sharing"},
    {  38,"Reached end of file"},
    {  39,"The disk is full"},
    {  50,"The network request is not supported"},
    {  51,"The remote computer is not available"},
    {  52,"A duplicate name exists on the network"},
    {  53,"The network path was not found"},
    {  54,"The network is busy"},
    {  55,"The specified network resource or device is no longer available"},
    {  56,"The network BIOS command limit has been reached"},
    {  57,"A network adapter hardware error occurred"},
    {  58,"The specified server cannot perform the requested operation"},
    {  59,"An unexpected network error occurred"},
    {  60,"The remote adapter is not compatible"},
    {  61,"The printer queue is full"},
    {  62,"Space to store the file waiting to be printed is not available on the server"},
    {  63,"Your file waiting to be printed was deleted"},
    {  64,"The specified network name is no longer available"},
    {  65,"Network access is denied"},
    {  66,"The network resource type is not correct"},
    {  67,"The network name cannot be found"},
    {  68,"The name limit for the local computer network adapter card was exceeded"},
    {  69,"The network BIOS session limit was exceeded"},
    {  70,"The remote server has been paused or is in the process of being started"},
    {  71,"No more connections can be made to this remote computer at this time because there are already as many connections as the computer can accept"},
    {  72,"The specified printer or disk device has been paused"},
    {  80,"The file exists"},
    {  82,"The directory or file cannot be created"},
    {  83,"Fail on INT 24"},
    {  84,"Storage to process this request is not available"},
    {  85,"The local device name is already in use"},
    {  86,"The specified network password is not correct"},
    {  87,"The parameter is incorrect"},
    {  88,"A write fault occurred on the network"},
    {  89,"The system cannot start another process at this time"},
    { 100,"Cannot create another system semaphore"},
    { 101,"The exclusive semaphore is owned by another process"},
    { 102,"The semaphore is set and cannot be closed"},
    { 103,"The semaphore cannot be set again"},
    { 104,"Cannot request exclusive semaphores at interrupt time"},
    { 105,"The previous ownership of this semaphore has ended"},
    { 106,"Insert the diskette for drive %1"},
    { 107,"Program stopped because alternate diskette was not inserted"},
    { 108,"The disk is in use or locked by another process"},
    { 109,"The pipe has been ended"},
    { 110,"The system cannot open the device or file specified"},
    { 111,"The file name is too long"},
    { 112,"There is not enough space on the disk"},
    { 113,"No more internal file identifiers available"},
    { 114,"The target internal file identifier is incorrect"},
    { 117,"The IOCTL call made by the application program is not correct"},
    { 118,"The verify-on-write switch parameter value is not correct"},
    { 119,"The system does not support the command requested"},
    { 120,"This function is only valid in Win32 mode"},
    { 121,"The semaphore timeout period has expired"},
    { 122,"The data area passed to a system call is too small"},
    { 123,"The filename, directory name, or volume label syntax is incorrect"},
    { 124,"The system call level is not correct"},
    { 125,"The disk has no volume label"},
    { 126,"The specified module could not be found"},
    { 127,"The specified procedure could not be found"},
    { 128,"There are no child processes to wait for"},
    { 129,"The %1 application cannot be run in Win32 mode"},
    { 130,"Attempt to use a file handle to an open disk partition for an operation other than raw disk I/O"},
    { 131,"An attempt was made to move the file pointer before the beginning of the file"},
    { 132,"The file pointer cannot be set on the specified device or file"},
    { 133,"A JOIN or SUBST command cannot be used for a drive that contains previously joined drives"},
    { 134,"An attempt was made to use a JOIN or SUBST command on a drive that has already been joined"},
    { 135,"An attempt was made to use a JOIN or SUBST command on a drive that has already been substituted"},
    { 136,"The system tried to delete the JOIN of a drive that is not joined"},
    { 137,"The system tried to delete the substitution of a drive that is not substituted"},
    { 138,"The system tried to join a drive to a directory on a joined drive"},
    { 139,"The system tried to substitute a drive to a directory on a substituted drive"},
    { 140,"The system tried to join a drive to a directory on a substituted drive"},
    { 141,"The system tried to SUBST a drive to a directory on a joined drive"},
    { 142,"The system cannot perform a JOIN or SUBST at this time"},
    { 143,"The system cannot join or substitute a drive to or for a directory on the same drive"},
    { 144,"The directory is not a subdirectory of the root directory"},
    { 145,"The directory is not empty"},
    { 146,"The path specified is being used in a substitute"},
    { 147,"Not enough resources are available to process this command"},
    { 148,"The path specified cannot be used at this time"},
    { 149,"An attempt was made to join or substitute a drive for which a directory on the drive is the target of a previous substitute"},
    { 150,"System trace information was not specified in your CONFIG.SYS file, or tracing is disallowed"},
    { 151,"The number of specified semaphore events for DosMuxSemWait is not correct"},
    { 152,"DosMuxSemWait did not execute; too many semaphores are already set"},
    { 153,"The DosMuxSemWait list is not correct"},
    { 154,"The volume label you entered exceeds the label character limit of the target file system"},
    { 155,"Cannot create another thread"},
    { 156,"The recipient process has refused the signal"},
    { 157,"The segment is already discarded and cannot be locked"},
    { 158,"The segment is already unlocked"},
    { 159,"The address for the thread ID is not correct"},
    { 160,"The argument string passed to DosExecPgm is not correct"},
    { 161,"The specified path is invalid"},
    { 162,"A signal is already pending"},
    { 164,"No more threads can be created in the system"},
    { 167,"Unable to lock a region of a file"},
    { 170,"The requested resource is in use"},
    { 173,"A lock request was not outstanding for the supplied cancel region"},
    { 174,"The file system does not support atomic changes to the lock type"},
    { 180,"The system detected a segment number that was not correct"},
    { 182,"The operating system cannot run %1"},
    { 183,"Cannot create a file when that file already exists"},
    { 186,"The flag passed is not correct"},
    { 187,"The specified system semaphore name was not found"},
    { 188,"The operating system cannot run %1"},
    { 189,"The operating system cannot run %1"},
    { 190,"The operating system cannot run %1"},
    { 191,"Cannot run %1 in Win32 mode"},
    { 192,"The operating system cannot run %1"},
    { 193,"%1 is not a valid Win32 application"},
    { 194,"The operating system cannot run %1"},
    { 195,"The operating system cannot run %1"},
    { 196,"The operating system cannot run this application program"},
    { 197,"The operating system is not presently configured to run this application"},
    { 198,"The operating system cannot run %1"},
    { 199,"The operating system cannot run this application program"},
    { 200,"The code segment cannot be greater than or equal to 64KB"},
    { 201,"The operating system cannot run %1"},
    { 202,"The operating system cannot run %1"},
    { 203,"The system could not find the environment option that was entered"},
    { 205,"No process in the command subtree has a signal handler"},
    { 206,"The filename or extension is too long"},
    { 207,"The ring 2 stack is in use"},
    { 208,"The global filename characters, * or ?, are entered incorrectly or too many global filename characters are specified"},
    { 209,"The signal being posted is not correct"},
    { 210,"The signal handler cannot be set"},
    { 212,"The segment is locked and cannot be reallocated"},
    { 214,"Too many dynamic link modules are attached to this program or dynamic link module"},
    { 215,"Can't nest calls to LoadModule"},
    { 230,"The pipe state is invalid"},
    { 231,"All pipe instances are busy"},
    { 232,"The pipe is being closed"},
    { 233,"No process is on the other end of the pipe"},
    { 234,"More data is available"},
    { 240,"The session was cancelled"},
    { 254,"The specified extended attribute name was invalid"},
    { 255,"The extended attributes are inconsistent"},
    { 259,"No more data is available"},
    { 266,"The Copy API cannot be used"},
    { 267,"The directory name is invalid"},
    { 275,"The extended attributes did not fit in the buffer"},
    { 276,"The extended attribute file on the mounted file system is corrupt"},
    { 277,"The extended attribute table file is full"},
    { 278,"The specified extended attribute handle is invalid"},
    { 282,"The mounted file system does not support extended attributes"},
    { 288,"Attempt to release mutex not owned by caller"},
    { 298,"Too many posts were made to a semaphore"},
    { 299,"Only part of a Read/WriteProcessMemory request was completed"},
    { 317,"The system cannot find message for message number 0x%1 in message file for %2"},
    { 487,"Attempt to access invalid address"},
    { 534,"Arithmetic result exceeded 32 bits"},
    { 535,"There is a process on other end of the pipe"},
    { 536,"Waiting for a process to open the other end of the pipe"},
    { 994,"Access to the extended attribute was denied"},
    { 995,"The I/O operation has been aborted because of either a thread exit or an application request"},
    { 996,"Overlapped I/O event is not in a signalled state"},
    { 997,"Overlapped I/O operation is in progress"},
    { 998,"Invalid access to memory location"},
    { 999,"Error performing inpage operation"},
    {1001,"Recursion too deep, stack overflowed"},
    {1002,"The window cannot act on the sent message"},
    {1003,"Cannot complete this function"},
    {1004,"Invalid flags"},
    {1005,"The volume does not contain a recognized file system. Please make sure that all required file system drivers are loaded and that the volume is not corrupt"},
    {1006,"The volume for a file has been externally altered such that the opened file is no longer valid"},
    {1007,"The requested operation cannot be performed in full-screen mode"},
    {1008,"An attempt was made to reference a token that does not exist"},
    {1009,"The configuration registry database is corrupt"},
    {1010,"The configuration registry key is invalid"},
    {1011,"The configuration registry key could not be opened"},
    {1012,"The configuration registry key could not be read"},
    {1013,"The configuration registry key could not be written"},
    {1014,"One of the files in the Registry database had to be recovered by use of a log or alternate copy. The recovery was successful"},
    {1015,"The Registry is corrupt. The structure of one of the files that contains Registry data is corrupt, or the system's image of the file in memory is corrupt, "
          "or the file could not be recovered because the alternate copy or log was absent or corrupt"},
    {1016,"An I/O operation initiated by the Registry failed unrecoverably. The Registry could not read in, or write out, or flush, one of the files that contain the system's image of the Registry"},
    {1017,"The system has attempted to load or restore a file into the Registry, but the specified file is not in a Registry file format"},
    {1018,"Illegal operation attempted on a Registry key which has been marked for deletion"},
    {1019,"System could not allocate the required space in a Registry log"},
    {1020,"Cannot create a symbolic link in a Registry key that already has subkeys or values"},
    {1021,"Cannot create a stable subkey under a volatile parent key"},
    {1022,"A notify change request is being completed and the information is not being returned in the caller's buffer. The caller now needs to enumerate the files to find the changes"},
    {1051,"A stop control has been sent to a service which other running services are dependent on"},
    {1052,"The requested control is not valid for this service"},
    {1053,"The service did not respond to the start or control request in a timely fashion"},
    {1054,"A thread could not be created for the service"},
    {1055,"The service database is locked"},
    {1056,"An instance of the service is already running"},
    {1057,"The account name is invalid or does not exist"},
    {1058,"The specified service is disabled and cannot be started"},
    {1059,"Circular service dependency was specified"},
    {1060,"The specified service does not exist as an installed service"},
    {1061,"The service cannot accept control messages at this time"},
    {1062,"The service has not been started"},
    {1063,"The service process could not connect to the service controller"},
    {1064,"An exception occurred in the service when handling the control request"},
    {1065,"The database specified does not exist"},
    {1066,"The service has returned a service-specific error code"},
    {1067,"The process terminated unexpectedly"},
    {1068,"The dependency service or group failed to start"},
    {1069,"The service did not start due to a logon failure"},
    {1070,"After starting, the service hung in a start-pending state"},
    {1071,"The specified service database lock is invalid"},
    {1072,"The specified service has been marked for deletion"},
    {1073,"The specified service already exists"},
    {1074,"The system is currently running with the last-known-good configuration"},
    {1075,"The dependency service does not exist or has been marked for deletion"},
    {1076,"The current boot has already been accepted for use as the last-known-good control set"},
    {1077,"No attempts to start the service have been made since the last boot"},
    {1078,"The name is already in use as either a service name or a service display name"},
    {1100,"The physical end of the tape has been reached"},
    {1101,"A tape access reached a filemark"},
    {1102,"Beginning of tape or partition was encountered"},
    {1103,"A tape access reached the end of a set of files"},
    {1104,"No more data is on the tape"},
    {1105,"Tape could not be partitioned"},
    {1106,"When accessing a new tape of a multivolume partition, the current blocksize is incorrect"},
    {1107,"Tape partition information could not be found when loading a tape"},
    {1108,"Unable to lock the media eject mechanism"},
    {1109,"Unable to unload the media"},
    {1110,"Media in drive may have changed"},
    {1111,"The I/O bus was reset"},
    {1112,"No media in drive"},
    {1113,"No mapping for the Unicode character exists in the target multi-byte code page"},
    {1114,"A dynamic link library (DLL) initialization routine failed"},
    {1115,"A system shutdown is in progress"},
    {1116,"Unable to abort the system shutdown because no shutdown was in progress"},
    {1117,"The request could not be performed because of an I/O device error"},
    {1118,"No serial device was successfully initialized. The serial driver will unload"},
    {1119,"Unable to open a device that was sharing an interrupt request (IRQ) with other devices. At least one other device that uses that IRQ was already opened"},
    {1120,"A serial I/O operation was completed by another write to the serial port. (The IOCTL_SERIAL_XOFF_COUNTER reached zero.)"},
    {1121,"A serial I/O operation completed because the time-out period expired. (The IOCTL_SERIAL_XOFF_COUNTER did not reach zero.)"},
    {1122,"No ID address mark was found on the floppy disk"},
    {1123,"Mismatch between the floppy disk sector ID field and the floppy disk controller track address"},
    {1124,"The floppy disk controller reported an error that is not recognized by the floppy disk driver"},
    {1125,"The floppy disk controller returned inconsistent results in its registers"},
    {1126,"While accessing the hard disk, a recalibrate operation failed, even after retries"},
    {1127,"While accessing the hard disk, a disk operation failed even after retries"},
    {1128,"While accessing the hard disk, a disk controller reset was needed, but even that failed"},
    {1129,"Physical end of tape encountered"},
    {1130,"Not enough server storage is available to process this command"},
    {1131,"A potential deadlock condition has been detected"},
    {1132,"The base address or the file offset specified does not have the proper alignment"},
    {1140,"An attempt to change the system power state was vetoed by another application or driver"},
    {1141,"The system BIOS failed an attempt to change the system power state"},
    {1150,"The specified program requires a newer version of Windows"},
    {1151,"The specified program is not a Windows or MS-DOS program"},
    {1152,"Cannot start more than one instance of the specified program"},
    {1153,"The specified program was written for an older version of Windows"},
    {1154,"One of the library files needed to run this application is damaged"},
    {1155,"No application is associated with the specified file for this operation"},
    {1156,"An error occurred in sending the command to the application"},
    {1157,"One of the library files needed to run this application cannot be found"},
    {1200,"The specified device name is invalid"},
    {1201,"The device is not currently connected but it is a remembered connection"},
    {1202,"An attempt was made to remember a device that had previously been remembered"},
    {1203,"No network provider accepted the given network path"},
    {1204,"The specified network provider name is invalid"},
    {1205,"Unable to open the network connection profile"},
    {1206,"The network connection profile is corrupt"},
    {1207,"Cannot enumerate a non-container"},
    {1208,"An extended error has occurred"},
    {1209,"The format of the specified group name is invalid"},
    {1210,"The format of the specified computer name is invalid"},
    {1211,"The format of the specified event name is invalid"},
    {1212,"The format of the specified domain name is invalid"},
    {1213,"The format of the specified service name is invalid"},
    {1214,"The format of the specified network name is invalid"},
    {1215,"The format of the specified share name is invalid"},
    {1216,"The format of the specified password is invalid"},
    {1217,"The format of the specified message name is invalid"},
    {1218,"The format of the specified message destination is invalid"},
    {1219,"The credentials supplied conflict with an existing set of credentials"},
    {1220,"An attempt was made to establish a session to a network server, but there are already too many sessions established to that server"},
    {1221,"The workgroup or domain name is already in use by another computer on the network"},
    {1222,"The network is not present or not started"},
    {1223,"The operation was cancelled by the user"},
    {1224,"The requested operation cannot be performed on a file with a user mapped section open"},
    {1225,"The remote system refused the network connection"},
    {1226,"The network connection was gracefully closed"},
    {1227,"The network transport endpoint already has an address associated with it"},
    {1228,"An address has not yet been associated with the network endpoint"},
    {1229,"An operation was attempted on a non-existent network connection"},
    {1230,"An invalid operation was attempted on an active network connection"},
    {1231,"The remote network is not reachable by the transport"},
    {1232,"The remote system is not reachable by the transport"},
    {1233,"The remote system does not support the transport protocol"},
    {1234,"No service is operating at the destination network endpoint on the remote system"},
    {1235,"The request was aborted"},
    {1236,"The network connection was aborted by the local system"},
    {1237,"The operation could not be completed. A retry should be performed"},
    {1238,"A connection to the server could not be made because the limit on the number of concurrent connections for this account has been reached"},
    {1239,"Attempting to login during an unauthorized time of day for this account"},
    {1240,"The account is not authorized to login from this station"},
    {1241,"The network address could not be used for the operation requested"},
    {1242,"The service is already registered"},
    {1243,"The specified service does not exist"},
    {1244,"The operation being requested was not performed because the user has not been authenticated"},
    {1245,"The operation being requested was not performed because the user has not logged on to the network. The specified service does not exist"},
    {1246,"Return that wants caller to continue with work in progress"},
    {1247,"An attempt was made to perform an initialization operation when initialization has already been completed"},
    {1248,"No more local devices"},
    {1300,"Not all privileges referenced are assigned to the caller"},
    {1301,"Some mapping between account names and security IDs was not done"},
    {1302,"No system quota limits are specifically set for this account"},
    {1303,"No encryption key is available. A well-known encryption key was returned"},
    {1304,"The NT password is too complex to be converted to a LAN Manager password. The LAN Manager password returned is a NULL string"},
    {1305,"The revision level is unknown"},
    {1306,"Indicates two revision levels are incompatible"},
    {1307,"This security ID may not be assigned as the owner of this object"},
    {1308,"This security ID may not be assigned as the primary group of an object"},
    {1309,"An attempt has been made to operate on an impersonation token by a thread that is not currently impersonating a client"},
    {1310,"The group may not be disabled"},
    {1311,"There are currently no logon servers available to service the logon request"},
    {1312,"A specified logon session does not exist. It may already have been terminated"},
    {1313,"A specified privilege does not exist"},
    {1314,"A required privilege is not held by the client"},
    {1315,"The name provided is not a properly formed account name"},
    {1316,"The specified user already exists"},
    {1317,"The specified user does not exist"},
    {1318,"The specified group already exists"},
    {1319,"The specified group does not exist"},
    {1320,"Either the specified user account is already a member of the specified group, or the specified group cannot be deleted because it contains a member"},
    {1321,"The specified user account is not a member of the specified group account"},
    {1322,"The last remaining administration account cannot be disabled or deleted"},
    {1323,"Unable to update the password. The value provided as the current password is incorrect"},
    {1324,"Unable to update the password. The value provided for the new password contains values that are not allowed in passwords"},
    {1325,"Unable to update the password because a password update rule has been violated"},
    {1326,"Logon failure: unknown user name or bad password"},
    {1327,"Logon failure: user account restriction"},
    {1328,"Logon failure: account logon time restriction violation"},
    {1329,"Logon failure: user not allowed to log on to this computer"},
    {1330,"Logon failure: the specified account password has expired"},
    {1331,"Logon failure: account currently disabled"},
    {1332,"No mapping between account names and security IDs was done"},
    {1333,"Too many local user identifiers (LUIDs) were requested at one time"},
    {1334,"No more local user identifiers (LUIDs) are available"},
    {1335,"The subauthority part of a security ID is invalid for this particular use"},
    {1336,"The access control list (ACL) structure is invalid"},
    {1337,"The security ID structure is invalid"},
    {1338,"The security descriptor structure is invalid"},
    {1340,"The inherited access control list (ACL) or access control entry (ACE) could not be built"},
    {1341,"The server is currently disabled"},
    {1342,"The server is currently enabled"},
    {1343,"The value provided was an invalid value for an identifier authority"},
    {1344,"No more memory is available for security information updates"},
    {1345,"The specified attributes are invalid, or incompatible with the attributes for the group as a whole"},
    {1346,"Either a required impersonation level was not provided, or the provided impersonation level is invalid"},
    {1347,"Cannot open an anonymous level security token"},
    {1348,"The validation information class requested was invalid"},
    {1349,"The type of the token is inappropriate for its attempted use"},
    {1350,"Unable to perform a security operation on an object which has no associated security"},
    {1351,"Indicates a Windows NT Server could not be contacted or that objects within the domain are protected such that necessary information could not be retrieved"},
    {1352,"The security account manager (SAM) or local security authority (LSA) server was in the wrong state to perform the security operation"},
    {1353,"The domain was in the wrong state to perform the security operation"},
    {1354,"This operation is only allowed for the Primary Domain Controller of the domain"},
    {1355,"The specified domain did not exist"},
    {1356,"The specified domain already exists"},
    {1357,"An attempt was made to exceed the limit on the number of domains per server"},
    {1358,"Unable to complete the requested operation because of either a catastrophic media failure or a data structure corruption on the disk"},
    {1359,"The security account database contains an internal inconsistency"},
    {1360,"Generic access types were contained in an access mask which should already be mapped to non-generic types"},
    {1361,"A security descriptor is not in the right format (absolute or self-relative)"},
    {1362,"The requested action is restricted for use by logon processes only. The calling process has not registered as a logon process"},
    {1363,"Cannot start a new logon session with an ID that is already in use"},
    {1364,"A specified authentication package is unknown"},
    {1365,"The logon session is not in a state that is consistent with the requested operation"},
    {1366,"The logon session ID is already in use"},
    {1367,"A logon request contained an invalid logon type value"},
    {1368,"Unable to impersonate via a named pipe until data has been read from that pipe"},
    {1369,"The transaction state of a Registry subtree is incompatible with the requested operation"},
    {1370,"An internal security database corruption has been encountered"},
    {1371,"Cannot perform this operation on built-in accounts"},
    {1372,"Cannot perform this operation on this built-in special group"},
    {1373,"Cannot perform this operation on this built-in special user"},
    {1374,"The user cannot be removed from a group because the group is currently the user's primary group"},
    {1375,"The token is already in use as a primary token"},
    {1376,"The specified local group does not exist"},
    {1377,"The specified account name is not a member of the local group"},
    {1378,"The specified account name is already a member of the local group"},
    {1379,"The specified local group already exists"},
    {1380,"Logon failure: the user has not been granted the requested logon type at this computer"},
    {1381,"The maximum number of secrets that may be stored in a single system has been exceeded"},
    {1382,"The length of a secret exceeds the maximum length allowed"},
    {1383,"The local security authority database contains an internal inconsistency"},
    {1384,"During a logon attempt, the user's security context accumulated too many security IDs"},
    {1385,"Logon failure: the user has not been granted the requested logon type at this computer"},
    {1386,"A cross-encrypted password is necessary to change a user password"},
    {1387,"A new member could not be added to a local group because the member does not exist"},
    {1388,"A new member could not be added to a local group because the member has the wrong account type"},
    {1389,"Too many security IDs have been specified"},
    {1390,"A cross-encrypted password is necessary to change this user password"},
    {1391,"Indicates an ACL contains no inheritable components"},
    {1392,"The file or directory is corrupt and non-readable"},
    {1393,"The disk structure is corrupt and non-readable"},
    {1394,"There is no user session key for the specified logon session"},
    {1395,"The service being accessed is licensed for a particular number of connections. No more connections can be made to the service at this time because there are already as many connections as the service can accept"},
    {1400,"Invalid window handle"},
    {1401,"Invalid menu handle"},
    {1402,"Invalid cursor handle"},
    {1403,"Invalid accelerator table handle"},
    {1404,"Invalid hook handle"},
    {1405,"Invalid handle to a multiple-window position structure"},
    {1406,"Cannot create a top-level child window"},
    {1407,"Cannot find window class"},
    {1408,"Invalid window, belongs to other thread"},
    {1409,"Hot key is already registered"},
    {1410,"Class already exists"},
    {1411,"Class does not exist"},
    {1412,"Class still has open windows"},
    {1413,"Invalid index"},
    {1414,"Invalid icon handle"},
    {1415,"Using private DIALOG window words"},
    {1416,"The listbox identifier was not found"},
    {1417,"No wildcards were found"},
    {1418,"Thread does not have a clipboard open"},
    {1419,"Hot key is not registered"},
    {1420,"The window is not a valid dialog window"},
    {1421,"Control ID not found"},
    {1422,"Invalid message for a combo box because it does not have an edit control"},
    {1423,"The window is not a combo box"},
    {1424,"Height must be less than 256"},
    {1425,"Invalid device context (DC) handle"},
    {1426,"Invalid hook procedure type"},
    {1427,"Invalid hook procedure"},
    {1428,"Cannot set non-local hook without a module handle"},
    {1429,"This hook procedure can only be set globally"},
    {1430,"The journal hook procedure is already installed"},
    {1431,"The hook procedure is not installed"},
    {1432,"Invalid message for single-selection listbox"},
    {1433,"LB_SETCOUNT sent to non-lazy listbox"},
    {1434,"This list box does not support tab stops"},
    {1435,"Cannot destroy object created by another thread"},
    {1436,"Child windows cannot have menus"},
    {1437,"The window does not have a system menu"},
    {1438,"Invalid message box style"},
    {1439,"Invalid system-wide (SPI_*) parameter"},
    {1440,"Screen already locked"},
    {1441,"All handles to windows in a multiple-window position structure must have the same parent"},
    {1442,"The window is not a child window"},
    {1443,"Invalid GW_* command"},
    {1444,"Invalid thread identifier"},
    {1445,"Cannot process a message from a window that is not a multiple document interface (MDI) window"},
    {1446,"Popup menu already active"},
    {1447,"The window does not have scroll bars"},
    {1448,"Scroll bar range cannot be greater than 0x7FFF"},
    {1449,"Cannot show or remove the window in the way specified"},
    {1450,"Insufficient system resources exist to complete the requested service"},
    {1451,"Insufficient system resources exist to complete the requested service"},
    {1452,"Insufficient system resources exist to complete the requested service"},
    {1453,"Insufficient quota to complete the requested service"},
    {1454,"Insufficient quota to complete the requested service"},
    {1455,"The paging file is too small for this operation to complete"},
    {1456,"A menu item was not found"},
    {1500,"The event log file is corrupt"},
    {1501,"No event log file could be opened, so the event logging service did not start"},
    {1502,"The event log file is full"},
    {1503,"The event log file has changed between reads"},
    {1700,"The string binding is invalid"},
    {1701,"The binding handle is not the correct type"},
    {1702,"The binding handle is invalid"},
    {1703,"The RPC protocol sequence is not supported"},
    {1704,"The RPC protocol sequence is invalid"},
    {1705,"The string universal unique identifier (UUID) is invalid"},
    {1706,"The endpoint format is invalid"},
    {1707,"The network address is invalid"},
    {1708,"No endpoint was found"},
    {1709,"The timeout value is invalid"},
    {1710,"The object universal unique identifier (UUID) was not found"},
    {1711,"The object universal unique identifier (UUID) has already been registered"},
    {1712,"The type universal unique identifier (UUID) has already been registered"},
    {1713,"The RPC server is already listening"},
    {1714,"No protocol sequences have been registered"},
    {1715,"The RPC server is not listening"},
    {1716,"The manager type is unknown"},
    {1717,"The interface is unknown"},
    {1718,"There are no bindings"},
    {1719,"There are no protocol sequences"},
    {1720,"The endpoint cannot be created"},
    {1721,"Not enough resources are available to complete this operation"},
    {1722,"The RPC server is unavailable"},
    {1723,"The RPC server is too busy to complete this operation"},
    {1724,"The network options are invalid"},
    {1725,"There is not a remote procedure call active in this thread"},
    {1726,"The remote procedure call failed"},
    {1727,"The remote procedure call failed and did not execute"},
    {1728,"A remote procedure call (RPC) protocol error occurred"},
    {1730,"The transfer syntax is not supported by the RPC server"},
    {1732,"The universal unique identifier (UUID) type is not supported"},
    {1733,"The tag is invalid"},
    {1734,"The array bounds are invalid"},
    {1735,"The binding does not contain an entry name"},
    {1736,"The name syntax is invalid"},
    {1737,"The name syntax is not supported"},
    {1739,"No network address is available to use to construct a universal unique identifier (UUID)"},
    {1740,"The endpoint is a duplicate"},
    {1741,"The authentication type is unknown"},
    {1742,"The maximum number of calls is too small"},
    {1743,"The string is too long"},
    {1744,"The RPC protocol sequence was not found"},
    {1745,"The procedure number is out of range"},
    {1746,"The binding does not contain any authentication information"},
    {1747,"The authentication service is unknown"},
    {1748,"The authentication level is unknown"},
    {1749,"The security context is invalid"},
    {1750,"The authorization service is unknown"},
    {1751,"The entry is invalid"},
    {1752,"The server endpoint cannot perform the operation"},
    {1753,"There are no more endpoints available from the endpoint mapper"},
    {1754,"No interfaces have been exported"},
    {1755,"The entry name is incomplete"},
    {1756,"The version option is invalid"},
    {1757,"There are no more members"},
    {1758,"There is nothing to unexport"},
    {1759,"The interface was not found"},
    {1760,"The entry already exists"},
    {1761,"The entry is not found"},
    {1762,"The name service is unavailable"},
    {1763,"The network address family is invalid"},
    {1764,"The requested operation is not supported"},
    {1765,"No security context is available to allow impersonation"},
    {1766,"An internal error occurred in a remote procedure call (RPC)"},
    {1767,"The RPC server attempted an integer division by zero"},
    {1768,"An addressing error occurred in the RPC server"},
    {1769,"A floating-point operation at the RPC server caused a division by zero"},
    {1770,"A floating-point underflow occurred at the RPC server"},
    {1771,"A floating-point overflow occurred at the RPC server"},
    {1772,"The list of RPC servers available for the binding of auto handles has been exhausted"},
    {1773,"Unable to open the character translation table file"},
    {1774,"The file containing the character translation table has fewer than 512 bytes"},
    {1775,"A null context handle was passed from the client to the host during a remote procedure call"},
    {1777,"The context handle changed during a remote procedure call"},
    {1778,"The binding handles passed to a remote procedure call do not match"},
    {1779,"The stub is unable to get the remote procedure call handle"},
    {1780,"A null reference pointer was passed to the stub"},
    {1781,"The enumeration value is out of range"},
    {1782,"The byte count is too small"},
    {1783,"The stub received bad data"},
    {1784,"The supplied user buffer is not valid for the requested operation"},
    {1785,"The disk media is not recognized. It may not be formatted"},
    {1786,"The workstation does not have a trust secret"},
    {1787,"The SAM database on the Windows NT Server does not have a computer account for this workstation trust relationship"},
    {1788,"The trust relationship between the primary domain and the trusted domain failed"},
    {1789,"The trust relationship between this workstation and the primary domain failed"},
    {1790,"The network logon failed"},
    {1791,"A remote procedure call is already in progress for this thread"},
    {1792,"An attempt was made to logon, but the network logon service was not started"},
    {1793,"The user's account has expired"},
    {1794,"The redirector is in use and cannot be unloaded"},
    {1795,"The specified printer driver is already installed"},
    {1796,"The specified port is unknown"},
    {1797,"The printer driver is unknown"},
    {1798,"The print processor is unknown"},
    {1799,"The specified separator file is invalid"},
    {1800,"The specified priority is invalid"},
    {1801,"The printer name is invalid"},
    {1802,"The printer already exists"},
    {1803,"The printer command is invalid"},
    {1804,"The specified datatype is invalid"},
    {1805,"The Environment specified is invalid"},
    {1806,"There are no more bindings"},
    {1807,"The account used is an interdomain trust account. Use your global user account or local user account to access this server"},
    {1808,"The account used is a Computer Account. Use your global user account or local user account to access this server"},
    {1809,"The account used is an server trust account. Use your global user account or local user account to access this server"},
    {1810,"The name or security ID (SID) of the domain specified is inconsistent with the trust information for that domain"},
    {1811,"The server is in use and cannot be unloaded"},
    {1812,"The specified image file did not contain a resource section"},
    {1813,"The specified resource type can not be found in the image file"},
    {1814,"The specified resource name can not be found in the image file"},
    {1815,"The specified resource language ID cannot be found in the image file"},
    {1816,"Not enough quota is available to process this command"},
    {1817,"No interfaces have been registered"},
    {1818,"The server was altered while processing this call"},
    {1819,"The binding handle does not contain all required information"},
    {1820,"Communications failure"},
    {1821,"The requested authentication level is not supported"},
    {1822,"No principal name registered"},
    {1823,"The error specified is not a valid Windows RPC error code"},
    {1824,"A UUID that is valid only on this computer has been allocated"},
    {1825,"A security package specific error occurred"},
    {1826,"Thread is not cancelled"},
    {1827,"Invalid operation on the encoding/decoding handle"},
    {1828,"Incompatible version of the serializing package"},
    {1829,"Incompatible version of the RPC stub"},
    {1898,"The group member was not found"},
    {1899,"The endpoint mapper database could not be created"},
    {1900,"The object universal unique identifier (UUID) is the nil UUID"},
    {1901,"The specified time is invalid"},
    {1902,"The specified Form name is invalid"},
    {1903,"The specified Form size is invalid"},
    {1904,"The specified Printer handle is already being waited on"},
    {1905,"The specified Printer has been deleted"},
    {1906,"The state of the Printer is invalid"},
    {1907,"The user must change his password before he logs on the first time"},
    {1908,"Could not find the domain controller for this domain"},
    {1909,"The referenced account is currently locked out and may not be logged on to"},
    {2000,"The pixel format is invalid"},
    {2001,"The specified driver is invalid"},
    {2002,"The window style or class attribute is invalid for this operation"},
    {2003,"The requested metafile operation is not supported"},
    {2004,"The requested transformation operation is not supported"},
    {2005,"The requested clipping operation is not supported"},
    {2202,"The specified username is invalid"},
    {2250,"This network connection does not exist"},
    {2401,"This network connection has files open or requests pending"},
    {2402,"Active connections still exist"},
    {2404,"The device is in use by an active process and cannot be disconnected"},
    {3000,"The specified print monitor is unknown"},
    {3001,"The specified printer driver is currently in use"},
    {3002,"The spool file was not found"},
    {3003,"A StartDocPrinter call was not issued"},
    {3004,"An AddJob call was not issued"},
    {3005,"The specified print processor has already been installed"},
    {3006,"The specified print monitor has already been installed"},
    {4000,"WINS encountered an error while processing the command"},
    {4001,"The local WINS can not be deleted"},
    {4002,"The importation from the file failed"},
    {4003,"The backup Failed. Was a full backup done before ?"},
    {4004,"The backup Failed. Check the directory that you are backing the database to"},
    {4005,"The name does not exist in the WINS database"},
    {4006,"Replication with a non-configured partner is not allowed"},
    {6118,"The list of servers for this workgroup is not currently \
	       available"}
  };

void cdecl _LOGERROR(DWORD dwErrorCode)
{
  static short int ErrorsToIgnore[32] = {0};   // Fehlercodes, die nicht 
											   // gemeldet werden sollen
  for (long i = 0;i < sizeof(ErrorsToIgnore) / 
					  sizeof(ErrorsToIgnore[0]);++i)
    if (ErrorsToIgnore[i] == (short int)dwErrorCode) return;
  BOOL f = FALSE;
  char tmp[1024],*M;
  static int LastErrorCount = 1;
  for (i = 0;i < sizeof(Win32_Msg) / sizeof(Win32_Msg[0]);++i)
    if (Win32_Msg[i].m_Code == (short int)dwErrorCode)
      {
        f = TRUE;
        M = Win32_Msg[i].m_Str;
L:      sprintf(tmp,"[%4d] Error %4d: %s\n",LastErrorCount++,
											dwErrorCode,M);
        // eigentlich gefhrlich, da auch Fehler auslsen kann...
        static BOOL   _ConsoleOpened = FALSE;
        static HANDLE _StdOutHandle  = 0;
        if (!_ConsoleOpened)
          {
            _ConsoleOpened = TRUE;
            if (AllocConsole()) _StdOutHandle = 
								GetStdHandle(STD_OUTPUT_HANDLE);
          }
        if (_StdOutHandle)
          {
            DWORD Result;
            WriteFile(_StdOutHandle,tmp,strlen(tmp),&Result,NULL);
          }
        break;
      }
  if (!f) { M = "?"; f = TRUE; goto L; }
  asm MOV EAX,FS:[0x18]             // SetLastError(dwErrorCode);
  asm MOV ECX,dwErrorCode
  asm MOV [EAX+0x34],ECX
}

