// Testprogramm zur berwachung des Get/SetLastError()-Fehlercodes unter Windows NT.
// 1996 by Matthias Withopf / c't

// Drcken der linken/rechten Maustaste provoziert eine Fehlermeldung.

#define STRICT
#define WIN32_LEAN_AND_MEAN
#include <windows.h>

LRESULT CALLBACK MainWndProc(HWND Wnd,UINT msg,WPARAM wParam,LPARAM lParam)
{
  switch(msg)
    {
      case WM_DESTROY:
        PostQuitMessage(0);
        break;

      case WM_LBUTTONDOWN:
        GetProcAddress(NULL,"xyz");   // -> The specified procedure could not be found
        break;

      case WM_RBUTTONDOWN:
        LoadCursor(NULL,"xyz");       // -> The specified resource name can not be found in the image file
        break;

      default:
        return DefWindowProc(Wnd,msg,wParam,lParam);
    }
  return 0;
}

const LPSTR MainClassName = "Main";

int WINAPI WinMain(HINSTANCE hInstance,HINSTANCE hPrevInstance,LPSTR,int cmdShow)
{
  extern BOOL __WatchError(void);
  __WatchError();
  if (!hPrevInstance)
    {
      WNDCLASS WndClass = {0,MainWndProc,0,0,hInstance,NULL,LoadCursor(NULL,IDC_ARROW),
                           (HBRUSH)(COLOR_WINDOW + 1),NULL,MainClassName};
      RegisterClass(&WndClass);
      RegisterClass(&WndClass);   // -> Class already exists
    }
  HWND hwnd = CreateWindow(MainClassName,"WatchError Test",WS_OVERLAPPEDWINDOW,CW_USEDEFAULT,
                CW_USEDEFAULT,300,100,NULL,NULL,hInstance,NULL);
  ShowWindow(hwnd,cmdShow);
  MSG msg;
  while (GetMessage(&msg,0,0,0))
    {
      TranslateMessage(&msg);
      DispatchMessage(&msg);
    }
  return 0;
}