// Datei CTAnimatorApplet.java
import java.awt.*;      //#include Abstract Window Tooolkit
import java.applet.*;   //#include Applet-Klassen
public class CTAnimatorApplet extends Applet implements Runnable {
    // Die Bildsequenz
    Image ctBild ;
    // Index auf das aktuelle Bild
    int lfdNum = 0;
    // Breite, Hhe des GIF-Bildes
    int width;
    int height;
    // Scheduling-Objekt
    Thread t;

   // Wird aufgerufen wenn die Seite erstmalig oder
   // erneut angezeigt wird
    public void start() { 
         if (t == null) { 
              // Neuer Thread wird erzeugt 
              // t.start() ruft implizit die Methode run() auf 
               t = new Thread(this); 
               t.start(); 
         } 
    }

    // Wenn die aktuelle WWW-Seite verlassen wird, sollte
    // auch der Hintergrundthread aufhren zu arbeiten 
    public void stop() { 
          if (t != null && t.isAlive()) { 
                t.stop();
                t = null;
          } 
    }

    // In einer Endlosschleife wird alle 1000ms
    // der Index auf das aktuelle Bild erhht
    // und die Anzeige aktualisiert
    public void run() {
          while (true) {
	       if (lfdNum == 9)
	           lfdNum = 0;
	       else
	           lfdNum++;
	       ctBild = getImage(getCodeBase(),
                         "images/ct"+lfdNum+".gif");
                repaint (); 
                try {
                   Thread.sleep (1000);
                } catch (Exception e) { } 
                // repaint ruft implizit update() auf
          }
    }
    // init()-Methode wird bei Start des Applets
    // aufgerufen
    public void init() {
       // Start des Ladens der Bildsequenzen ber
       // das HTTP-Protokoll. Fr jedes Bild luft
       // ein Thread im Hintergrund. Es wird
       // umgehend mit der Ausfhrung des Programms
       // fortgefahren.
       if (size().width < 400 || size().height <150) {
             // ggf. wird das Applet-
             //rechteck nachjustiert
             resize(400,150);
       }
    }
    // Solange das Bild nicht komplett ist wird
    // durch das Nachfragen nach den Dimensionen des
    // Bildes wiederholt die update()-Methode getriggert.
    public void paint(Graphics g) {   
       width= ctBild.getWidth(this); 
       height= ctBild.getHeight(this);
       // Solange das Bild noch nicht komplett geladen
       // ist, wird als Breite und Hhe des Bildes
       // -1 zurckgeliefert 
       if (width> 0) {
           g.drawRect(10,10,width,height);
       }
       g.drawImage(ctBild,10,10,width,
                     height,this);                 
   }
    // update wird mehrfach aufgerufen, whrend das Bild
    // geladen wird
    public void update (Graphics g) {  
        if (ctBild.getWidth(this) > 0)
            System.out.println("Bild ist komplett!");
         paint(g);
    }
}

