;*************************************************************************
;	RJ_INIT.ASM    #0.9
;	Initialization program for Romeo & Julia Project C. Meyer 7/96
;   Fr Kompatibilitt mit Motorola EVM, verwenden wie ADA_INIT.ASM
;*************************************************************************
;
;   portc usage:
;   bit8: SSI TX (from DSP to Codec)
;	bit7: SSI RX (from Codec to DSP)
;	bit6: SSI Clock
;	bit5: SSI Frame Sync
;
;*************************************************************************


;---DSP56002 on-chip peripheral addresses
IPR     equ     $FFFF   ;Interrupt Priority Register
BCR     equ     $FFFE   ;Bus Control Register
PLL     equ     $FFFD   ;PLL Control Register
SSIDR   equ     $FFEF   ;SSI Data Register
SSITX	equ 	$FFEF	;SSI-Transmit-Register
SSIRX	equ 	$FFEF	;SSI-Receive-Register
SSISR   equ     $FFEE   ;SSI Status Register
CRB     equ     $FFED   ;SSI Control Register B
CRA     equ     $FFEC   ;SSI Control Register A
PCD     equ     $FFE5   ;Port C Data Register
PBD     equ     $FFE4   ;Port B Data Register
PCDDR   equ     $FFE3   ;Port C Data Direction Register
PBDDR   equ     $FFE2   ;Port B Data Direction Register
PCC     equ     $FFE1   ;Port C Control Register
PBC     equ     $FFE0   ;Port B Control Register

HRX		equ 	$FFEB	;Host-Empfangsregister
HTX		equ	 	$FFEB	;Host-Senderegister
HCR		equ 	$FFE8	;Host-Controlregister
HSR		equ 	$FFE9	;Host-Sender-Controlregister
SCR		equ 	$FFF0	;Timer
SCCR	equ 	$FFF2

USR_PORT	equ 	$FFC8	;Romeo-8-Bit-Parallelport

;-------------------------------------------------------------------------
;The two buffers which are defined below are the source and
;destination storage for the codec Input/Output ISRs
;-------------------------------------------------------------------------
		org	x:LEVEL0
RX_BUFF_BASE    equ     *
InValL		ds	1	;Wert fr Berechnung links
InValR		ds	1	;Wert fr Berechnung rechts
TX_BUFF_BASE    equ     *
OutValL		ds	1	;Wert von Berechnung links
OutValR		ds	1	;Wert von Berechnung rechts
		org	x:ISRV0
FRAME_PTR	ds	1
IN_TEMP_R	ds	1
OUT_TEMP_R	ds	1
LEVEL_IDX	ds	1
FLAGS		ds	1	;Booleans
;Flag-Bits:
SLIDER_NEW	equ 1	;PC hat Regler abgeliefert
SAMPLE_OK	equ 0	;Sample fertig

		org     p:
rj_init
		ori	#$03,MR				;Maskiere Interrupts
		movep	#$0000,x:BCR	;0 Waits
		movep	#$4300,x:CRA	;SSI WORD LENGTH = 2x16
		movep	#$3A00,x:CRB	;SSI SYNCHRONOUS,ENABLE, RE, TE
		movep	#$1e0,x:PCC		;SSI-PORT an, SCI=GENERAL PURPOSE I/O
		movep	#$ff8,x:PCDDR	;PC0,1,2 als Input
		movep	#$fef,x:PCD		;PC0,1,2 high, SC1 LED aus
		movep	#$3A00,x:IPR	;SSI : IPL 2, Host : IPL 1 ,SCI:IPL 1
		movep   #$BA00,x:CRB	;SSI-Interrupts erlauben

		movep	#1,x:PBC		;Host-Interface an
		movep	#4,x:HCR		;HRIE,HTIE,HF2,HF3 = 0, HCIE=1
		;movep	#$1F0000,y:USR_PORT	;Wandler init
		move    #0,n6
		move	#RX_BUFF_BASE,r0
		rep #16
		move	n6,x:(r0)+      ;Pegelanzeige lschen
		move	#16,r0			;>15: Pegelausgabe abgeschlossen
		move 	r0,x:LEVEL_IDX
		rep	#3
		movep	x:HRX,x1		;leerlesen
		move	#Frame1,r0		;fr Frame-Erkennung
		move 	r0,x:FRAME_PTR
		move	n6,x:FLAGS
		andi    #$FC,mr         ; enable interrupts

;-----------------------------------------------------------------------
;this is the end of the RJ_INIT.ASM routine...the main program continues
;-----------------------------------------------------------------------
