unit BrTimeU;
{ Verfahren zur Visualisierung zweidimensionaler Arrays
  ber Farbabstufungen mit Vergrerung
  (1 Wert -> DspFac * DspFac Pixel) }

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, MMSystem, ExtCtrls;

type
  TBrushTimeForm = class(TForm)
    Brushes: TRadioGroup;
    TimeLabel: TLabel;
    procedure BrushesClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    DisplayBMP, StretchBMP: TBitmap;
    DIBInfo: TBitmapInfo;
    DIBBuf: Pointer; DIBBufHandle: THandle;
  protected
    procedure ArrayToBitmap(BMP: TBitmap);
    procedure ArrayToStretchedPixels(BMP: TBitmap);
  public
    { Public declarations }
  end;

var
  BrushTimeForm: TBrushTimeForm;
const
  MaxX = 110; MaxY = 40;  { Grenzen des Arrays }
  DspFac = 4;  { Skalierungsfaktor fr die Darstellung }

implementation

{$R *.DFM}

procedure TBrushTimeForm.FormCreate(Sender: TObject);
begin
  DisplayBMP := TBitmap.Create;
  DisplayBMP.Width := MaxX*DspFac; DisplayBMP.Height := MaxY*DspFac;
  StretchBMP := TBitmap.Create;
  StretchBMP.Width := MaxX; StretchBMP.Height := MaxY;
  with DIBInfo.bmiHeader do
  begin
    biHeight := MaxY*8; biWidth := MaxX*8;
    biSize := SizeOf(DIBInfo.bmiHeader);
    biPlanes := 1; biBitCount := 24;
    DIBBufHandle := GlobalAlloc(GMEM_MOVEABLE or GMEM_ZEROINIT,
      LongInt(biHeight)*biWidth*3);
    DIBBuf := GlobalLock(DIBBufHandle);
  end;
end;

procedure TBrushTimeForm.FormDestroy(Sender: TObject);
begin
  DisplayBMP.Destroy; StretchBMP.Destroy;
  GlobalUnlock(DIBBufHandle);
  GlobalFree(DIBBufHandle);
end;

{ Wrde bei einer echten Berechnung den entsprechend skalierten
  Wert aus einem Array liefern, begngt sich hier mit einer
  Skalierung von x auf den Bereich von 0 bis 255 }
function ScaleArray(x,y: Integer): Byte;
begin
  Result := MulDiv(y,255,MaxY);
end;


procedure TBrushTimeForm.BrushesClick(Sender: TObject);
type
  TBrushKind = (NoChange, UseCanvas, UseOwn, UseDIBits, UseStretch);
var x,y: Integer; StartTime: LongInt;
    BrushList: TList; TempBrush: TBrush;
    BrushKind: TBrushKind;
begin
  Invalidate; Update;
  BrushKind := TBrushKind(Brushes.ItemIndex);
  StartTime := timeGetTime;
  if BrushKind = UseOwn then
  begin
    BrushList := TList.Create;
    for x := 0 to 255 do
    begin
      TempBrush := TBrush.Create;
      TempBrush.Color := RGB(0,x,0);  { Green von 0 bis 255 }
      BrushList.Add(TempBrush);
    end;
  end;
  { Vergrerte Ausgabe des Arrays in ein Bitmap }
  if BrushKind = NoChange then DisplayBMP.Canvas.Brush.Color := clRed;
  case BrushKind of
    NoChange,
    UseCanvas,
    UseOwn:
      begin
        for y := 0 to MaxY do
          for x := 0 to MaxX do
            with DisplayBMP.Canvas do
            begin
              case BrushKind of
                NoChange: ;
                UseCanvas: Brush.Color := RGB(0,0,ScaleArray(x,y)); { Blue }
                UseOwn: Brush.Color := RGB(0,ScaleArray(x,y),0); { Green }
              end;
              FillRect(Rect(x*DspFac,y*DspFac,x*DspFac+DspFac,y*DspFac+DspFac));
            end;
       end;
    UseDIBits: ArrayToBitmap(DisplayBMP); { Red }
    UseStretch: ArrayToStretchedPixels(DisplayBMP);
  end;

  { Bitmap auf den Bildschirm }
  Canvas.Draw(0,0,DisplayBMP);

  if BrushKind = UseOwn then
  begin
    for x := 0 to 255 do TBrush(BrushList.Items[x]).Destroy;
    BrushList.Destroy;
  end;
  TimeLabel.Caption := 'Zeit (ms): '+IntToStr(timeGetTime-StartTime);
end;

{ ------------------------------------------ }
procedure TBrushTimeForm.ArrayToStretchedPixels(BMP: TBitmap);
var x,y: Integer; DC: HDC;
begin
  DC := StretchBMP.Canvas.Handle;
  for y := 0 to MaxY do
   for x := 0 to MaxX do
     SetPixel(DC,x,y,RGB(0,ScaleArray(x,y),0));
  StretchBlt(BMP.Canvas.Handle,0,0,MaxX*DspFac,MaxY*DspFac,
    DC,0,0,MaxX,MaxY,SRCPAINT);
end;
{ ------------------------------------------ }
{$IFNDEF WIN32}
procedure __AHIncr; far; external 'KERNEL' Index 114;
procedure __AHSHIFT; far; external 'KERNEL' index 113;
function OffsetPointer(P: Pointer; Ofs: Longint): Pointer; assembler;
asm
  MOV   AX,Ofs.Word[0]
  MOV   DX,Ofs.Word[2]
  ADD   AX,P.Word[0]
  ADC   DX,0
  MOV   CX,OFFSET __AHSHIFT
  SHL   DX,CL
  ADD   DX,P.Word[2]
end;
{$ENDIF}
procedure TBrushTimeForm.ArrayToBitmap(BMP: TBitmap);
type TColorVal = record B,G,R,B2: Byte; end;
var x,y: Integer;
    PColor: TColorVal; P: Pointer; LineBump, DspCount: Word;
begin
  LineBump := (MaxX*DspFac-DspFac)*3;
  DspCount := DspFac shl 8 + DspFac div 4;  { LoWord: 1 oder 2 }
  for y := 1 to MaxY do
  begin
{$IFDEF WIN32}
    P := @PChar(DIBBuf)[(MaxY-y)*MaxX*DspFac*DspFac*3];
{$ELSE}
    P := OffsetPointer(DIBBuf,LongInt(MaxY-y)*MaxX*DspFac*DspFac*3);
{$ENDIF}
    for x := 0 to MaxX-1 do
    begin
      FillChar(PColor,SizeOf(PColor),0);
      PColor.R := ScaleArray(x,y);
      { PColor.B2 := PColor.B; }  { <- bleibt hier sowieso 0 }
{$IFDEF WIN32}
      asm
        push ebx ; push edi  { benutzt Delphi selbst }
        cld
        mov eax,[PColor]  { eax: BGRB }
        mov bx,[DspCount]
        xor edx,edx
        mov dx,[LineBump]
        mov edi,[P]
        mov cl,bh { DspFac }
      @@1: {DspFac vertikale Wiederholungen }
        push ecx
        mov cl,bl  { DspFac }
      @@2:  { 3*eax = 12 Byte = 4 Pixel }
        stosd
        mov al,ah         { BRGB -> RRGB -> RGBR }
        ror eax,8         { RGBR -> GGBR -> GBRG }
                          { GBRG -> BBRG -> BRGB }
        stosd
        mov al,ah
        ror eax,8

        stosd
        mov al,ah
        ror eax,8

        loop @@2   { DspFac = 8: 1 Wiederholung }

        add edi,edx   { LineBump }

        pop ecx
        loop @@1

        xor eax,eax
        mov al,bh
        add al,al
        add al,bh
        add [P],eax  { DspFac*3 - sollte auch eleganter gehen }
        pop edi; pop ebx
      end;
{$ELSE}
      asm
        db $66; mov ax,Word Ptr[PColor]  { eax: BGRB }
        mov bx,[DspCount]
        mov dx,[LineBump]
        les di,[P]
        mov cl,bh { DspFac }
      @@1: {DspFac vertikale Wiederholungen }
        push cx
        mov cl,bl  { DspFac }
      @@2:  { 3*eax = 12 Byte = 4 Pixel }
        db $66; mov Word Ptr es:[di],ax;   { eax }
        mov al,ah         { BRGB -> RRGB -> RGBR }
        db $66; ror ax,8  { RGBR -> GGBR -> GBRG }
        add di,4          { GBRG -> BBRG -> BRGB }
        jz @@21Up
      @@21:
        db $66; mov Word Ptr es:[di],ax;
        mov al,ah
        db $66; ror ax,8
        add di,4
        jz @@22Up
      @@22:
        db $66; mov Word Ptr es:[di],ax;
        mov al,ah
        db $66; ror ax,8
        add di,4
        jz @@23Up
      @@23:
        loop @@2   { DspFac = 8: 1 Wiederholung }

        add di,dx   { LineBump }
        jc @@6
      @@4:
        pop cx
        loop @@1

        xor ax,ax
        mov al,bh
        add al,al
        add al,bh
        add Word Ptr[P],ax  { DspFac*3 }
        jnc @@8
        add Word Ptr[P+2],OFFSET __AHINCR;
        jmp @@8

      @@21Up: mov si,es; add si,OFFSET __AHINCR; mov es,si; jmp @@21
      @@22Up: mov si,es; add si,OFFSET __AHINCR; mov es,si; jmp @@22
      @@23Up: mov si,es; add si,OFFSET __AHINCR; mov es,si; jmp @@23
      @@6: mov si,es; add si,OFFSET __AHINCR; mov es,si; jmp @@4
      @@8:
      end;
{$ENDIF}
    end;
  end;
  with DIBInfo.bmiHeader do
  begin
    biWidth := MaxX*DspFac; biHeight := MaxY*DspFac;
  end;
  SetDIBits(Canvas.Handle,BMP.Handle,0,MaxY*DspFac,DIBBuf,DIBInfo,DIB_RGB_COLORS);
end;

end.
