unit Seg32u;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    Test32BitSeg: TButton;
    Memo1: TMemo;
    procedure Test32BitSegClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure __AHIncr; far; external 'KERNEL' Index 114;

procedure TForm1.Test32BitSegClick(Sender: TObject);
var P,P1,P2: PChar; LongOfs, LongVal: LongInt; ShortOfs: Word;
    P1616: PLongInt;
  procedure ShowSelector(SelPtr: PChar);
  var S: Word;
  begin
    S := Seg(SelPtr^);
    Memo1.Lines.Add(Format('Selektor: %4.4x',[S]));
    Memo1.Lines.Add(Format('  Start: %8.8x',[GetSelectorBase(S)]));
    Memo1.Lines.Add(Format('  Lnge: %8.8x',[GetSelectorLimit(S)+1]));
  end;
begin
  Memo1.Clear;
  { 160 KByte ber GlobalAlloc ergibt 3 Selektoren }
  P := GlobalLock(GlobalAlloc(GMEM_MOVEABLE,LongInt(160)*1024));
  P1 := Ptr(Seg(P^)+Ofs(__AHIncr),0);
  P2 := Ptr(Seg(P^)+2*Ofs(__AHIncr),0);
  ShowSelector(P);
  ShowSelector(P1);
  ShowSelector(P2);

  { Schreibaktion ber EDI mit mehr als 64 KByte }
  LongOfs := LongInt(66)*1024;  { P mit Offset 66 KByte }
  P1616 := Ptr(Seg(P1^),2*1024); { = P1 mit Offset 2 KByte }
  LongVal := $12345678;

  Memo1.Lines.Add(Format('Schreiben via %4.4x:(66K)', [Seg(P^)]));
  Memo1.Lines.Add(Format('  Wert = %8.8x',[LongVal]));
  asm
    db $66; mov di,Word Ptr[LongOfs];
    db $66; mov ax,Word Ptr[LongVal];
    mov es,Word Ptr [P+2];          { Selektor in ES }
    db $26,$67,$66,$89,$07; { mov es:[edi],eax }
  end;

  Memo1.Lines.Add(Format('Lesen ber %4.4x:(2K)', [Seg(P1^)]));
  Memo1.Lines.Add(Format('  Ergebnis = %8.8x', [P1616^]));
  FreeMem(P,0);
end;

end.
