#include "hint.h"
#include "MACMEM.h"

Handle NewTempHandle(size_t Size)	// Routinen fr temporren Mac-Speicher
{
	Handle	theHandle;
	char*	thePtr;
	
	OSErr	result;
	theHandle = TempNewHandle(Size, &result);
	if (result) return NULL;
	thePtr = *theHandle;			
	return theHandle;
}

void* GetTempMem(size_t Size)		
{
	Handle 	theHandle;
	OSErr	result;
	
	theHandle = TempNewHandle(Size, &result);
	if (result) return NULL;
	HLock(theHandle);
	if (MemError()) return NULL;
	return *theHandle; 
}

void* GetTempMemClear(size_t Size)
{
	Handle 	theHandle;
	char*	thePtr;
	OSErr	result;
	
	theHandle = TempNewHandle(Size, &result);
	if (result) return NULL;
	HLock(theHandle);
	if (MemError()) return NULL;
	thePtr = *theHandle;
	memset(thePtr,0,Size);
	return thePtr; 
}

void DisposTempMem(char* ptr)
{
	Handle 	theHandle;
	
	theHandle = RecoverHandle(ptr);
	if (!theHandle) return;
	else DisposHandle(theHandle); 
}

unsigned long coreleft(void)
{
	long grow;
	return TempMaxMem(&grow);
}
