unit Fnttimeu;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls, MMSystem;

type
  TFontTimeForm = class(TForm)
    Fonts: TRadioGroup;
    TimeLabel: TLabel;
    procedure FontsClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  FontTimeForm: TFontTimeForm;

implementation

{$R *.DFM}

procedure TFontTimeForm.FontsClick(Sender: TObject);
type TFontKind = (NoChange,UseCanvas,UseOwn,BackGndFonts);
var x,LineHeight,YPos,XPos: Integer;
    RegFont,BoldFont: TFont;
    FontKind: TFontKind;
    StartTime: LongInt;
begin
  Invalidate; Update;  { Lscht den Fensterinhalt }
  StartTime := timeGetTime;  { MMSystem: echte Millisekunden }
  FontKind := TFontKind(Fonts.ItemIndex);
  with Canvas.Font do
  begin
    Name := 'Arial'; Style := []; Size := 10;
  end;
  LineHeight := Canvas.TextHeight('X');  { Zeilenhhe }
  if (FontKind = UseOwn) or (FontKind = BackGndFonts) then
  begin { zwei eigene Fonts produzieren }
    RegFont := TFont.Create; BoldFont := TFont.Create;
    RegFont.Assign(Canvas.Font); BoldFont.Assign(Canvas.Font);
    BoldFont.Style := [fsBold];
  end;

  { Das gesamte Fenster mit wechselnden Zeichen fllen }
  with Canvas do
  begin
    YPos := 0;
    while YPos < ClientHeight do
    begin
      XPos := 0;
      repeat
        case FontKind of
          NoChange: ;
          UseCanvas, BackGndFonts: Font.Style := [];
          UseOwn: Font.Assign(RegFont);
        end;
        TextOut(XPos,YPos,'n'); Inc(XPos,TextWidth('n'));
        case FontKind of
          NoChange: ;
          UseCanvas, BackGndFonts: Font.Style := [fsBold];
          UseOwn: Font.Assign(BoldFont);
        end;
        TextOut(XPos,YPos,'F'); Inc(XPos,TextWidth('F'));
      until XPos >= ClientWidth;
      Inc(YPos,LineHeight);
    end;
  end;
  if (FontKind = UseOwn) or (FontKind = BackGndFonts) then
  begin
    BoldFont.Destroy; RegFont.Destroy;
  end;
  { Darstellung der bentigten Zeit }
  TimeLabel.Caption := 'Zeit: '+IntToStr(timeGetTime-StartTime);
end;

end.
