/*  A program to test and time complex forward and inverse fast fourier transform routines	*/
/* von John Green, modifiziert von cp 9/96 */

#ifdef _MSC_VER

#include <windows.h>

#endif

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <time.h>
#include <string.h>
#include "fftlib.h"


#define	NUMROWS 1			/* process Matrix of NumRows different ffts of length N	*/
#define N 1024				/* size of FFT must be a power of 2 */
#define NTIMES 1000			/* number of timings,invalid if too big (if a[0][0].Re == 0 | nan)*/

typedef  struct{
	double Re;
	double Im;
	} Complex;

#ifdef macintosh 
#define _MAC
#include <Timer.h>	
#endif

unsigned long bench(void)					// Microsec seit letztem Aufruf
{
#ifdef _MAC
	static UnsignedWide 	time;
	UnsignedWide  				oldtime;

	oldtime = time;
	Microseconds(&time);					// bei Ueberlauf komplementaeren Wert zurueck:
	return (time.lo >= oldtime.lo) ? time.lo - oldtime.lo : ~(time.lo - oldtime.lo);

#else
	static unsigned long	time;
	unsigned long					oldtime;
	
	oldtime = time;
#ifdef _MSC_VER

	time= GetTickCount();

	return ((time - oldtime) * 1000);	

#else

	time = clock();

	return ((time - oldtime) * 1000000) / CLK_TCK;

#endif


#endif
}


void dummy_ffts(double *ioptr, long M, long Rows, double *Utbl)
{
}

void dummy_rffts(double *ioptr, long M, long Rows, double *Utbl)
{
}

int do_fft(int verbose){
double		*Utbl;
Complex		(*a)[N];
double		(*b)[N];
long 		i, il;
long 		TheErr;
long		M;
char		s;
long		time;
long		overhead;

Utbl = (double *) malloc((N/4+1) * sizeof(double));
if (Utbl==0)
	TheErr = 2;
else
memset(Utbl,0,(N/4+1) * sizeof(double));
TheErr = FFTInit(&M, N, Utbl);

if(!TheErr){
	a = (Complex (*)[N]) malloc(NUMROWS*N * sizeof(Complex));
	if (a == 0) TheErr = 2;
}
memset(a,0,NUMROWS*N * sizeof(Complex));
if(!TheErr){

			/*  set up a simple test case */
	for (il=0; il<NUMROWS; il++){
		for (i=0; i<N; i++){
			a[il][i].Re = sqrt(il+i+.77777);
			a[il][i].Im = (il+i+.22222)*(il+i+.22222) / N - N/2;
		}
		a[il][0].Re = N+3;
		a[il][1].Re = 1-N;
	}

	printf("\n%d-Punkte-FFT (komplex)\n",N);
	bench();
	for (i=0;i<NTIMES;i++){		/* do NTIMES times for timing */
		dummy_ffts((double *)a, M, NUMROWS, Utbl);
		dummy_ffts((double *)a, M, NUMROWS, Utbl);
	}
	overhead = bench();;
	for (i=0;i<NTIMES;i++){		/* do NTIMES times for timing */
		ffts((double *)a, M, NUMROWS, Utbl);
		iffts((double *)a, M, NUMROWS, Utbl);
	}
	time = bench() - overhead;
	printf("%dx %8.4f s, 1x %8.4f ms, a[0][0].Re = %6e\n",NTIMES*2,(double)time/1000000,(double)time/1000/NTIMES/2, a[0][0].Re);
	
if (verbose)
{		// Testausgabe		
			/*  set up a simple test case */
	for (il=0; il<NUMROWS; il++){
		for (i=0; i<N; i++){
			a[il][i].Re = sqrt(il+i+.77777);
			a[il][i].Im = (il+i+.22222)*(il+i+.22222) / N - N/2;
		}
		a[il][0].Re = N+3;
		a[il][1].Re = 1-N;
	}

	ffts((double *)a, M, NUMROWS, Utbl);

	if (N*NUMROWS <= 256){
		for (il=0; il<NUMROWS; il++){
			printf("atrans = [ \n");
			for (i=0; i<N; i++)
					printf(" %+20.15e + j * ( %+20.15e ) \n", a[il][i].Re, a[il][i].Im);
			printf("]; \n");
			}
		}
	else { /* abbreviate big output */
 		printf("the first fft's last 32 values are: \n");
 		for (i=N-32; i<N; i++)
 					printf(" %+20.15e + j * ( %+20.15e ) \n", a[0][i].Re, a[0][i].Im);
	}

	iffts((double *)a, M, NUMROWS, Utbl);

	if (N*NUMROWS <= 256){
		for (il=0; il<NUMROWS; il++){
			printf("\n aitrans = [ \n");
			for (i=0; i<N; i++)
					printf(" %+20.15e + j * ( %+20.15e ) \n", a[il][i].Re, a[il][i].Im);
			printf("]; \n");
			}
		}
	else { /* abbreviate big output */
	 	printf("\n the first ifft's last 32 values are: \n");
	 	for (i=N-32; i<N; i++)
	 				printf(" %+20.15e + j * ( %+20.15e ) \n", a[0][i].Re, a[0][i].Im);
	}
}		// Ende Testausgabe


	free (a);
	free (Utbl);
	return 0; 

}

// real FFT
#if 0
Utbl = (double *) malloc((N/4+1)*sizeof(double));
if (Utbl==0)
	TheErr = 2;
else
TheErr = rFFTInit(&M, N, Utbl);

if(!TheErr){
	b = (double (*)[N]) malloc(NUMROWS*N*sizeof(double));
	if (b == 0) TheErr = 2;
}

if(!TheErr){

			/*  set up a simple test case */
	for (il=0; il<NUMROWS; il++){
		for (i=0; i<N; i+=2){
			b[il][i] = sqrt(il+i+.77777);	
			b[il][i+1] = (il+i+.22222)*(il+i+.22222) / N - N/2;	
		}
		b[il][0] = N+3;
		b[il][2] = 1-N;
	}

	printf("\n%d-Punkte-FFT (real)\n",N);
	bench();	
	for (i=0;i<NTIMES;i++){		/* do many times for timing */
		dummy_rffts((double *)b, M, NUMROWS, Utbl);
		dummy_rffts((double *)b, M, NUMROWS, Utbl);
	}
	overhead = bench();
	for (i=0;i<NTIMES;i++){		/* do many times for timing */
		rffts((double *)b, M, NUMROWS, Utbl);
		riffts((double *)b, M, NUMROWS, Utbl);
	}
	time = bench() - overhead;
	printf("%dx %8.4f s, 1x %8.4f ms, b[0][0] = %6e\n",NTIMES*2,(double)time/1000000,(double)time/1000/NTIMES/2, b[0][0]);
	
if (verbose)
{	
			/*  set up a simple test case */
	for (il=0; il<NUMROWS; il++){
		for (i=0; i<N; i+=2){
			b[il][i] = sqrt(il+i+.77777);	
			b[il][i+1] = (il+i+.22222)*(il+i+.22222) / N - N/2;	
		}
		b[il][0] = N+3;
		b[il][2] = 1-N;
	}

	rffts((double *)b, M, NUMROWS, Utbl);

	if (N*NUMROWS <= 512){
 		for (il=0; il<NUMROWS; il++){
			printf("atrans = [ \n");
			for (i=0; i<N; i+=2)
				printf(" %+20.15e + j * ( %+20.15e ) \n", b[il][i], b[il][i+1]);
			printf("]; \n");	
			}
		}
	else {  /* abbreviate big output */
		printf("the last 20 values of the first real fft are: \n");
		for (i=N-40; i<N; i+=2)
			printf(" %+20.15e + j * ( %+20.15e ) \n", b[0][i], b[0][i+1]);
	}

	riffts((double *)b, M, NUMROWS, Utbl);

	if (N*NUMROWS <= 512){
 		for (il=0; il<NUMROWS; il++){
			printf("aitrans = [ \n");
			for (i=0; i<N; i+=2)
				printf(" %+20.15e ; %+20.15e \n", b[il][i], b[il][i+1]);
			printf("]; \n");	
			}
		}
	else {  /* abbreviate big output */
		printf("the last 20 values of the first real ifft are: \n");
		for (i=N-40; i<N; i+=1)
				printf(" %+20.15e \n", b[il][i]);
	}

}
	free (b);
	free (Utbl);
	return 0;
}

#endif

else return TheErr;
}


int main(int argc,char *argv[])
{
	int		ErrorCode = 0;
	char 	s[256];
	int		verbose = 0;
	int 	realfft = 0;
	double	time;

	printf("%s","FFT-Benchmark (double)  (c) John Green/ cp 9/96");

				printf("\n     t:  Timertest");
				printf("\n     f:  FFT-Test");
				printf("\n     s:  Testausgabe ein/aus");
				printf("\nandere:  Ende\n");

	for (;;)	{
		printf("\n? ");
		gets(s);
		if (!strcmp(s,"f"))
			{
				if (ErrorCode = do_fft(verbose))
					printf("\nNicht genug Speicher!\n");

			}
		else if (!strcmp(s,"s"))
			{
				verbose = !verbose;
				printf(verbose ? "Ausgabe ein\n" : "Ausgabe aus\n");
			}
		else if (!strcmp(s,"t"))
			{
				printf("Start und Stop: Return-Taste druecken\n");
				gets(s);
				bench();
				gets(s);
				time = bench();
				printf("\nZeit: %8.2f Sekunden\n",(double)time/1000000);
			}	
		else break;
	}
	return ErrorCode;
}
