// defines operating system dependencies
// data types, fprint-masks etc.

#ifndef _PSOSDEP_H
#define _PSOSDEP_H

// list of supported platforms

//#define WIN_16	/* 16 Bit Windows */
//#define DOS_16	/* good old dos */
//#define NT			/* NT */
#define NTLOW		/* low res timer */
//#define OS2		/* OS/2 */
//#define OS2_HR	/* OS/2 using high resolution timer */
//#define MAC		/* Macintosh */
//#define NEXTSTEP	/* NextStep using kernel/port driver */
//#define ACORN		/* Acorn */

#ifdef NTLOW
#define NT
#endif

#ifdef WIN_16
#include <windows.h>
#define WORD unsigned int
#define DWORD unsigned long
// mask for (f)printf ...
#define DW(size)        "%"#size"lu"
#endif

#ifdef DOS_16
#define WORD unsigned int
#define DWORD unsigned long
#define BYTE unsigned short int
#define LONG unsigned long
#define FAR far
// mask for (f)printf ...
#define DW(size)        "%"#size"lu"

// usefull macros (lent from windows.h)
#define MAKELONG(low, high) ((LONG)(((WORD)(low)) | (((DWORD)((WORD)(high))) << 16)))
#define MAKELP(sel, off)    ((void FAR*)MAKELONG((off), (sel)))
#define LOWORD(l)           ((WORD)(DWORD)(l))
#define HIWORD(l)           ((WORD)((((DWORD)(l)) >> 16) & 0xFFFF))
#endif

#ifdef NT
#include <windows.h>
#include <largeint.h>
#endif

#ifdef OS2
#define INCL_DOSMISC
#define INCL_NOPMAPI	/* OS/2 Borland C needs that */
#include <os2.h>
#define WORD short unsigned int
#define DWORD unsigned int
#endif

#ifdef OS2_HR
#define INCL_DOSFILEMGR
#define INCL_DOSPROCESS
#include <os2.h>
typedef struct tagHRTIMESTAMP
{
    ULONG   ulMs;
    ULONG   ulNs;
    ULONG   ulVersion;

} HRTIMESTAMP,*PHRTIMESTAMP;
#define WORD short unsigned int
#define DWORD unsigned int
#endif

#ifdef NEXTSTEP
/* some preprocessors dont like objective c */
#import "../timerlib/td.h" 
#define WORD short unsigned int
#define DWORD unsigned int
#endif

#ifdef MAC
#define WORD short unsigned int
#define DWORD unsigned int
#include <Events.h>
#endif

#ifdef ACORN
#define WORD unsigned short
#define DWORD unsigned int
#endif

#ifdef UNIX
/* to be defined */
#endif

#ifndef DW
// mask for (f)printf and 32-Bit OS 
#define DW(size)        "%"#size"u"
#endif

#endif
