////////////////////////////////////////
//
//  Pi-Berechnung
//
//  Sprache:    ANSI-C++
//  Datei:      bbp.cpp
//  Autor:      Sebastian Wedeniwski, modifiziert von Andreas Stiller
//  fuer:       c't 12/96
//  Datum:      Oktober 1996
//

#include <limits.h>
#include <iostream.h>
#include <string.h>
#include <math.h>
#include <time.h>

#undef _portable

typedef unsigned int Digit;   // => unsigned long bei 16-Bit-Compilern

const Digit BETA = CHAR_BIT*sizeof(Digit); // BITs von unsigned int 
const Digit GAMMA = ~Digit(0);		   // Not 0 = 0xffffffff
const Digit GAMMA_LOW = GAMMA >> (BETA/2); // = 0xffff
const Digit GAMMA_HIGH = ~GAMMA_LOW;	   // = 0xffff0000

const Digit ALPHA = Digit(pow(10.0, int(log10(GAMMA+1.0)))+0.5);
const Digit ALPHA_WIDTH = Digit(log10(ALPHA));

// Routinen fr portable Version *******************

void digitmul(const Digit a, const Digit b, Digit &x, Digit &y)
// a*b = x*2^BETA + y.
{
	const Digit d = (a>>(BETA/2)) * (b&GAMMA_LOW);
	x = (a>>(BETA/2)) * (b>>(BETA/2));
	y = (a&GAMMA_LOW) * (b&GAMMA_LOW);
	Digit c = (a&GAMMA_LOW) * (b>>(BETA/2)) + d;
	if (c < d) x += GAMMA_LOW+1;
	x +=  c >> (BETA/2);
	c <<= BETA/2;
	y += c;
	if (y < c) x++;
}

void digitdiv(Digit a, Digit b, const Digit c, Digit &q, Digit &r)
// (a*2^BETA+b) / c = (q, r)
// Bedingung: a < c.
{
	const Digit HIBIT = ~(GAMMA >> 1);
	if (c <= GAMMA_LOW) {
		a = (a << BETA/2) | (b >> BETA/2);
		q = a/c;
		a -= q*c;
		a = (a << BETA/2) | (b & GAMMA_LOW);
		b = a/c;
		r = a -= b*c;
		q = (q << BETA/2) | b;
	} else {
		if (c & HIBIT) {
			for (Digit i = BETA; i; i--)
				if (a & HIBIT) {
					if (b & HIBIT) a -= ~a;
					else a += a;
					b -= ~b;
					a -= c;
				} else {
					if (b & HIBIT) a -= ~a;
					else a += a;
					if (a >= c) { a -= c; b -= ~b; }
					else b += b;
				}
		} else
			for (Digit i = BETA; i; i--) {
				if (b & HIBIT) a -= ~a;
				else a += a;
				if (a >= c) { a -= c; b -= ~b; }
				else b += b;
			}
		r = a; q = b;
	}
}

// ************************************************

void mul(Digit* pT, Digit* pPrd, const Digit a)
{
	Digit x,y;
	Digit c = 0;
	do {
#if !defined(_portable)            // falls nicht portable
	   Digit b=*--pPrd;
	   __asm {                 // Dann Intel 386 Code
	    push edx               // vorsichtshalber
	    mov eax,a              // mit 32bittigem Digit!!
	    mul dword ptr b
	    mov x,edx
	    mov y,eax
	    pop edx
	    }
#else
	   digitmul(a, *--pPrd, x, y);
#endif
	    y += c;
	    if (y < c) x++;
	    *pPrd = y;
	    c = x;
	} while (pPrd != pT);
}

void print(const Digit* a, Digit FixedSize)
{
	Digit* pOut = new Digit[FixedSize];
	if (!pOut) { cerr << "Out of Memory!\n"; return; }
	memcpy(pOut, a, FixedSize*sizeof(Digit));

	cout << *pOut << '.';
	*pOut = 0;
	for (Digit i = Digit((FixedSize-1)*BETA*log(2)/log(ALPHA));
	           i; i--) {
		mul(pOut, pOut+FixedSize, ALPHA);
		cout.width(ALPHA_WIDTH);
		cout.fill('0');
		cout << *pOut;
		*pOut = 0;
	}
	delete[] pOut;
	cout << endl;
}

void add(const Digit* pT, Digit* pSum, Digit* pSmd)
{
	Digit c;
	do {
		*--pSum += c = *--pSmd;
		if (c > *pSum)
			do {
				c = *--pSmd;
				*--pSum -= ~c;
			} while (c >= *pSum);
	} while (pSum != pT);
}

void sub(const Digit* pT, Digit* pDif, Digit* pSub)
{
	do {
		Digit c = *--pSub;
		if (*--pDif >= c) *pDif -= c;
		else {
			*pDif -= c;
			do *--pDif += c = ~(*--pSub); while (*pDif >= c);
		}
	} while (pDif != pT);
}


Digit* a;
Digit* pi;
Digit* a1;  // zeigt auf a[1];
Digit  maxSize;

void calcfraction (const Digit pot, const Digit denomin)
{    Digit firstrest;

     firstrest =(GAMMA >> pot) % denomin;
     *a        =(GAMMA >> pot) / denomin;
     // oder digitdiv(0, GAMMA >> pot, denomin, *a, firstrest);

     Digit rest = firstrest;
     Digit* p=a1;
     for (Digit k = 1; k < maxSize; k++) {

#if !defined(_portable)      // falls nicht portable
      Digit q;
     __asm {                 // Dann Intel 386 Code
       mov edx,rest          // Digit mu 32bittig sein !!
       mov eax,GAMMA
       div dword ptr denomin
       mov rest,edx
       mov q,eax
       }
     *p++=q;
#else
     digitdiv(rest, GAMMA, denomin, *p++, rest);
#endif
/*	   if (rest == firstrest) { // Abfrage auf Periode
	      Digit* n=a1;
	      for (p; p< a+maxSize; p++) *p=*n++;
	      break; 
	   } */
     }
}


int main(void)
{   Digit FixedSize,eingabe;
//  evlt. Alignment fr Stackframe bei 16 Bit Compilern :
//	short dummy;
//	maxSize=Digit(dummy);

	cout << "Anzahl der Dezimalstellen = "; cin >> eingabe;
	cout << " Digit " << BETA << " Stellen"; 
	cout << " Alpha = " << ALPHA << " width= "<< ALPHA_WIDTH << endl;
	FixedSize = Digit(eingabe/BETA/log10(2)) + 3;  // In Digitstellen
	maxSize = FixedSize-1;
	if (FixedSize > GAMMA/2/BETA) {                // zu gro ?
	 cerr << "zu gro fr aktuelle Digit Size!\n" ; return 1;}

	a = new Digit[FixedSize+1];
//	if ((int)a & 3) ++(short *)a;   // Dword Alignment fr a
	pi = new Digit[FixedSize+1];
//	if ((int)pi & 3) ++(short *)pi; // Dword Alignment fr pi

	if (!a || !pi) { cerr << "Out of Memory!\n"; return 1; }

	Digit* piEnd = pi+FixedSize;         // Pointer auf ende
	Digit* piAnf = pi+1;                 // Pointer auf start
	a1 = a+1;                            // Pointer auf a+1;
	// StartWert fr n=0   => 3 1/6  => (bin) 3,0010 0010 ...

	*pi = 3;                                    // erstes Digit,
	memset(piAnf, 0x22, maxSize*sizeof(Digit)); // binr fr 1/6
	memset (a,0,maxSize*sizeof(Digit));
	time_t start = clock();

	Digit j = 1;
	Digit m = 4;

	while (1) {
		j++;
	// 1. Bruch 1/16^n* 4/(8n+1) =  1/(2^(j)*i) zuaddieren
	// mit j=4n-2 mod 2^(beta) , i= 8n+1 = 2m+1
		calcfraction (j,m*2+1);
		add(piAnf, piEnd, a+maxSize);

		j += 2;
		if (j >= BETA) {
		// wieder ein Digit fertig, dann
		// maxsize um ein Digit verringern
		j -= BETA;
		   if (--maxSize == 1) break; // alles fertig !
		   piAnf++;
		}

	  //3. Bruch 1/16^n* 1/(8*n+5) = 1/(2^(j)*i)
	  //   mit j=4*n mod 2^(beta) und i=8*n+5 = 2m+5
		calcfraction (j++,m*2+5);
		sub(piAnf, piEnd, a+maxSize);

	  // 2.Bruch 1/16^n * 2/(8n+4) = 1/(2^(j) * i) abziehen
	  // mit  j=4n+1 mod 2^(beta) und i=2n+1  = m/2+1
		calcfraction (j,m/2 +1);
		sub(piAnf, piEnd, a+maxSize);

	  // 4. Bruch 1/16^n * 2/(8n+4) = 1/(2^(j) * i) abziehen
	  //    mit j=4n+1 mod 2^(beta) und i= 4n+3 = m+3
		calcfraction (j,m+3);
		sub(piAnf, piEnd, a+maxSize);
		m+=4;
	}
	time_t stop = clock();

	print(pi, FixedSize);
	cout << (eingabe) ;
	cout << " time [s] = " <<  double(stop-start)/CLK_TCK;
	cout << endl;
	delete[] pi;
	delete[] a;
    return 0;
}
