PROGRAM VESA24mT; (* Turbo Pascal + UNIT VESA24m *)
(* Anwendung der Unit VESA24m fr Grafik mit Truecolor *)
USES CRT, VESA24m;

CONST
  CursUp=#72; CursDo=#80;  CursRi=#77; CursLe=#75;
  CursHo=#71; CursEnd=#79; PageUp=#73; PageDo=#81;

VAR
  x,y,b,h, Blau, Gruen, Rot, VESAErr, MemSize, Version  : WORD;
  Ch                                  : CHAR;
  OEMString                           : STRING;

PROCEDURE DispVESAInfoBlock;
BEGIN
  WRITELN ('           VESA-Bios: vorhanden');
  GetVESAInfo (OEMString,MemSize,Version);
  WRITELN ('          Hersteller: ',OEMString);
  WRITELN ('             Version: ',Hi(Version),'.',Lo(Version));
  WRITELN ('Video-Memory [kByte]: ',MemSize);
  WRITELN;
END;                             { PROCEDURE DispVESAInfoBlock }

PROCEDURE WriteInfo;
BEGIN
  WRITELN ('    Richtungstasten : Sprite-Position');
  WRITELN ('         Pos1, Ende : Sprite-Breite');
  WRITELN ('  Bild auf, Bild ab : Sprite-Hhe');
  WRITELN ('        1,2,3,4,5,6 : Farbkomponenten');
END;                                    { PROCEDURE WriteInfo }

PROCEDURE DispColorStatus;
BEGIN
  FillSprite (10,20,Blau,8,255,0,0);
  FillSprite (Blau+10,20,255-Blau,8,128,128,128);
  FillSprite (10,30,Gruen,8,0,255,0);
  FillSprite (Gruen+10,30,255-Gruen,8,128,128,128);
  FillSprite (10,40,Rot,8,0,0,255);
  FillSprite (Rot+10,40,255-Rot,8,128,128,128);
END;                               { PROCEDURE DispColorStatus }

PROCEDURE SpriteTest;
BEGIN
  x:=200; y:=200; b:=150; h:=100;
  REPEAT
    FillSprite(x,y,b,h,Blau,Gruen,Rot);   { Zeichne ein Sprite }
    DispColorStatus;                      { Zeichne Farbbalken }
    Ch:=READKEY;                             { Warte auf Taste }
    IF Ch=#0 THEN Ch:=READKEY;
    FillSprite(x,y,b,h,0,0,0);        { Lsche das alte Sprite }
    CASE Ch OF
            '1'  : IF Blau > 0 THEN DEC (Blau);
            '2'  : IF Blau < 255 THEN INC (Blau);
            '3'  : IF Gruen > 0 THEN DEC (Gruen);
            '4'  : IF Gruen < 255 THEN INC (Gruen);
            '5'  : IF Rot > 0 THEN DEC (Rot);
            '6'  : IF Rot < 255 THEN INC (Rot);
        CursEnd  : INC (b,1);  CursHo   : DEC (b,1);
        PageUp   : DEC (h,1);  PageDo   : INC (h,1);
        CursRi   : INC (X,1);  CursLe   : DEC (X,1);
        CursUp   : DEC (Y,1);  CursDo   : INC (Y,1);
    END;
  UNTIL Ch IN [#13, #27];        { Abbruch bei Return oder ESC }
END;                                    { PROCEDURE SpriteTest }

BEGIN                                          { Hauptprogramm }
  IF VESAAvail THEN DispVESAInfoBlock
    ELSE BEGIN WRITELN ('Kein VESA-Bios vorhanden.');
           Ch:=READKEY; EXIT;
         END;
  WriteInfo;
  Ch:=READKEY;
  SetVESAMode(640,480,VESAErr);
  IF VESAErr<>0 THEN
  BEGIN
    SetAlfaMode;
    CASE VESAErr OF
      1 : WRITELN('Modus nicht vom VESA-BIOS untersttzt');
      2 : WRITELN('ModeInfoBlock nicht gefllt');
      3 : WRITELN('Einschalten des Modus fehlgeschlagen');
    END;
    Ch:=READKEY; EXIT;
  END;
  Blau:=180; Gruen:=180; Rot:=180;
  SpriteTest;
  SetAlfaMode;
END.
