PROGRAM VESA8_T; (* Turbo Pascal + UNIT VESA8 *)

(* Anwendung der Unit VESA8 fr Grafik mit 256 Farben *)

USES CRT, VESA8;

PROCEDURE WriteInfo;
BEGIN
  WRITELN ('Test der UNIT VESA8 unter Turbo Pascal.');
  WRITELN;
  WRITELN ('Die UNIT VESA8 enthlt Prozeduren, die einen groen Teil der');
  WRITELN ('Grafikausgabe fr technisch/wissenschaftliche Anwendungen mit');
  WRITELN ('256 Farben und Auflsungen von 640*400 bis 1200*1024 ermglichen.');
  WRITELN ('Die UNIT VESA8 setzt voraus, da ein VESA-Treiber auf der');
  WRITELN ('VGA-Karte vorhanden ist oder als residentes Programm geladen');
  WRITELN ('wurde.');
  WRITELN;
  WRITELN ('Dieses Programm soll die Anwendung der UNIT VESA8 zeigen und');
  WRITELN ('gleichzeitig als Test fr die einzelnen Prozeduren dienen. Dazu');
  WRITELN ('gestattet es, die zu testenden Objekte ber den Bildschirm zu');
  WRITELN ('bewegen, auszumessen, die Bankgrenzen anzuzeigen und whrend');
  WRITELN ('eines jeden Tests zwischen den verschiedenen Auflsungen');
  WRITELN ('umzuschalten.');
  WRITELN;
  WRITELN ('Jrgen Petsch fr c`t 2/97');
  WRITELN;
  WRITELN;
END;                                                  { PROCEDURE WriteInfo }


CONST
      ScanCuUp=$48;     ScanCuDo=$50;      ScanCuRi=$4D;       ScanCuLe=$4B;
  ScanCtrlCuUp=$8D; ScanCtrlCuDo=$91;  ScanCtrlCuRi=$74;   ScanCtrlCuLe=$73;
   ScanAltCuUp=$98;  ScanAltCuDo=$A0;   ScanAltCuRi=$9D;    ScanAltCuLe=$9B;

   ScanCuHo=71; ScanCuEnd=79;  ScanPageUp=73; ScanPageDo=81;
    ScanESC=$01;   ScanBS=$E;      ScanCR=$1C;
  ScanSpace=$39;    ScanB=48;

     ScanF1=$3B;   ScanF2=$3C;     ScanF3=$3D;   ScanF4=$3E;
     ScanF5=$3F;   ScanF6=$40;     ScanF7=$41;   ScanF8=$42;
     ScanF9=$43;   ScanF10=$44;
     Zeilabst=16;

TYPE
  Save = ^BYTE;

VAR
  SpriteSave,SpriteSave1, ZoomSave : Save;
  x,y,b,br,h,ho,r                  : WORD;
  i, Mode                          : WORD;
  Xmax, Ymax                       : WORD;  { Sichtbarer Bildschirm }
  XmaxVirt, YmaxVirt               : WORD;  { Virtueller Bildschirm }
  Xoffs, Yoffs                     : WORD;  { Verschiebg sichtbar/virtuell }
  Xfaecher, Yfaecher               : WORD;  { Gre des Hintergrundfchers }
  VESAErr                          : WORD;  { fr SetVESAMode }
  MemSize, Version                 : WORD;  { fr GetVESAInfo }
  ErrCode                          : WORD;  { fr Sprite2File, Sprite2Bmp..}
  Buffer                           : ARRAY [0..9999] OF BYTE;
  BufferPtr                        : POINTER;
  f                                : FILE;
  Ch                               : CHAR;
  ScanCode                         : BYTE;
  PathName, Title, OEMString       : STRING;
  HelpOn, GlobalXOR, Virt          : BOOLEAN;
  X0mess, X1mess, Y0mess, Y1mess   : WORD; { Koordinaten des Memoduls }
  Xzoom, Yzoom, Bzoom, Hzoom       : WORD; { Koordinaten von Zoom }


PROCEDURE PutText (x,y,CharSize,Farbe:WORD; Txt:STRING);
VAR i : BYTE;
BEGIN
  FOR i:=1 TO LENGTH(txt) DO BEGIN
    PutChar(x,y,BYTE(txt[i]),CharSize,Farbe);
    INC(x,8*((CharSize SHR 1)+1))        { Neue X-Pos }
  END
END;                                                    { PROCEDURE PutText }

PROCEDURE StartTimer;
BEGIN
  ASM           MOV	AL,$34		{ Select Counter #0, Read Lo/HIByte }
					{ Counter Mode 2, Binary Count }
		OUT	$43,AL		{ Command-Port = 43H }
		MOV	AL,0
		OUT	$40,AL		{ LoByte = 0 }
		OUT	$40,AL		{ HiByte = 0 }
  END;
END;

PROCEDURE DispTimer (X,Y : WORD);
VAR Timer : WORD; Zeit : STRING;
BEGIN
  ASM
		MOV	AL,0		{ Latch Counter #0 }
		OUT	$43,AL
		IN	AL,$40		{ Read Lobyte }
		XCHG	AL,AH		{ ins HiByte  }
		IN	AL,$40		{ Read HiByte }
		XCHG	AH,AL
		NEG	AX		{ Timer zhlt abwrts ! }
                MOV     [Timer],AX
  END;
  STR (LONGINT (Timer)*100 DIV 119,Zeit);
  SetMovMode;
  FillSprite(X,Y,48,16,0);
  PutText (X+8,Y,0,7,Zeit);
END;


PROCEDURE PutWord (x,y,CharSize,Farbe,Zahl:WORD);
VAR txt : STRING;
    i : BYTE;
BEGIN
  STR(zahl,txt);
  FOR i:=1 TO LENGTH(txt) DO BEGIN
    PutChar(x,y,BYTE(txt[i]),CharSize,Farbe);
    INC(x,8*((CharSize SHR 1)+1))        { Neue X-Pos }
  END
END;                                                    { PROCEDURE PutWord }


PROCEDURE PutFaecher;
VAR x,y : WORD;
BEGIN
  FOR x:=0 TO (Xfaecher DIV 32) DO
    PutLine(32*x,0,Xfaecher-32*x,Yfaecher,x);
  FOR y:=0 TO (Yfaecher DIV 32) DO
    PutLine(0,32*y,Xfaecher,Yfaecher-32*y,y);
END;                                                 { PROCEDURE PutFaecher }

PROCEDURE PutGitter (Yoffs:WORD);
VAR X,Y:WORD;
BEGIN
  FOR X:=0 TO Xmax DIV 16 DO PutLineV (16*X,Yoffs,Ymax+1,X);
  FOR Y:=0 TO Ymax DIV 16 DO PutLineH (0,Yoffs+16*Y,Xmax,Y);
END;                                                  { PROCEDURE PutGitter }


PROCEDURE PutHelp;
VAR x,y,y0,b,h  : WORD;
BEGIN
  x:=360; y:=120; y0:=8; b:=256; h:=288;
  BufferPtr:=@Buffer;
  IF HelpOn
  THEN BEGIN                                      { Restauriere Hintergrund }
    File2Sprite(x,y,b,h,Pathname,ErrCode,BufferPtr,SIZEOF(Buffer));
    ASSIGN (f,PathName);
    ERASE (f);
    HelpOn:=FALSE;
  END
  ELSE BEGIN                                          { Sichere Hintergrund }
    PathName:='C:HELPSPRI.SCR'+Chr(0);
    Sprite2File(x,y,b,h,Pathname,ErrCode,BufferPtr,SIZEOF(Buffer));            
    SetMOVMode;
    FillSprite(x,y,b,h,7);                           { Erzeuge Grundfche ..}
    PutRect (x+4,y+4,b-8,h-8,9);                           {..mit Umrandung }
                                                      { Zeige Hilfstexte an }
    PutText (x+10,y+y0+0*ZeilAbst,0,9, '     Curs..bewegen um 8');   
    PutText (x+10,y+y0+1*ZeilAbst,0,9, 'Ctrl Curs..bewegen um 1');
    PutText (x+10,y+y0+2*ZeilAbst,0,9, ' Alt Curs..grer/kleiner um 1');
    PutText (x+10,y+y0+3*ZeilAbst,0,9, '        B..Bankgrenzen ein');
    PutText (x+10,y+y0+4*ZeilAbst,0,9, '       F1..Help ein/aus');
    PutText (x+10,y+y0+5*ZeilAbst,0,9, '       F2..XOR ein/aus');
    PutText (x+10,y+y0+6*ZeilAbst,0,9, '       F3..Melinien');
    PutText (x+10,y+y0+7*ZeilAbst,0,9, '       F4..Zoom');
    PutText (x+10,y+y0+8*ZeilAbst,0,9, '       F5.. 640*400');
    PutText (x+10,y+y0+9*ZeilAbst,0,9, '       F6.. 640*480');
    PutText (x+10,y+y0+10*ZeilAbst,0,9,'       F7.. 800*600');
    PutText (x+10,y+y0+11*ZeilAbst,0,9,'       F8..1024*768');
    PutText (x+10,y+y0+12*ZeilAbst,0,9,'       F9..1152*864');
    PutText (x+10,y+y0+13*ZeilAbst,0,9,'      F10..1280*1024');
    PutText (x+10,y+y0+14*ZeilAbst,0,9,'       CR..nchster Test');
    PutText (x+10,y+y0+15*ZeilAbst,0,9,'       BS..voriger Test');
    PutText (x+10,y+y0+16*ZeilAbst,0,9,'      ESC..Abbruch');
    HelpOn:=TRUE;
  END;
END;                                                    { PROCEDURE PutHelp }


PROCEDURE DispVESAInfoBlock;
BEGIN
  WRITELN ('           VESA-Bios: vorhanden');
  GetVESAInfo (OEMString,MemSize,Version);
  WRITELN ('          Hersteller: ',OEMString);
  WRITELN ('             Version: ',Hi(Version),'.',Lo(Version));
  WRITELN ('Video-Memory [kByte]: ',MemSize);
  WRITELN;
END;                                          { PROCEDURE DispVESAInfoBlock }


PROCEDURE PutBackGnd;
VAR TxtX, TxtY, Zeile :STRING;

BEGIN
  SetMovMode;
  ClearVGAMem;
  HelpOn:=FALSE;
  PutFaecher;
  PutRect(0,0,XFaecher-1,YFaecher-1,15);
  PutText (10,4,0,7,'F1-> Hilfe');
  STR (Xmax+1,TxtX); STR(Ymax+1,TxtY); Zeile:= ('Sichtbar: '+TxtX+'*'+TxtY);
  PutText (160,4,0,7,Zeile);
  STR (XFaecher,TxtX); STR(YFaecher,TxtY); Zeile:= ('Virtuell: '+TxtX+'*'+TxtY);
  PutText (160,20,0,7,Zeile);
  PutText (100,48,2,7,Title);
  IF GlobalXOR THEN PutText (360,4,0,7,'XOR-Mode')
               ELSE PutText (360,4,0,7,'MOV-Mode');
END;                                                { PROCEDURE PutBackGnd }


PROCEDURE SetMode (Breite, Hoehe: WORD);
VAR DummyVESAErr : WORD;
BEGIN
  HelpOn:=FALSE;
  ClearVGAMem;
  SetVESAMode (Breite,Hoehe,VESAErr);
  IF VESAErr<>0 THEN                             { SetMode fehlgeschlagen ? }
  BEGIN                                  { Schalte zurck auf vorigen Modus }
    SetVESAMode(Xmax+1,Ymax+1,DummyVESAErr);
    IF Virt THEN BEGIN
      XmaxVirt:=(3*(Xmax+1) DIV 2)-1;
      YmaxVirt:=(LONGINT (1024*LONGINT(MemSize)) DIV (XmaxVirt+1)-1);
      Xfaecher:=XmaxVirt+1;
      Yfaecher:=YmaxVirt+1;
      SetBytesPerScanline (XmaxVirt+1);
    END;
    CASE VESAErr OF
      1 : PutText(100,100,1,7,'Modus nicht vom VESA-BIOS untersttzt');
      2 : PutText(100,100,1,7,'ModeInfoBlock nicht gefllt');
      3 : PutText(100,100,1,7,'Einschalten des Modus fehlgeschlagen');
    END;
  Ch:=READKEY;
  END
  ELSE BEGIN
    Xmax:=Breite-1; Ymax:=Hoehe-1;
    XFaecher:=Breite; YFaecher:=Hoehe;
    SetBytesPerScanline (Breite);
    IF Virt THEN
    BEGIN
      Xoffs:=0; Yoffs:=0;
      XmaxVirt:=(3*Breite DIV 2)-1;
      YmaxVirt:=(LONGINT (1024*LONGINT(MemSize)) DIV (XmaxVirt+1)-1);
      Xfaecher:=XmaxVirt+1; Yfaecher:=YmaxVirt+1;
      SetBytesPerScanline (XmaxVirt+1);
    END;
  END;
  PutBackGnd;
END;                                                    { PROCEDURE SetMode }


PROCEDURE Zoom;               { Erlaubt die Bewegung einer gezoomten Flche }
BEGIN
  Xzoom:=150; Yzoom:=150; Bzoom:=128; Hzoom:=128;
  GETMEM (ZoomSave,Bzoom*Hzoom);
  REPEAT
    GetSprite (Xzoom,Yzoom,Bzoom,Hzoom,ZoomSave);     { Flche zum ZoomSave }
    SetXORMode;
    PutRect (Xzoom-1,Yzoom-1,Bzoom+2,Hzoom+2,7);        { Zeichne Umrandung }
    ZoomSprite(Xzoom,Yzoom,Bzoom,Hzoom,ZoomSave);{ Zoome vom Save zum Screen }
    ScanCode:=GetScanCode;                                { Warte auf Taste }
    PutSprite (Xzoom,Yzoom,Bzoom,Hzoom,ZoomSave); { Restauriere Hintergrund }
    PutRect (Xzoom-1,Yzoom-1,Bzoom+2,Hzoom+2,7);         { Lsche Umrandung }
    CASE ScanCode OF
      ScanCtrlCuUp   : DEC (Yzoom);
      ScanCtrlCuDo   : INC (Yzoom);
      ScanCtrlCuRi   : INC (Xzoom);
      ScanCtrlCuLe   : DEC (Xzoom);
      ScanCuUp       : DEC (Yzoom,8);
      ScanCuDo       : INC (Yzoom,8);
      ScanCuRi       : INC (Xzoom,8);
      ScanCuLe       : DEC (Xzoom,8);
    END;
  UNTIL ScanCode IN [ScanCR, ScanESC];
  FREEMEM (ZoomSave,Bzoom*Hzoom);
  ScanCode:=255;
END;


PROCEDURE PutMess;             { Zeigt die Melinien und die Koordinaten an }
BEGIN
  PutLineH (0,Y0mess,Xmax,10);
  PutLineV (X0mess,0,Ymax,10);
  PutLineH (0,Y1mess,Xmax,12);
  PutLineV (X1mess,0,Ymax,12);
  PutText (10,80,0,10,'X = ');
  PutText (10,96,0,10,'Y = ');
  PutText (10,112,0,7,'dX = ');
  PutText (10,128,0,7,'dY = ');
  PutWord (70,80,0,10,X0mess);
  PutWord (70,96,0,10,Y0mess);
  PutWord (70,112,0,7,X1mess-X0mess);
  PutWord (70,128,0,7,Y1mess-Y0mess);
END;


PROCEDURE Mess;                       { Erlaubt die Bewegung von Melinien
                                       und zeigt die entspr. Koordinaten an }
BEGIN
  SetXORMode;
  PutMess;                                   { Zeige Melinien und Werte an }
  REPEAT
    ScanCode:=GetScanCode;
    IF ScanCode=ScanF4 THEN Zoom;
    PutMess;                                   { Lsche Melinien und Werte }
    CASE ScanCode OF
      ScanCtrlCuUp   : DEC (Y0Mess);
      ScanCtrlCuDo   : INC (Y0Mess);
      ScanCtrlCuRi   : INC (X0mess);
      ScanCtrlCuLe   : DEC (X0mess);
      ScanCuUp       : DEC (Y0mess,8);
      ScanCuDo       : INC (Y0mess,8);
      ScanCuRi       : INC (X0mess,8);
      ScanCuLe       : DEC (X0mess,8);
      ScanAltCuUp    : DEC (Y1mess);
      ScanAltCuDo    : INC (Y1mess);
      ScanAltCuRi    : INC (X1mess);
      ScanAltCuLe    : DEC (X1mess);
      ScanCuHo       : BEGIN DEC (X0mess); DEC (X1mess); END;
      ScanCuEnd      : BEGIN INC (X0mess); INC (X1mess); END;
      ScanPageUp     : BEGIN DEC (Y0mess); DEC (Y1mess); END;
      ScanPageDo     : BEGIN INC (Y0mess); INC (Y1mess); END;
    END;
    PutMess;                            { Zeige neue Melinien und Werte an }
  UNTIL ScanCode IN [ScanESC, ScanCR];
  PutMess;                                     { Lsche Melinien und Werte }
  ScanCode:=255;
END;                                                    { PROCEDURE PutMess }


PROCEDURE LookForCmd;    { erhlt einen ScanCode und verzweigt entsprechend }
BEGIN
  SetMOVMode;
  CASE ScanCode OF
    ScanF1         : PutHelp;
    ScanF2         : BEGIN
                       GlobalXOR:=NOT GlobalXOR;
                       IF GlobalXOR THEN BEGIN
                         FillSprite (360,4,64,16,0);
                         PutText (360,4,0,7,'XOR-Mode');
                       END
                       ELSE BEGIN
                         FillSprite (360,4,64,16,0);
                         PutText (360,4,0,7,'MOV-Mode');
                         IF r>120 THEN r:=120;
                         IF b>300 THEN b:=300;
                         IF h>200 THEN h:=200;
                       END;
                     END;
    ScanF5         : SetMode (640,400);
    ScanF6         : SetMode (640,480);
    ScanF7         : SetMode (800, 600);
    ScanF8         : SetMode (1024, 768);
    ScanF9         : SetMode (1152,864);
    ScanF10        : SetMode (1280,1024);
    ScanB          : ShowBanks;
    ScanCuUp       : DEC(y,8);
    ScanCuDo       : INC(y,8);
    ScanCuRi       : INC(x,8);
    ScanCuLe       : DEC(x,8);
    ScanCtrlCuUp   : DEC(y);
    ScanCtrlCuDo   : INC(y);
    ScanCtrlCuRi   : INC(x);
    ScanCtrlCuLe   : DEC(x);
  END
END;                                                 { PROCEDURE LookForCmd }


PROCEDURE LineHTest;                        { Erlaubt den Test von PutLineH }
BEGIN
  Title:=('LineHTest');
  PutBackGnd;
  x:=250; y:=100; b:=200;
  REPEAT
    IF GlobalXOR THEN SetXORMode ELSE SetMOVMode;
    StartTimer;
    PutLineH(x,y,b,15);                               { Zeichne Horizontale }
    DispTimer (540,4);
    PutText (460,4,0,7,'Zeit [s]:');
    ScanCode:=GetScanCode;                                { Warte auf Taste }
    IF ScanCode=ScanF3 THEN Mess;
    IF ScanCode=ScanF4 THEN Zoom;
    IF GlobalXOR THEN
    BEGIN                                              { Lsche Horizontale }
      SetXORMode;
      PutLineH(x,y,b,15);
    END;
    LookForCmd;                            { Hilfe, XOR, Modus, Bnke, x, y }
    CASE ScanCode OF                                                    { b }
      ScanAltCuLe    : DEC(b);
      ScanAltCuRi    : INC(b);
    END;
  UNTIL ScanCode IN [ScanCR, ScanBS, ScanESC];
END;                                                  { PROCEDURE LineHTest }


PROCEDURE LineVTest;                        { Erlaubt den Test von PutLineV }
BEGIN
  Title:=('LineVTest');
  PutBackGnd;
  x:=250; y:=100; h:=200;
  REPEAT
    IF GlobalXOR THEN SetXORMode ELSE SetMOVMode;
    StartTimer;
    PutLineV(x,y,h,15);                                 { Zeichne Vertikale }
    DispTimer (540,4);
    PutText (460,4,0,7,'Zeit [s]:');
    ScanCode:=GetScanCode;                                { Warte auf Taste }
    IF ScanCode=ScanF3 THEN Mess;
    IF ScanCode=ScanF4 THEN Zoom;
    IF GlobalXOR THEN
    BEGIN                                                { Lsche Vertikale }
      SetXORMode;
      PutLineV(x,y,h,15);                
    END;
    LookForCmd;                            { Hilfe, XOR, Modus, Bnke, x, y }
    CASE ScanCode OF                                                    { h }
      ScanAltCuUp    : DEC(h);
      ScanAltCuDo    : INC(h);
    END;
  UNTIL ScanCode IN [ScanCR, ScanBS, ScanESC];
END;                                                  { PROCEDURE LineVTest }


PROCEDURE LineTest;                          { Erlaubt den Test von PutLine }
VAR
Xend, Yend   : WORD;
BEGIN
  Title:=('LineTest');
  PutBackGnd;
  x:=400; y:=100; Xend:=100; Yend:=300;
  REPEAT
    PutText (100,80,0,7,'Alt Curs: anderes Ende bewegen');
    IF GlobalXOR THEN SetXORMode ELSE SetMOVMode;
    StartTimer;
    PutLine(x,y,Xend,Yend,15);                             { Zeichne Gerade }
    DispTimer (540,4);
    PutText (460,4,0,7,'Zeit [s]:');
    ScanCode:=GetScanCode;                                { Warte auf Taste }
    IF ScanCode=ScanF3 THEN Mess;
    IF ScanCode=ScanF4 THEN Zoom;
    IF GlobalXOR THEN
    BEGIN                                                   { Lsche Gerade }
      SetXORMode;
      PutLine(x,y,Xend,Yend,15);
    END;
    LookForCmd;                            { Hilfe, XOR, Modus, Bnke, x, y }
    CASE ScanCode OF                                           { Xend, Yend }
      ScanAltCuLe    : DEC(Xend);
      ScanAltCuRi    : INC(Xend);
      ScanAltCuUp    : DEC(Yend);
      ScanAltCuDo    : INC(Yend);
    END;
  UNTIL ScanCode IN [ScanCR, ScanBS, ScanESC];
END;                                                   { PROCEDURE LineTest }


PROCEDURE RectTest;                          { Erlaubt den Test von PutRect }
BEGIN
  Title:=('RectangleTest');
  PutBackGnd;
  x:=200; y:=200; b:=300; h:=200;
  REPEAT
    IF GlobalXOR THEN SetXORMode
    ELSE BEGIN
      SetMOVMode;
      GetSprite(x,y,b+1,h+1,SpriteSave);
    END;
    StartTimer;                                        { Starte Zeitmessung }
    PutRect(x,y,b,h,9);                              { Zeichne das Rechteck }
    DispTimer (540,4);                 { Stop Zeitmessung und zeige Zeit an }
    PutText (460,4,0,7,'Zeit [s]:');
    ScanCode:=GetScanCode;                                { Warte auf Taste }
    IF ScanCode=ScanF3 THEN Mess;
    IF ScanCode=ScanF4 THEN Zoom;
    IF GlobalXOR THEN
    BEGIN                                             { Lsche das Rechteck }
      SetXORMode;
      PutRect(x,y,b,h,9);
    END
    ELSE PutSprite(x,y,b+1,h+1,SpriteSave);    { oder rest. es aus dem Mem. }
    LookForCmd;                            { Hilfe, XOR, Modus, Bnke, x, y }
    CASE ScanCode OF                                      { Breite und Hhe }
      ScanAltCuLe    : IF b>2 THEN DEC(b);
      ScanAltCuRi    : IF ((b*h<($FFF0-b)) OR GlobalXOR) THEN INC(b);
      ScanAltCuUp    : IF h>2 THEN DEC(h);
      ScanAltCuDo    : IF ((b*h<($FFF0-h)) OR GlobalXOR) THEN INC(h);
    END;
  UNTIL ScanCode IN [ScanCR, ScanBS, ScanESC];
END;                                                   { PROCEDURE RectTest }


PROCEDURE SpriteTest;   { Erlaubt Test von GetSprite, FillSprite, PutSprite }
BEGIN
  Title:=('SpriteTest');
  PutBackGnd;
  x:=200; y:=200; b:=300; h:=200;
  REPEAT
    IF GlobalXOR THEN SetXORMode
    ELSE BEGIN
      SetMOVMode;
      StartTimer;                                      { Starte Zeitmessung }
      GetSprite(x,y,b,h,SpriteSave);
      DispTimer (580,4);                      { Zeige Zeit fr GetSprite an }
      PutText (460,4,0,7,'GetSprite [s]:');
    END;
    StartTimer;                                        { Starte Zeitmessung }
    FillSprite(x,y,b,h,9);
    DispTimer (580,20);                      { Zeige Zeit fr FillSprite an }
    PutText (460,20,0,7,'FillSprite[s]:');
    ScanCode:=GetScanCode;                                { Warte auf Taste }
    IF ScanCode=ScanF3 THEN Mess;
    IF ScanCode=ScanF4 THEN Zoom;
    IF GlobalXOR THEN
    BEGIN                                             { Lsche das Sprite.. }
      SetXORMode;                                     { ..im XORMode..      }
      FillSprite(x,y,b,h,9);
    END
    ELSE BEGIN                         { ..oder restauriere es aus dem Mem. }
      StartTimer;                                      { Starte Zeitmessung }
      PutSprite(x,y,b,h,SpriteSave);
      DispTimer (580,36);                     { Zeige Zeit fr PutSprite an }
      PutText (460,36,0,7,'PutSprite [s]:');
    END;
    LookForCmd;                            { Hilfe, XOR, Modus, Bnke, x, y }
    CASE ScanCode OF                                      { Breite und Hhe }
      ScanAltCuLe    : IF b>2 THEN DEC(b);
      ScanAltCuRi    : IF ((b*h<($FFF0-b)) OR GlobalXOR) THEN INC(b);
      ScanAltCuUp    : IF h>2 THEN DEC(h);
      ScanAltCuDo    : IF ((b*h<($FFF0-h)) OR GlobalXOR) THEN INC(h);
    END;
  UNTIL ScanCode IN [ScanCR, ScanBS, ScanESC];
END;                                                 { PROCEDURE SpriteTest }


PROCEDURE Sprite2FileTest;               { Erlaubt den Test von Sprite2File }
VAR BufferPtr : POINTER;

BEGIN
  Title:=('Sprite2FileTest');
  PutBackGnd;
  x:=160; y:=120; b:=300; h:=200;
  BufferPtr:=@Buffer;
  REPEAT
    PutText (100,80,0,7,'Leertaste: Sprite im File ablegen');
    PutText (100,96,0,7,'Bel.Taste: Sprite zurcklesen');
    SetXORMode;
    PutRect (x-1,y-1,b+2,h+2,7);
    SetMOVMode;
    ScanCode:=GetScanCode;                                { Warte auf Taste }
    IF ScanCode=ScanF3 THEN Mess;
    IF ScanCode=ScanF4 THEN Zoom;
    SetXORMode;
    PutRect (x-1,y-1,b+2,h+2,7);
    SetMOVMode;
    LookForCmd;                            { Hilfe, XOR, Modus, Bnke, x, y }
    CASE ScanCode OF                                      { Breite und Hhe }
      ScanAltCuLe    : IF b>2 THEN DEC(b);
      ScanAltCuRi    : INC(b);
      ScanAltCuUp    : IF h>2 THEN DEC(h);
      ScanAltCuDo    : INC(h);
      ScanSpace      : BEGIN
                         PathName:='SPRITE.SCR'+Chr(0);
                         Sprite2File (x,y,b,h,Pathname,ErrCode,
                                      BufferPtr,SIZEOF (Buffer));
                         FillSprite (x,y,b,h,9);
                         Ch:=READKEY;
                         File2Sprite (x,y,b,h,Pathname,ErrCode,
                                      BufferPtr,SIZEOF (Buffer));
                         ASSIGN (f,PathName);
                         ERASE (f);
                       END;
    END;
  UNTIL ScanCode IN [ScanCR, ScanBS, ScanESC];
END;                                            { PROCEDURE Sprite2FileTest }


PROCEDURE Sprite2BmpTest;                 { Erlaubt den Test von Sprite2Bmp }
VAR BufferPtr : POINTER;

BEGIN
  Title:=('Sprite2BmpTest');
  PutBackGnd;
  x:=160; y:=120; b:=300; h:=200;
  BufferPtr:=@Buffer;
  REPEAT
    PutText (100,80,0,7,'Leertaste: Sprite im File ablegen');
    PutText (100,96,0,7,'Bel.Taste: Sprite zurcklesen');
    SetXORMode;
    PutRect (x-1,y-1,b+2,h+2,7);
    SetMOVMode;
    ScanCode:=GetScanCode;                                { Warte auf Taste }
    IF ScanCode=ScanF3 THEN Mess;
    IF ScanCode=ScanF4 THEN Zoom;
    SetXORMode;
    PutRect (x-1,y-1,b+2,h+2,7);
    SetMOVMode;
    LookForCmd;                            { Hilfe, XOR, Modus, Bnke, x, y }
    CASE ScanCode OF                                      { Breite und Hhe }
      ScanAltCuLe    : IF b>2 THEN DEC(b);
      ScanAltCuRi    : INC(b);
      ScanAltCuUp    : IF h>2 THEN DEC(h);
      ScanAltCuDo    : INC(h);
      ScanSpace      : BEGIN
                         PathName:='C:Sprite.BMP'+Chr(0);
                         Sprite2Bmp (x,y,b,h,Pathname,ErrCode,
                                      BufferPtr,SIZEOF (Buffer));
                         FillSprite (x,y,b,h,9);
                         Ch:=READKEY;
                         PathName:='C:Maus.BMP'+Chr(0);
                         Bmp2Sprite (x,y,b,h,Pathname,ErrCode,
                                      BufferPtr,SIZEOF (Buffer));
                         Ch:=READKEY;
                         PathName:='C:Sprite.BMP'+Chr(0);
                         Bmp2Sprite (x,y,b,h,Pathname,ErrCode,
                                      BufferPtr,SIZEOF (Buffer));
                       END;
    END;
  UNTIL ScanCode IN [ScanCR, ScanBS, ScanESC];
END;                                             { PROCEDURE Sprite2BmpTest }


PROCEDURE CircTest;                        { Erlaubt den Test von PutCircle }
BEGIN
  Title:=('CircTest');
  PutBackGnd;
  x:=200; y:=200; r:=50;
  REPEAT
    IF GlobalXOR THEN SetXORMode
    ELSE BEGIN
      SetMOVMode;
      GetSprite(x-r,y-r,2*r+1,2*r+1,SpriteSave);
    END;
    StartTimer;
    PutCircle (x,y,r,7);
    DispTimer (540,4);
    PutText (460,4,0,7,'Zeit [s]:');
    ScanCode:=GetScanCode;                                { Warte auf Taste }
    IF ScanCode=ScanF3 THEN Mess;
    IF ScanCode=ScanF4 THEN Zoom;
    IF GlobalXOR THEN
    BEGIN
      SetXORMode;
      PutCircle(x,y,r,7);
    END
    ELSE PutSprite(x-r,y-r,2*r+1,2*r+1,SpriteSave);
    LookForCmd;                            { Hilfe, XOR, Modus, Bnke, x, y }
    CASE ScanCode OF                                               { Radius }
      ScanAltCuUp : IF ((4*(r+1)*(r+1)<(63000)) OR (GlobalXOR)) THEN INC (r);
      ScanAltCuDo : IF r>2 THEN DEC(r);
    END;
  UNTIL ScanCode IN [ScanCR, ScanBS, ScanESC];
  HelpOn:=FALSE;
END;                                                   { PROCEDURE CircTest }


PROCEDURE DiskTest;                          { Erlaubt den Test von PutDisk }
BEGIN
  Title:=('DiskTest');
  PutBackGnd;
  x:=200; y:=200; r:=50;
  REPEAT
    IF GlobalXOR THEN SetXORMode
    ELSE BEGIN
      SetMOVMode;
      GetSprite(x-r,y-r,2*r+1,2*r+1,SpriteSave);
    END;
    StartTimer;
    PutDisk(x,y,r,9);
    DispTimer (540,4);
    PutText (460,4,0,7,'Zeit [s]:');
    ScanCode:=GetScanCode;                                { Warte auf Taste }
    IF ScanCode=ScanF3 THEN Mess;
    IF ScanCode=ScanF4 THEN Zoom;
    IF GlobalXOR THEN
    BEGIN
      SetXORMode;
      PutDisk(x,y,r,9);
    END
    ELSE PutSprite(x-r,y-r,2*r+1,2*r+1,SpriteSave);
    LookForCmd;                            { Hilfe, XOR, Modus, Bnke, x, y }
    CASE ScanCode OF                                               { Radius }
      ScanAltCuUp : IF ((4*(r+1)*(r+1)<(63000)) OR (GlobalXOR)) THEN INC (r);
      ScanAltCuDo : IF r>2 THEN DEC (r);
    END;
  UNTIL ScanCode IN [ScanCR, ScanBS, ScanESC];
END;                                                   { PROCEDURE DiskTest }


PROCEDURE PutTestText;
BEGIN
    PutText(x,y,0,15,'Einfach');
    PutText(x,y+16,1,15,'Doppelt hoch');
    PutText(x,y+48,2,15,'Doppelt hoch und breit');
END;

PROCEDURE PutCharTest;                       { Erlaubt den Test von PutChar }
BEGIN
  Title:=('PutCharTest');
  PutBackGnd;
  x:=200; y:=200; br:=400; ho:=80;
  REPEAT
    IF GlobalXOR THEN SetXORMode
    ELSE BEGIN
      SetMOVMode;
      GetSprite(x,y,br,ho,SpriteSave);   { Sichere den Hintergrund fr Text }
    END;
    StartTimer;
    PutTestText;                                        { Schreibe den Text }
    DispTimer (540,4);
    PutText (460,4,0,7,'Zeit [s]:');
    ScanCode:=GetScanCode;                                { Warte auf Taste }
    IF ScanCode=ScanF3 THEN Mess;
    IF ScanCode=ScanF4 THEN Zoom;
    IF GlobalXOR THEN                { Lsche Text durch erneutes Schreiben }
    BEGIN
      SetXORMode;
      PutTestText;
    END
    ELSE PutSprite(x,y,br,ho,SpriteSave);      { oder durch Rest. der Flche}
    LookForCmd;                                        { Verndere X oder Y }
  UNTIL ScanCode IN [ScanCR, ScanBS, ScanESC];
END;                                                { PROCEDURE PutCharTest }


PROCEDURE GetPixelTest;                     { Erlaubt den Test von GetPixel }
VAR U,V,Farbe:WORD;

BEGIN
  Title:=('GetPixelTest');
  PutBackGnd;
  X:=100; Y:=100; b:=100; h:=100;
  REPEAT
    GetSprite(x+200,y,b,h,SpriteSave);
    SetXORMode;
    PutRect(x-1,y-1,b+2,h+2,7);
    SetMOVMode;
    FOR U:=X TO X+b-1 DO
    BEGIN
      FOR V:=Y TO Y+h-1 DO
      BEGIN
        GetPixel (U,V,Farbe);
        IF GlobalXOR THEN SetXORMode;
        PutPixel (U+200,V,Farbe);
      END;
    END;
    ScanCode:=GetScanCode;                                { Warte auf Taste }
    IF ScanCode=ScanF3 THEN Mess;
    IF ScanCode=ScanF4 THEN Zoom;
    SetXORMode;
    PutRect(x-1,y-1,b+2,h+2,7);
    SetMOVMode;
    PutSprite(x+200,y,b,h,SpriteSave);               { Restore aus dem Mem. }
    LookForCmd;                            { Hilfe, XOR, Modus, Bnke, x, y }
  UNTIL ScanCode IN [ScanCR, ScanBS, ScanESC];
END;                                               { PROCEDURE GetPixelTest }


PROCEDURE ZoomTest;                       { Erlaubt den Test von ZoomSprite }
BEGIN
  Title:=('ZoomTest');
  PutBackGnd;
  x:=200; y:=200; b:=128; h:=128;
  REPEAT
    GetSprite(x,y,b,h,SpriteSave);               { Flche in den SpriteSave }
    SetXORMode; PutRect (x-1,y-1,b+2,h+2,7);            { Zeichne Umrandung }
    StartTimer;
    ZoomSprite(x,y,b,h,SpriteSave);       { Zoome vom SpriteSave zum Screen }
    DispTimer (540,4);
    PutText (460,4,0,7,'Zeit [s]:');
    ScanCode:=GetScanCode;                                { Warte auf Taste }
    IF ScanCode=ScanF3 THEN Mess;
    IF ScanCode=ScanF4 THEN Zoom;
    PutSprite(x,y,b,h,SpriteSave);                { Restauriere Hintergrund }
    SetXORMode; PutRect (x-1,y-1,b+2,h+2,7);             { Lsche Umrandung }
    LookForCmd;                            { Hilfe, XOR, Modus, Bnke, x, y }
    CASE ScanCode OF                                     { Breite oder Hhe }
      ScanAltCuLe    : IF b>4 THEN b:=b-2;
      ScanAltCuRi    : IF b*h<(63000-2*b) THEN b:=b+2;
      ScanAltCuUp    : IF h>2 THEN DEC(h);
      ScanAltCuDo    : IF b*h<(63000-h) THEN INC(h);
    END;
  UNTIL ScanCode IN [ScanCR, ScanBS, ScanESC];
END;                                                   { PROCEDURE ZoomTest }


PROCEDURE VirtScreenTest;        { Erlaubt den Test von SetScreenOffs und.. }
BEGIN                                               { ..SetBytesPerScanLine }
  Virt:=TRUE;
  XmaxVirt:=(3*(Xmax+1) DIV 2)-1;
  YmaxVirt:=(LONGINT (1024*LONGINT(MemSize)) DIV (XmaxVirt+1)-1);
  Xfaecher:=XmaxVirt+1; Yfaecher:=YmaxVirt+1;
  SetBytesPerScanline (XmaxVirt+1);
  Xoffs:=0; Yoffs:=0;
  SetScreenOffs (Xoffs,Yoffs);
  Title:=('VirtScreenTest');
  PutBackGnd;
  REPEAT
    PutText (100,80,0,7,'     Pos1-> obere linke Ecke');
    PutText (100,96,0,7,'     Ende-> untere rechte Ecke');
    PutText (100,112,0,7,'Bild auf-> Virtscreen breiter');
    PutText (100,128,0,7,'Bild ab -> Virtscreen schmaler');
    ScanCode:=GetScanCode;                                { Warte auf Taste }
    CASE ScanCode OF
      ScanF1         : PutHelp;
      ScanF4         : Zoom;
      ScanF5         : SetMode(640,400);
      ScanF6         : SetMode(640,480);
      ScanF7         : SetMode(800,600);
      ScanF8         : SetMode(1024,768);
      ScanF9         : SetMode(1152,864);
      ScanF10        : SetMode(1280,1024);
      ScanCuUp       : IF Yoffs>7 THEN DEC(Yoffs,8);
      ScanCuDo       : IF (Ymax+Yoffs)<YmaxVirt-7 THEN INC(Yoffs,8);
      ScanCuRi       : IF (Xmax+Xoffs)<XmaxVirt-7 THEN INC(Xoffs,8);
      ScanCuLe       : IF Xoffs>7 THEN DEC(Xoffs,8);
      ScanCtrlCuUp   : IF Yoffs>0 THEN DEC(Yoffs);
      ScanCtrlCuDo   : IF (Ymax+Yoffs)<YmaxVirt THEN INC(Yoffs);
      ScanCtrlCuRi   : IF (Xmax+Xoffs)<XmaxVirt THEN INC(Xoffs);
      ScanCtrlCuLe   : IF Xoffs>0 THEN DEC(Xoffs);
      ScanCuHo       : BEGIN Xoffs:=0; Yoffs:=0  END;
      ScanCuEnd      : BEGIN Xoffs:=XmaxVirt-Xmax; Yoffs:=YmaxVirt-Ymax; END;
      ScanB          : ShowBanks;
      ScanPageDo     : BEGIN
                         DEC (XmaxVirt,8);
                         Xoffs:=0; Yoffs:=0;
                         YmaxVirt:=(LONGINT (1024*LONGINT(MemSize)) DIV (XmaxVirt+1)-1);
                         Xfaecher:=XmaxVirt+1;
                         Yfaecher:=YmaxVirt+1;
                         SetBytesPerScanline (XmaxVirt+1);
                         PutBackGnd;
                       END;
      ScanPageUp     : BEGIN
                         INC (XmaxVirt,8);
                         Xoffs:=0; Yoffs:=0;
                         YmaxVirt:=(LONGINT (1024*LONGINT(MemSize)) DIV (XmaxVirt+1)-1);
                         Xfaecher:=XmaxVirt+1;
                         Yfaecher:=YmaxVirt+1;
                         SetBytesPerScanline (XmaxVirt+1);
                         PutBackGnd;
                       END;
    END;
    SetScreenOffs (Xoffs,Yoffs);
  UNTIL ScanCode IN [ScanCR, ScanBS, ScanESC];
  SetScreenOffs (0,0);
  SetBytesPerScanLine (Xmax+1);
  Xfaecher:=Xmax+1; YFaecher:=Ymax+1;
  Virt:=FALSE;
END;                                             { PROCEDURE VirtScreenTest }


PROCEDURE WriteTest; { Mit die Zeit, um 1000 Byte zum Video-Mem zu bringen }
CONST  ByteZahl=1000;
       X=100; Y=120;
BEGIN
  ClearVGAMem;
  Title:=('1000 Byte zum Video-Mem');
  PutBackGnd;
  REPEAT
    PutText (X,Y+8,0,7,'Zugriff   Addr mod 4   Zeit[s]');

    PutText (X,Y+32,0,7,'  BYTE        0');
    PutPixel (0,0,0);
    ASM  CLD; MOV AX,$A000; MOV ES,AX; END;
    StartTimer;
    ASM
      MOV   DI,0;  MOV   CX,ByteZahl
      MOV   AL,$55
      REP   STOSB
    END;
    DispTimer (X+200,Y+32);

    PutText (X,Y+48,0,7,'  BYTE        1');
    PutPixel (0,0,0);
    ASM  CLD; MOV AX,$A000; MOV ES,AX; END;
    StartTimer;
    ASM
      MOV   DI,1;  MOV   CX,ByteZahl
      MOV   AL,$55
      REP   STOSB
    END;
    DispTimer (X+200,Y+48);

    PutText (X,Y+64,0,7,'  WORD        0');
    PutPixel (0,0,0);
    ASM  CLD; MOV AX,$A000; MOV ES,AX; END;
    StartTimer;
    ASM
      MOV   DI,0;  MOV   CX,ByteZahl/2
      MOV   AX,$2525
      REP   STOSW
    END;
    DispTimer (X+200,Y+64);

    PutText (X,Y+80,0,7,'  WORD        1');
    PutPixel (0,0,0);
    ASM  CLD; MOV AX,$A000; MOV ES,AX; END;
    StartTimer;
    ASM
      MOV   DI,1;  MOV   CX,ByteZahl/2
      MOV   AX,$2525
      REP   STOSW
    END;
    DispTimer (X+200,Y+80);

    PutText (X,Y+96,0,7,'  DWORD       0');
    PutPixel (0,0,0);
    ASM  CLD; MOV AX,$A000; MOV ES,AX; END;
    StartTimer;
    ASM
      MOV   DI,0;   MOV   CX,ByteZahl/4
      DB    $66,$B8,$55,$55,$55,$55  { MOV EAX,$55555555 }
      DB    $F3,$66,$AB              { REP STOSD         }
    END;
    DispTimer (X+200,Y+96);

    PutText (X,Y+112,0,7,'  DWORD       1');
    PutPixel (0,0,0);
    ASM  CLD; MOV AX,$A000; MOV ES,AX; END;
    StartTimer;
    ASM
      MOV   DI,1;  MOV   CX,ByteZahl/4
      DB    $66,$B8,$55,$55,$55,$55  { MOV EAX,$55555555 }
      DB    $F3,$66,$AB              { REP STOSD         }
    END;
    DispTimer (X+200,Y+112);

    PutText (X,Y+128,0,7,'  DWORD       2');
    PutPixel (0,0,0);
    ASM  CLD; MOV AX,$A000; MOV ES,AX; END;
    StartTimer;
    ASM
      MOV   DI,2;   MOV   CX,ByteZahl/4
      DB    $66,$B8,$55,$55,$55,$55  { MOV EAX,$55555555 }
      DB    $F3,$66,$AB              { REP STOSD         }
    END;
    DispTimer (X+200,Y+128);

    PutText (X,Y+144,0,7,'  DWORD       3');
    PutPixel (0,0,0);
    ASM  CLD; MOV AX,$A000; MOV ES,AX; END;
    StartTimer;
    ASM  MOV   DI,3
         MOV   CX,ByteZahl/4
         DB    $66,$B8,$55,$55,$55,$55  { MOV EAX,$55555555 }
         DB    $F3,$66,$AB              { REP STOSD         }
    END;
    DispTimer (X+200,Y+144);
    ScanCode:=GetScanCode;                                { Warte auf Taste }
    LookForCmd;
  UNTIL ScanCode IN [ScanCR, ScanBS, ScanESC];
END;                                                  { PROCEDURE WriteTest }


PROCEDURE GetSetBankTest; { Mit die Zeit fr das Lesen und Setzen der Bank }
BEGIN
  ClearVGAMem;
  Title:=('Get/Set-Bank');
  PutBackGnd;
  REPEAT
    StartTimer;
    ASM
      MOV  AX,$4F05
      MOV  BH,1      { Bank-Position lesen }
      MOV  BL,0
      INT  $10
    END;
    DispTimer (336,128);
    PutText (120,128,0,7,'Bank-Position lesen  [s]:');

    StartTimer;
    ASM
      MOV  AX,$4F05
      MOV  BH,1      { Bank-Position setzen }
      MOV  BL,0
      INT  $10
    END;

    DispTimer (336,144);
    PutText (120,144,0,7,'Bank-Position setzen [s]:');

    ScanCode:=GetScanCode;                                { Warte auf Taste }
    LookForCmd;
  UNTIL ScanCode IN [ScanCR, ScanBS, ScanESC];
END;                                             { PROCEDURE GetSetBankTest }


PROCEDURE SwitchDemo;       { Schaltet zwischen zwei Bildschirmspeichern um }

{ Beispiel fr die Verwendung von zwei Bildschirmspeichern zur flackerfreien
  Darstellung von bewegten Objekten.

  Will man den Bildschirminhalt ohne Flackern verndern, so kann man dafr
  die Zeit des Strahlrcklaufes verwenden. Diese Zeit betrgt ca. 20% der
  Vertikalperiode und schliet sich an die ansteigende Flanke des Vertikal-
  synchronimpulses an. WaitForSync kommt zu diesem Zeitpunkt zurck.

  Wenn diese Zeit zur Vernderung nicht ausreicht, kann man durch Umschalten
  zwischen zwei Bildschirmspeichern eine ganze Vertikalperiode gewinnen.
  Whrend man den Inhalt des einen Speichers anzeigt, kann man den anderen
  neu aufbauen.

  Das folgende Beispiel bewegt eine Disk ber einen gemusterten Hintergrund.
  Der maximal mgliche Radius R der Disk ist bei gegebener Hardware (Rechner
  und Grafikkarte) ein Mastab fr die Leistungsfhigkeit von GetSprite,
  FillSprite und PutSprite. Ziel der Bemhungen ist es, fr jede
  Vertikalablenkung einen neuen Bildinhalt parat zu haben. Nur dann erhlt
  man eine klare Bewegung der Disk im ganzen Bildschirmbereich.
  Ein Pentium 90 + ET4000 W32 schafft R=70. Fr grere R werden
  dann zwei Vertikalperioden bentigt und das Bild ruckelt.

  Leider reagieren die VBEs unterschiedlich auf SetScreenOffs.
  Deshalb gibt es zwei Versionen fr DiskJump: Eine fr den ET4000 und
  eine fr S3-Chips. Die ET4000-Version bentigt zum Umschalten zwischen
  zwei Bildschirmen kein WaitForSync und zeigt gegenphasiges Verhalten.
  Mit UNIVBE51 erhlt man fr die ET4000-Chips noch andere Ergebnisse. }


VAR R, X0, Y0, X1, Y1, Dx, Dy, D2y :WORD;


PROCEDURE DiskJump (ET4000 :BOOLEAN);            { Bewegt eine Kreisscheibe }
BEGIN
  ClearVGAMem;
  Dx:=10 ; Dy:=2;                    { Geschwindigkeit in X- und Y-Richtung }
  D2y:=1;                                    { Beschleunigung in Y-Richtung }
  X1:=200; Y1:=112;                        { Koordinaten fr Disk in Bild 1 }
  X0:=200+Dx DIV 2; Y0:=Y1+Dy DIV 2;       { Koordinaten fr Disk in Bild 0 }
  R:=50;

  PutGitter(Ymax+1);                               { Hintergrund fr Bild 1 }
  PutText (10,Ymax+1+10,2,7,'   Zwei Bildschirmspeicher');
  GetSprite (X1,Y1+Ymax+1,2*R+1,2*R+1,SpriteSave1);{ Rette Flche fr Disk 1 }

  PutGitter(0);                                    { Hintergrund fr Bild 0 }
  IF ET4000 THEN
    PutText (10,10,2,7,'   Zwei Bildschirmspeicher (ET4000)')
  ELSE
    PutText (10,10,2,7,'   Zwei Bildschirmspeicher (S3)');
  GetSprite (X0,Y0,2*R+1,2*R+1,SpriteSave);       { Rette Flche fr Disk 0 }
  PutDisk (X0+R,Y0+R,R,9);                                 { Zeichne Disk 0 }

  REPEAT
    IF ET4000 THEN SetScreenOffs (0,Ymax+1)               { Zeige Bild 0 an }
              ELSE BEGIN
                SetScreenOffs (0,0);
                WaitForSync;
              END;

    PutSprite (X1,Y1+Ymax+1,2*R+1,2*R+1,SpriteSave1); { Rest. Flche Disk 1 }

    X1:=X1+Dx;                     { Berechne neue X-Koordinaten fr Disk 1 }
    IF X1>Xmax-2*R THEN
    BEGIN
      X1:=X1-Dx;
      Dx:=-Dx;
    END;

    Y1:=Y1+Dy;                     { Berechne neue Y-Koordinaten fr Disk 1 }
    IF Y1>Ymax-2*R THEN
    BEGIN
      Y1:=Y1-Dy;
      Dy:=-Dy;
    END;
    Dy:=Dy+D2y;

    GetSprite(X1,Y1+Ymax+1,2*R+1,2*R+1,SpriteSave1);  { Rette Flche Disk 1 }
    PutDisk (X1+R,Y1+R+Ymax+1,R,9);                        { Zeichne Disk 1 }

    IF ET4000 THEN SetScreenOffs (0,0)                    { Zeige Bild 1 an }
              ELSE BEGIN
                SetScreenOffs (0,Ymax+1);                             
                WaitForSync;
              END;

    PutSprite (X0,Y0,2*R+1,2*R+1,SpriteSave);   { Restauriere Flche Disk 0 }

    X0:=X0+Dx;                     { Berechne neue X-Koordinaten fr Disk 0 }
    IF X0>Xmax-2*R THEN
    BEGIN
      X0:=X0-Dx;
      Dx:=-Dx;
    END;

    Y0:=Y0+Dy;                     { Berechne neue Y-Koordinaten fr Disk 0 }
    IF Y0>Ymax-2*R THEN
    BEGIN
      Y0:=Y0-Dy;
      Dy:=-Dy;
    END;
    Dy:=Dy+D2y;

    GetSprite (X0,Y0,2*R+1,2*R+1,SpriteSave);     { Rette Flche fr Disk 0 }
    PutDisk (X0+R,Y0+R,R,9);                               { Zeichne Disk 0 }

  UNTIL KEYPRESSED;
  Ch:=ReadKey;
  SetScreenOffs (0,0);                                    { Zeige Bild 0 an }
END;                                                


BEGIN
  DiskJump (TRUE);                  { fr ET4000 }
  DiskJump (FALSE);                 { fr andere Chips, z.B. S3 }
  ScanCode:=Getscancode;
END;                                                { PROCEDURE SwitchDemo }


BEGIN                                                       { Hauptprogramm }
  SetAlfaMode;
  WriteInfo;
  IF VESAAvail
    THEN DispVESAInfoBlock
    ELSE BEGIN
           WRITELN ('Kein VESA-Bios vorhanden.');
           Ch:=READKEY;
           EXIT;
         END;
  Ch:=READKEY;

  SetVESAMode (800,600,VESAErr);                      { Beginne mit 800*600 }
  IF VESAErr<>0 THEN
  BEGIN
  SetAlfaMode;
    CASE VESAErr OF
       1 : WRITELN ('Modus wird nicht vom VESA-BIOS untersttzt');
       2 : WRITELN ('ModeInfoBlock konnte nicht gefllt werden');
       3 : WRITELN ('Einschalten des Modus fehlgeschlagen');
    END;
    Ch:=READKEY;
    EXIT;
  END;

  GETMEM (SpriteSave,$FFF0);          { Flche zum Retten des Hintergrundes }
  GETMEM (SpriteSave1,$FFF0);         { Flche zum Retten des Hintergrundes }

  HelpOn:=FALSE; GlobalXOR:=FALSE; Virt:=FALSE;

  XmaxVirt:=1200;
  YmaxVirt:=(LONGINT (1024*LONGINT (MemSize)) DIV (XmaxVirt+1)-1);

  Xfaecher:=800; YFaecher:=600;
  Xmax:=799; Ymax:=599;

  X0mess:=200; Y0mess:=200; { Koordinaten des Memoduls }
  X1mess:=360; Y1mess:=400;

  i:=1;
  REPEAT
    CASE i OF
      1 : LineVTest;
      2 : LineHTest;
      3 : LineTest;
      4 : RectTest;
      5 : SpriteTest;
      6 : ZoomTest;
      7 : Sprite2FileTest;
      8 : Sprite2BmpTest;
      9 : CircTest;
     10 : DiskTest;
     11 : PutCharTest;
     12 : GetPixelTest;
     13 : VirtScreenTest;
     14 : WriteTest;
     15 : GetSetBankTest;
     16 : SwitchDemo;
    END;
    IF ScanCode=ScanCR THEN
    BEGIN
      INC (i);
      IF i=17 THEN i:=1;
    END;
    IF ScanCode=ScanBS THEN
    BEGIN
      DEC (i);
      IF i=0 THEN i:=16;
    END;
  UNTIL ScanCode=ScanESC;
  SetAlfaMode;
END.
