
// _________________________________________________________________
//
//                            Trivial2.c           
//                 Triviale Windows-Anwendung Nr. 2
//                 c't magazin fuer computertechnik
//                   12.09.1996 Sven B. Schreiber
// _________________________________________________________________

#include <windows.h>
#include "GuiStart.h"

// =================================================================
// GLOBALE VARIABLEN
// =================================================================

char      sMainClass   [] = "Trivial2";
char      sMainCaption [] = "Triviale Win32-Anwendung Nr. 2";
HINSTANCE hInst;
PSTR      psCmdLine;
HWND      hWndMain;

// =================================================================
// HAUPTFENSTER
// =================================================================

LRESULT CALLBACK MainWndProc (HWND   hWnd,
                              UINT   uMsg,
                              WPARAM wParam,
                              LPARAM lParam)
    {
    PAINTSTRUCT PaintStruct;
    RECT        Rect;
    WNDCLASS    WndClass;

    switch (uMsg)
        {
        case WM_PAINT:

            if (GetUpdateRect (hWnd, NULL, FALSE))
                {
                BeginPaint (hWnd, &PaintStruct);

                SelectObject (PaintStruct.hdc,
                              GetStockObject (SYSTEM_FIXED_FONT));

                GetClientRect (hWnd, &Rect);
                SetBkMode (PaintStruct.hdc, TRANSPARENT);
                DrawText (PaintStruct.hdc,
                          "Hello World!",
                          -1,
                          &Rect,
                          DT_SINGLELINE | DT_CENTER | DT_VCENTER);

                EndPaint (hWnd, &PaintStruct);
                }
            return (LRESULT) NULL;

        case WM_DESTROY:

            GetClassInfo (hInst, sMainClass, &WndClass);
            if (WndClass.hbrBackground != NULL)
                {
                DeleteObject (WndClass.hbrBackground);
                }
            PostQuitMessage (0);
            return (LRESULT) NULL;
        }
    return DefWindowProc (hWnd, uMsg, wParam, lParam);
    }

// =================================================================
// HAUPTPROGRAMM
// =================================================================

HWND CreateMainWindow (HINSTANCE hInstance,
                       PWNDCLASS pWndClass)
    {
    HWND hWndMain = NULL;

    pWndClass->style         = CS_HREDRAW | CS_VREDRAW;
    pWndClass->lpfnWndProc   = MainWndProc;
    pWndClass->cbClsExtra    = 0;
    pWndClass->cbWndExtra    = 0;
    pWndClass->hInstance     = hInstance;
    pWndClass->hIcon         = LoadIcon (NULL, IDI_APPLICATION);
    pWndClass->hCursor       = LoadCursor (NULL, IDC_ARROW);
    pWndClass->lpszMenuName  = NULL;
    pWndClass->lpszClassName = sMainClass;
    pWndClass->hbrBackground = CreateSolidBrush
                                   (GetSysColor (COLOR_WINDOW));

    if (RegisterClass (pWndClass))
        {
        hWndMain = CreateWindow (sMainClass,
                                 sMainCaption,
                                 WS_OVERLAPPEDWINDOW,
                                 CW_USEDEFAULT,
                                 CW_USEDEFAULT,
                                 CW_USEDEFAULT,
                                 CW_USEDEFAULT,
                                 NULL,
                                 NULL,
                                 hInstance,
                                 NULL);
        }    
    return hWndMain;
    }

// -----------------------------------------------------------------

BOOL InitInstance (HINSTANCE hInstance,
                   int       iCmdShow,
                   PWNDCLASS pWndClass)
    {
    hWndMain = CreateMainWindow (hInstance, pWndClass);

    if (hWndMain != NULL)
        {
        ShowWindow   (hWndMain, iCmdShow);
        UpdateWindow (hWndMain);
        }
    return hWndMain != NULL;
    }

// -----------------------------------------------------------------

int WINAPI WinMain (HINSTANCE hInstance,
                    HINSTANCE hPrevInstance,
                    LPSTR     lpCmdLine,
                    int       nShowCmd)
    {
    WNDCLASS WndClass;
    MSG      Msg;

    hInst      = hInstance;
    psCmdLine  = lpCmdLine;
    Msg.wParam = 0;

    if (InitInstance (hInstance, nShowCmd, &WndClass))
        {
        while (GetMessage (&Msg, NULL, 0, 0))
            {
            TranslateMessage (&Msg);
            DispatchMessage (&Msg);
            }
        }
    return Msg.wParam;
    }

// =================================================================
// PROGRAMMENDE
// =================================================================
