{
  DPMI ( DOS Protected Mode Interface ) -

  Funktionen zur Untersttzung der Ansteuerung von VESA kompatiblen
  Grafikkarten im Protected Mode.

  (c) Ansgar Scherp, Joachim Gelhaus 1996-1997

}

{$IFNDEF DPMI}Nur im Protected Mode lauffhig...{$ENDIF}

unit DPMI;

interface

uses Winapi;

type
  TRealModeRegs = { ein "Satz" Real Mode Register }
    record
      case Integer of
        0 : ( edi, esi, ebp, exx, ebx, edx, ecx, eax : longint;
             flags, es, ds, fs, gs, ip, cs, sp, ss  : Word );
        1 : ( di, dih, si, sih, bp, bph, xx, xxh : word;
              case Integer of
                0 : ( bx, bxh, dx, dxh, cx, cxh, ax, axh : word );
                1 : ( bl, bh, blh, bhh, dl, dh, dlh, dhh,
                      cl, ch, clh, chh, al, ah, alh, ahh : byte ) );
    end ;

  TLowMemoryBlock =
    Record
      ProtModePtr : Pointer; { Zeiger und Selektor auf Speicherbereich  }
      ProtModeSel : Word;    { unterhalb von 1MB. Jeweils fr Real und  }
      RealModePtr : Pointer; { Protected Mode.                          }
      RealModeSeg : Word ;   { Offset ist stets Null.                   }
      BlockSize   : Word ;   { Groesse des allozierten Bereichs.        }
     End ;

  TDWord = { DWord = LowWord : HiWord }
    record
      LowWord, HiWord : word ;
    end ;

var
  SimRealModeIntErrorCode : word; { Fehlercode des letzten RM Interrupts }

{ Simulierung eines Real Mode Interrupts im Protected Mode; RealRegs ist
  dabei ein Satz von Real Mode Registern und IntNo die Interruptnummer.
  Die Funktion liefert false zurck, falls die Simulation fehl geschlagen
  hat, sonst true. }
function SimRealModeInt( IntNo : byte ;
                         var RealRegs : TRealModeRegs ) : boolean;

{ allozieren von LowMemory, d.h. Speicher unterhalb des ersten MB des
  Hauptspeichers. Dieser Speicher ist von Real also auch Protected Mode
  ansprechbar }
procedure AllocateLowMem( var LowMem : TLowMemoryBlock ; size : word );
{ Freigeben einen LowMemoryBlocks }
procedure FreeLowMem( LowMem : TLowMemoryBlock );

implementation

function SimRealModeInt( IntNo : Byte ;
                         var RealRegs : TRealModeRegs) : boolean;
assembler ;
asm
  mov  ax, $0300 { simuliere Real Mode Interrupt }
  mov  bl, IntNo
  xor  bh, bh    { bh = cx = 0 }
  xor  cx, cx
  les  di, RealRegs { die Real Mode Register }
  int  $31
  jnc  @ok { testen, ob simulierte Real Mode Interrupt korrekt ausgefhrt }
    { Real Mode konnte nicht korrekt ausgefhrt werden; Fehlercode in
      Fehlervariable schreiben }
    mov SimRealModeIntErrorCode, ax
    mov ax, false
  @ok:
  mov ax, true { Real Mode Interrupt konnte korrekt ausgefhrt werden }
End ;

procedure AllocateLowMem( var LowMem : TLowMemoryBlock ; size : word );
var
  adr : longint;
begin
  adr := GlobalDOSAlloc( size ); { alloziert Speicher unterhalb des 1 MB }
  if adr = 0 then
    size := 0 ;    { falls kein Speicher mehr frei }
  LowMem.ProtModePtr := ptr( TDWord( Adr ).LowWord, 0 );
  LowMem.ProtModeSel := TDWord( Adr ).LowWord;
  LowMem.RealModePtr := ptr( TDWord( Adr ).HiWord, 0 );
  LowMem.RealModeSeg := TDWord( Adr ).HiWord ;
  LowMem.BlockSize   := size ;
end;

procedure FreeLowMem( LowMem : TLowMemoryBlock );
begin
  { reservierter Speicher unterhal des ersten MB wieder freigeben }
  GlobalDOSFree( seg( LowMem.ProtModePtr^ ) );
end ;

end.