{
  VIDEO100.PAS - der Aufsatz auf VIDEO13H.PAS fr Mode 100h

  Borland Pascal 7.0

  Version 2.0

  Ansgar Scherp   ( Ansgar.Scherp@Informatik.Uni-Oldenburg.DE )
  Joachim Gelhaus ( J.Gelhaus@Flight.Gun.DE )

  Diese Routinen sind NUR im Protected Mode lauffhig.

  (c) Ansgar Scherp, Joachim Gelhaus 1996-1997

}

{$IFNDEF DPMI}Nur im Protected Mode lauffhig...{$ENDIF}

unit VIDEO100;

interface

uses VIDEO13;

type { der neue Datentyp fr die virtuellen Bildschirmseiten im Modus 100h }
  TPage100h = array[0..3] of pointer;

const
  Mode100h : word = $100; { der Bildschirmmodus 640x400x256 }

{ Funktionalitten der Prozeduren und Funktionen nahezu analog
  zu Video13.PAS }

{ Initialisieren des VideoModus 100h }
procedure InitVideo100h;

{ festlegen der aktuellen virtuellen Seite; im Gegensatz zu den Video13h-
  Routinen ist es im Modus 100h jedoch AUSSCHLIESSLICH mglich in virtuellen
  Seiten direkt zu schreiben }
procedure ActivePage100h( var page : TPage100h );

{ setzten eines Videomodus }
procedure SetVideoMode100h( mode : word );

{ setzen des Fensterrahmens im Modus 640x400x256 }
procedure SetWindow100h( x1, y1, x2, y2 : longint );

{ kopieren einer virtuellen Seite in eine andere virtuellen Seite; SrcPage
  und DstPage sind Datentypen vom Typ TPage100h und MSSEN eine virtuelle
  Seite sein }
procedure CopyP2P100h( var DstPage, SrcPage : TPage100h);
{ kopieren einer virtuellen Bildschirmseite auf in den visuellenn, d.h.
  sichtbaren Grafikspeicher }
procedure CopyP2V100h( var page : TPage100h);

{ lschen einer virtuellen Seite }
procedure ClearPage100h( page : TPage100h);
{ lschen der visuellen Seite }
procedure ClearVisualPage100h;

{ initialisieren einer virtuellen Bildschirmseite fr den Modus 100h }
procedure InitPage100h( var page : TPage100h);
{ schliessen einer virtuellen Bildschirmseite des Modus 100h }
procedure ClosePage100h( var page : TPage100h);

{ PutSprite-Routine fr 640x400x256 }
procedure PutSprite100h( x, y : integer; sprite : TSprite );
{ GetSprite-Routine fr 640x400x256 }
procedure GetSprite100h( x, y : integer; sprite : TSprite );

{ Standard Put-/GetPixel-Routinen  }
procedure PutPixel100h( x, y : longint; c : byte );
function  GetPixel100h( x, y : longint ) : byte;

implementation

uses DPMI;

type
  Modes   = array[0..255] of word;
  PModes  = ^Modes;
  ASCII   = array[0..255] of char;
  PASCII  = ^PASCII;

  TVESAInfo = { allgemeine VESA-Informationen }
     record
       signature    : array[ 0 .. 3 ] of char; { VESA-Signatur: "VESA" }
       version      : array[ 0 .. 1 ] of byte; { Versionsnummer }
       OEMName      : PASCII;                  { Herstellername }
       capabilities : array[ 0 .. 3 ] of byte;
       vmodes       : PModes;
       reserved     : array[ 0 .. 237 ] of byte;
     end;

  TModeInfo = { diverse Infos zu den Videomodus }
    record
      attributes       : word;
      winA             : byte;
      winB             : byte;
      granularity      : word;
      size             : word;
      segA             : word;
      segB             : word;
      eqv4f05          : longint;
      bytesperscanline : word;
      width            : word;
      height           : word;
      characterwidth   : byte;
      characterheight  : byte;
      planes           : byte;
      bitsperpixel     : byte;
      banks            : byte;
      memorymodel      : byte;
      sizeofbank       : byte;
      res              : array[ 0 .. 256 - $1E ] of byte;
    end;

var
  ActVPage100h   : TPage100h; { aktive virtuelle Seite; Seite auf die sich
                                alle folgenden Operationen beziehen }
  RealRegs       : TRealModeRegs; { ein 'Satz' RealMode-Register }
  LowMemoryBlock : TLowMemoryBlock; { Speicherblock unterhalb des ersten MB }
  VesaInfo       : TVesaInfo;       { allgemeine VESA-Informationen }
  ModeInfo       : TModeInfo;       { Informationen zum Modus 100h }
  Granny         : byte;            { untersttzte Granularitt }
  BankNr         : byte;            { BankNr der Grafikkarte }

const { die Fensterrahmen fr die 4 'kleinen' Blcke in Mode 100h }
  Windows100h : array[ 0..3 { Block 0 bis 3 } , 1..4 ] of integer = (
                  (0,319,0,199), (0,319,0,199), (0,319,0,199),
                  (0,319,0,199) );

var   { der Fensterrahmen des SVGA-Modus }
  GlobalWindowX1, GlobalWindowX2,
  GlobalWindowY1, GlobalWindowY2 : longint;


procedure SetVideoMode100h( mode : word );
begin
  RealRegs.ax := $4f02; { set video mode }
  RealRegs.bx := mode;
  if SimRealModeInt($10,RealRegs)=false then
  begin { falls ein Fehler aufgetreten ist }
    writeln( 'GetSimRealModeIntFehler: ', SimRealModeIntErrorCode );
    halt(1);
  end;
end;

{ gibt zu einem absoluten x-Wert des 640x400 Bildschirms den relativen
  x-Wert der dazugehrdenen 320x200 Seite bzw. Block }
function CalcPageX( x : integer; bank : word ) : integer;
begin
  asm
    cmp bank, 0; je @ende
    cmp bank, 2; je @ende
    sub x, 320 { Block 1,3,5 }
    @ende:
  end;
  CalcPageX := x;
end;

{ gibt zu einem absoluten y-Wert des 640x400 Bildschirms den relativen
  y-Wert der dazugehrdenen 320x200 Seite bzw. Block }
function CalcPageY( y : integer; bank : word) : integer;
begin
  asm
    cmp bank, 2
    jb @ende
      sub y, 200 { Block 2, 3 }
    @ende:
  end;
  CalcPageY := y
end;

{ arbeitet wie CalcPageX/Y, erwartet jedoch als Argument sowohl X als
  auch Y Koordinate }
function GetPage( x, y : integer ) : word;
var
  SubPage : byte;
begin
  if x <= 319 then
      SubPage := 0
    else
      SubPage := 1;
  if y >= 200 then
    inc(SubPage,2);
  GetPage := SubPage;
end;

procedure SetWindow100h( x1, y1, x2, y2 : longint );
var
  h     : longint;
  block : byte;
  rx1, rx2, ry1, ry2 : integer;
begin
  { wenn der Fensterrahmen ausserhalb des gltigen Bereiches liegt, dann
    begrenzen }
  if x1 < 0 then x1 := 0; if x1 > 639 then x1 := 639;
  if y1 < 0 then y1 := 0; if y1 > 479 then y1 := 479;
  { vertauschen der Grenzen links/rechts bzw. oben/unten falls ntig }
  if x1 > x2 then begin h := x2; x2 := x1; x1 := h; end;
  if y1 > y2 then begin h := y2; y2 := y1; y1 := h; end;
  { nun von Block 0 bis 5 den Fensterrahmen berechnen und festlegen }

  GlobalWindowX1 := x1;
  GlobalWindowX2 := x2;
  GlobalWindowY1 := y1;
  GlobalWindowY2 := y2;

  for block := 0 to 3 do
    begin
      rx1 := CalcPageX( x1, block ); ry1 := CalcPageY( y1, block );
      rx2 := CalcPageX( x2, block ); ry2 := CalcPageY( y2, block );
      SetWindow( rx1, ry1, rx2, ry2 ); { Rahmen des Blocks setzen }
      if ( WindowX1 = WindowX2 ) or ( WindowY1 = WindowY2 ) then
        begin { falls Breite oder Tiefe des Rahmens gleich Null ist }
          WindowX1 := 0; WindowX2 := 0; WindowY1 := 0; WindowY2 := 0;
        end;
    { den Rahmen jedes Blocks fr die anderen Routinen 'merken' }
    Windows100h[ block, 1 ] := WindowX1; Windows100h[ block, 2 ] := WindowX2;
    Windows100h[ block, 3 ] := WindowY1; Windows100h[ block, 4 ] := WindowY2;
  end;
end;

procedure SetBank( bank : byte );
begin
  RealRegs.ax := $4f05; RealRegs.bx := $0000; { set bank }
  RealRegs.dx := bank * granny;
  if SimRealModeInt( $10, RealRegs ) = false then
    begin { falls ein Fehler aufgetreten ist }
      writeln( 'GetSimRealModeIntFehler: ', SimRealModeIntErrorCode );
      halt(1);
    end;
end;

procedure GetVESAInfo;
var
  x : word;
begin
  { allozieren von 300 Byte Speicher, der unterhalb des ersten MB liegt,
    d.h. er ist sowohl im Real Mode als auch im Protected Mode ansprechbar }
  AllocateLowMem( LowMemoryBlock ,300 );
  { zunchst mit Dummynullen fllen }
  FillChar( RealRegs, SizeOf( RealRegs ), 0 );
  { Real Mode Segment auf den LowMemoryBlock }
  RealRegs.es := LowMemoryBlock.RealModeSeg;
  RealRegs.ax := $4f00; { get VESA info }
  if SimRealModeInt( $10, RealRegs ) = false then
    begin { falls ein Fehler aufgetreten ist }
      writeln( 'GetSimRealModeIntFehler: ', SimRealModeIntErrorCode );
      halt(1);
    end;
  { kopieren der Informationen aus dem LowMemoryBlock in die Variable
    VESAInfo, damit die Informationen anschliessend direkt im Protected Mode
    ausgelesen werden knnen }
  for x := 0 to sizeof( VesaInfo) - 1 do
    mem[ seg( VESAInfo ) : ofs( VESAInfo) + x ] :=
      mem[ LowMemoryBlock.ProtModeSel: x ];
  { freigeben des LowMemoryBlocks }
  FreeLowMem( LowMemoryBlock );
end;

procedure GetModeInfo( mode : word );
var
  x : word;
begin
  { allozieren von 300 Byte Speicher, der unterhalb des ersten MB liegt,
    d.h. er ist sowohl im Real Mode als auch im Protected Mode ansprechbar }
  AllocateLowMem( LowMemoryBlock,300 );
  { zunchst mit Dummynullen fllen }
  FillChar( RealRegs, SizeOf( RealRegs ), 0 );
  { Real Mode Segment auf den LowMemoryBlock }
  RealRegs.es := LowMemoryBlock.RealModeSeg;
  RealRegs.cx := mode;
  RealRegs.ax := $4f01; { holt sich bezglich des Modus mode die VESA Info }
  if SimRealModeInt( $10, RealRegs ) = false then
    begin
      writeln( 'GetSimRealModeIntFehler: ', SimRealModeIntErrorCode );
      halt(1);
    end;
  { kopieren der Informationen aus dem LowMemoryBlock in die Variable
    VESAInfo, damit die Informationen anschliessend direkt im Protected Mode
    ausgelesen werden knnen }
  for x := 0 to sizeof( ModeInfo ) - 1 do
    mem[ seg( ModeInfo ) : ofs( ModeInfo ) + x ] :=
      mem[ LowMemoryBlock.ProtModeSel : x ];
  { freigeben des LowMemoryBlocks }
  FreeLowMem( LowMemoryBlock );
  { Berechnung der Granularitt }
  granny := 64 div ModeInfo.granularity;
end;

procedure InitVideo100h;
begin
  SetWindow100h( 0, 0, 639, 479 );
  GetVESAInfo;
  if VesaInfo.Signature <> 'VESA' then { falls VESA-Signatur nicht gefunden }
    begin
      writeln('VESA VBE-Treiber nicht gefunden!'); halt(1);
    end;
  GetModeInfo( Mode100h );
  writeln( 'Granularitt   : ', ModeInfo.granularity, ' KBytes' );
  writeln( 'Bytes/Scanline : ', ModeInfo.bytesperscanline );
  writeln( 'Breite         : ', ModeInfo.width );
  writeln( 'Hhe           : ', ModeInfo.height );
end;

procedure ActivePage100h( var page : TPage100h );
begin
  ActVPage100h := page; { aktuelle Seite, auf der gearbeitet werden soll }
end;

procedure CopyP2P100h( var DstPage, SrcPage : TPage100h );
var
  b : byte;
  Src, Dst : pointer;
begin
  asm push ds end;
  for b := 0 to 3 do { kopier Block 0 bis 5 von SrcPage in die }
    begin            { entsprechenden Blcke von DstPage }
      Src := SrcPage[ b ];
      Dst := DstPage[ b ];
      asm
        les di, Src
        lds si, Dst
        mov cx, 16000
        db $66; rep movsw { movsd }
      end;
    end;
  asm pop ds end;
END;

{ kopiert die virtuelle Seite zeilenweise auf den Bildschirm; dies ist ntig,
  das sonst das Bild zu flackern beginnt }
procedure CopyLines( s1, o1, s2, o2 : word; off : word;
                     lines : byte ); assembler;
asm
  push ds
    mov al, lines        { Anzahl der zu kopierenden Zeilen }
    mov es, SegA000      { nach SegA000:off kopieren }
    mov di, off          { Offset bezglich der aktuellen Bank }
    mov si,o1            { Offset des linken Blocks }
    mov dx,o2            { Offset des rechten Blocks }
    mov ds,s1            { Segment des linken Blocks }
    mov bx,s2            { Segment des rechten Blocks }
    @loop1:
      mov cx,80        { linke Seite; 80 DWords = 320 Pixel kopieren }
      db $66; rep movsw { movsd // und kopieren }
      xchg si,dx        { Werte von [DS:SI] fr rechte Seite holen }
      push ds           { und [DS:SI] der linken Seite sichern }
      mov ds,bx
      pop bx
      mov cx,80         { rechte Seite; 80 DWords = 320 kopieren }
      db $66; rep movsw { movsd }
      xchg si,dx        { Werte von [DS:SI] fr linke Seite holen }
      push ds           { und [DS:SI] der rechten Seite sichern }
      mov ds,bx
      pop bx
      dec al
      cmp al, 0         { bereits alle Zeilen kopiert ? }
    jnz @loop1
  pop ds
end;

{ bei den Zeilen, wo ein Bankwechsel stattfindet, den Kopiervorgang
  explizit behandeln; Routine zum Kopieren von length Bytes eines Blocks }
procedure CopyDWord( DstOffset,
                     SrcSegment, SrcOffset, length : word); assembler;
asm
  push ds
    mov es, SegA000   { [ES:DI] = Zieladresse der aktuellen Bank }
    mov di, DstOffset

    mov ds, SrcSegment { [DS:SI] = Quelladresse }
    mov si, SrcOffset

    mov cx, length     { Angabe erfolgt in Anzahl an Words }
    shr cx, 2

    db $66; rep movsw { movsd }
  pop ds
end;

procedure CopyP2V100h(VAR page:TPage100h);
var s0, s1, s2, s3, s4, s5 : word;
begin
  s0 := seg(page[0]^); s1 := seg(page[1]^);
  s2 := seg(page[2]^); s3 := seg(page[3]^);

  SetBank( 0 );                               { Bank 0                     }
  CopyLines( s0, 0, s1, 0, 0 , 102 );         { Zeile 0 - 100              }
  CopyDWord( 65280, s0, 32640, 256 );         { Zeile 102                  }
  SetBank( 1 );                               { Bank 1                     }
  CopyDWord( 0, s0, 32896, 64 );              { Zeile 102; linke Seite     }
  CopyDWord( 64, s1, 32640, 320 );            { Zeile 102; rechte Seite    }
  CopyLines( s0, 32960, s1, 32960, 384, 97 ); { Zeile 103 - 199            }
  CopyLines( s2, 0, s3, 0, 62464, 4 );        { Zeile 200-203              }
  CopyDWord( 65024, s2, 1280, 320 );          { Zeile 204; linke Seite     }
  CopyDWord( 65344, s3, 1280, 192 );          { Zeile 204; rechte Seite    }
  SetBank( 2 );                               { Bank 2                     }
  CopyDWord( 0, s3, 1472, 128 );              { Zeile 204                  }
  CopyLines( s2, 1600, s3, 1600, 128, 102 );  { Zeile 205-306              }
  CopyDWord( 65408, s2, 34240, 128 );         { Zeile 307; linke Seite     }
  SetBank( 3 );                               { Bank 3                     }
  CopyDWord( 0 , s2, 34368, 192 );            { Zeile 307; linke Seite     }
  CopyDWord( 192, s3, 34240, 320 );           { Zeile 307; rechte Seite    }
  CopyLines( s2, 34560, s3, 34560, 512, 92 ); { Zeile 308-399              }

end;

procedure ClearPage100h( page : TPage100h );
var
  block : byte;
  ppage : pointer;
begin
  for block :=0 to 3 do        { Block 0 bis 3 }
    begin
      ppage := page[ block ];
      asm
        les di, ppage
        db $66; xor ax,ax { xor eax, eax }
        mov cx,64000 / 4  { volle 64000 Bytes lschen, d.h. 200 Zeilen }
        db $66; rep stosw { stosd }
      end;
    end;
end;

procedure ClearVisualPage100h;
var
  bank : byte;
begin
  for bank := 0 to 3 do
    begin
      SetBank( bank );
      asm
        mov es,SegA000
        xor di,di
        db $66; xor ax,ax { xor eax, eax }
        mov cx,65536 / 4  { 64k = eine Bank lschen }
        db $66; rep stosw { stosd }
    end;
  end;
end;

procedure InitPage100h( var page : TPage100h );
var
  block : byte;
begin
  for block := 0 to 3 do InitPage( Page[ block ] );
  ActivePage100h( page );
end;

procedure ClosePage100h( var page : TPage100h );
var
  block : byte;
begin
  for block := 0 to 3 do
    ClosePage( Page[ block ] );
end;

procedure PutSprite100h( x, y : integer; sprite : TSprite );
var
  block      : word;
  posx, posy : integer;
begin
  block := 0;
  repeat
    { aktiven Block der 640x400 groen Seite auswhlen }
    ActVPage := ActVPage100h[ block ];
    { Rahmen fr den Block entsprechend des groen Rahmens festlegen }
    SetWindow( Windows100h[ block, 1 ], Windows100h[ block, 3 ],
               Windows100h[ block, 2 ], Windows100h[ block, 4 ] );
    { aus absoluten Koordinaten der 640x400 Seite die Koordinaten des
      Blocks berechnen, in dem gerade geschrieben werden soll }
    posx :=  CalcPageX( x, block ); posy :=  CalcPageY( y, block );
    { Sprite setzen; mit Hilfe der Routine fr die 320x200-Auflsung }
    PutSprite( posx, posy, sprite );
    inc( block ); { nchsten Block nehmen }
  until block > 3;
end;

procedure GetSprite100h( x, y : integer; sprite : TSprite );
var
  b       : byte;
  rx1,ry1 : longint;
  block   : word;
begin
  for block := 0 to 3 do
    begin
      rx1 := calcpagex( x, block );
      ry1 := calcpagey( y, block );
      ActVPage := ActVPage100h[ block ];
      SetWindow( Windows100h[ block, 1 ], Windows100h[ block, 3 ],
                 Windows100h[ block, 2 ], Windows100h[ block, 4 ] );
      GetSprite( rx1, ry1, sprite );
    end;
end;



procedure PutPixelHelp100h( x, y : integer; c : byte );
var
  block : word;
begin
  block := GetPage(x,y);
  ActVPage := ActVPage100h[ block ];
  PutPixel( x mod 320, y mod 200, c );
end;

function GetPixelHelp100h(x,y:integer ) : byte;
var
  block : word;
begin
  block := GetPage( x, y );
  ActVPage := ActVPage100h[ block ];
  GetPixelHelp100h := GetPixel( x mod 320, y mod 200 );
end;

procedure PutPixel100h( x, y : longint; c : byte );
begin
  if ( x >= GlobalWindowX1 ) and ( x <= GlobalWindowX2 ) and
     ( y >= GlobalWindowY1 ) and ( y <= GlobalWindowY2 ) then
    PutPixelHelp100h( x, y, c );
end;

function GetPixel100h( x, y : longint ) : byte;
begin
  GetPixel100h := 0; { wenn auerhalb des Fensters, dann Farbwert null }
  if ( x >= GlobalWindowX1 ) and ( x <= GlobalWindowX2 ) and
     ( y >= GlobalWindowY1 ) and ( y <= GlobalWindowY2 ) then
    GetPixel100h := GetPixelHelp100h( x, y );
end;

end.
