#pragma once
/* HandshakeControl.h, Benutzung:
	Handshaker* myHandshakePtr = new Handshaker;
	
	myHandshakePtr->HSKout(true);
	myHandshakePtr->HSKtoggle();
	if (myHandshakePtr->HSKin()) 
	
	delete myHandshakePtr;
ODER:	
	{	Handshaker myHandshake;
		
		myHandshaker.HSKout(true);
		myHandshaker.HSKtoggle();
		if (myHandshaker.HSKin()) 
		
	}	// automatisches Schlieen bei Blockende
*/

#include <Serial.h>

const Boolean handshakerModem = true;
const Boolean handshakerPrinter = false;
class Handshaker {
	public:
		// Handshake-Ausgang ansteueren. newLevel=TRUE -> positive Spannung (+4V), FALSE-> -4V
		void HSKout(const Boolean newLevel);		
		// Invertieren des des Handshake-Ausgangs
		void HSKtoggle(void);	
		Boolean HSKin(void);
		// ModemNotPrinter weglassen	-> Modemport
		// ModemNotPrinter=true				-> Modemport
		// ModemNotPrinter=false			-> Printerport	
		Handshaker(const Boolean ModemNotPrinter = true);		// Konstruktor
		~Handshaker();	// Destruktor
		Boolean Ok();		// Initialisierung erfolgreich?

	protected:
		short		theOutputRefNum, theInputRefNum;
		SerShk	theSerShkRec;
		Boolean	currentLevel, constructOk;
};