// cdrom1.cpp
// 
// Direkter Zugriff auf SCSI-CD-ROM.
// Funktionen fr Typ 1 Laufwerke (NEC)
//
// Johannes Karanitsch, 01.12.1996

#include "cdrom.h"



CDROM_TYPE_1::CDROM_TYPE_1(char *d)
  : CDROM(d)
{
  SaveMode = '\0';
}



CDROM_TYPE_1::~CDROM_TYPE_1()
{
  if (hFile) close();
}



DWORD CDROM_TYPE_1::open()
{
  DWORD er;
  UCHAR si[12];

  if (er = CDROM::open())
    return er;
  if (er = ModeSense(&si, sizeof(si)))
    return er;
  SaveMode = si[6];
  si[6] |= 0x20;
  return ModeSelect(&si, sizeof(si));
}



DWORD CDROM_TYPE_1::close()
{
  DWORD er;
  UCHAR si[12];

  er = ModeSense(&si, sizeof(si));
  si[6] = SaveMode;
  er = ModeSelect(&si, sizeof(si));
  return CDROM::close();
}



//
// Liest Audio Daten von CD-Rom.
//
// Parameter:
// lb - Block der gelesen werden soll.
// bc - Anzahl zu lesender Blcke.
// db - Zeiger zu Datenbuffer.
// dl - Lnge des Datenbuffers.
//
DWORD CDROM_TYPE_1::read(DWORD lb, DWORD bc, void *db, DWORD dl)
{
  DWORD er, il, ol;
  SCSI_PASS_THROUGH_DIRECT_WITH_BUFFER sb;

  ZeroMemory(&sb, sizeof(SCSI_PASS_THROUGH_DIRECT_WITH_BUFFER));
  sb.sptd.Length = sizeof(SCSI_PASS_THROUGH_DIRECT);
  sb.sptd.PathId = 0;
  sb.sptd.TargetId = 1;
  sb.sptd.Lun = 0;
  sb.sptd.CdbLength = 10;
  sb.sptd.DataIn = SCSI_IOCTL_DATA_IN;
  sb.sptd.SenseInfoLength = 32;
  sb.sptd.DataTransferLength = dl;
  sb.sptd.TimeOutValue = 4;
  sb.sptd.DataBuffer = db;
  sb.sptd.SenseInfoOffset =
     offsetof(SCSI_PASS_THROUGH_DIRECT_WITH_BUFFER, ucSenseBuf);
  sb.sptd.Cdb[0] = SCSIOP_READ_CDDA_10;
  sb.sptd.Cdb[2] = HIBYTE(HIWORD(lb));
  sb.sptd.Cdb[3] = LOBYTE(HIWORD(lb));
  sb.sptd.Cdb[4] = HIBYTE(LOWORD(lb));
  sb.sptd.Cdb[5] = LOBYTE(LOWORD(lb));
  sb.sptd.Cdb[7] = HIBYTE(LOWORD(bc));
  sb.sptd.Cdb[8] = LOBYTE(LOWORD(bc));
  il = sizeof(SCSI_PASS_THROUGH_DIRECT_WITH_BUFFER);
  if (DeviceIoControl(hFile, IOCTL_SCSI_PASS_THROUGH_DIRECT,
                      &sb, il, &sb, il, &ol, NULL)) {
    er = sb.sptd.ScsiStatus ? sb.sptd.ScsiStatus | 0x20000000 : 0;
  }
  else {
    er = GetLastError();
  }
  return er;
}



DWORD CDROM_TYPE_1::ModeSense(void *db, DWORD dl)
{
  DWORD er, il, ol;
  SCSI_PASS_THROUGH_DIRECT_WITH_BUFFER sb;

  ZeroMemory(db, dl);
  ZeroMemory(&sb, sizeof(SCSI_PASS_THROUGH_DIRECT_WITH_BUFFER));
  sb.sptd.Length = sizeof(SCSI_PASS_THROUGH_DIRECT);
  sb.sptd.PathId = 0;
  sb.sptd.TargetId = 1;
  sb.sptd.Lun = 0;
  sb.sptd.CdbLength = 10;
  sb.sptd.DataIn = SCSI_IOCTL_DATA_IN;
  sb.sptd.SenseInfoLength = 32;
  sb.sptd.DataTransferLength = dl;
  sb.sptd.TimeOutValue = 4;
  sb.sptd.DataBuffer = db;
  sb.sptd.SenseInfoOffset =
     offsetof(SCSI_PASS_THROUGH_DIRECT_WITH_BUFFER, ucSenseBuf);
  sb.sptd.Cdb[0] = SCSIOP_ADD_MODE_SENSE;
  sb.sptd.Cdb[1] = 0x08;
  sb.sptd.Cdb[2] = 0x0F;
  sb.sptd.Cdb[7] = HIBYTE(LOWORD(dl));
  sb.sptd.Cdb[8] = LOBYTE(LOWORD(dl));
  il = sizeof(SCSI_PASS_THROUGH_DIRECT_WITH_BUFFER);
  if (DeviceIoControl(hFile, IOCTL_SCSI_PASS_THROUGH_DIRECT,
                      &sb, il, &sb, il, &ol, NULL)) {
    er = sb.sptd.ScsiStatus ? sb.sptd.ScsiStatus | 0x20000000 : 0;
  }
  else {
    er = GetLastError();
  }
  return er;
}



DWORD CDROM_TYPE_1::ModeSelect(void *db, DWORD dl)
{
  DWORD er, il, ol;
  SCSI_PASS_THROUGH_DIRECT_WITH_BUFFER sb;

  ZeroMemory(&sb, sizeof(SCSI_PASS_THROUGH_DIRECT_WITH_BUFFER));
  sb.sptd.Length = sizeof(SCSI_PASS_THROUGH_DIRECT);
  sb.sptd.PathId = 0;
  sb.sptd.TargetId = 1;
  sb.sptd.Lun = 0;
  sb.sptd.CdbLength = 10;
  sb.sptd.DataIn = SCSI_IOCTL_DATA_OUT;
  sb.sptd.SenseInfoLength = 32;
  sb.sptd.DataTransferLength = dl;
  sb.sptd.TimeOutValue = 4;
  sb.sptd.DataBuffer = db;
  sb.sptd.SenseInfoOffset =
     offsetof(SCSI_PASS_THROUGH_DIRECT_WITH_BUFFER, ucSenseBuf);
  sb.sptd.Cdb[0] = SCSIOP_ADD_MODE_SELECT;
  sb.sptd.Cdb[1] = 0x10;
  sb.sptd.Cdb[7] = HIBYTE(LOWORD(dl));
  sb.sptd.Cdb[8] = LOBYTE(LOWORD(dl));
  il = sizeof(SCSI_PASS_THROUGH_DIRECT_WITH_BUFFER);
  if (DeviceIoControl(hFile, IOCTL_SCSI_PASS_THROUGH_DIRECT,
                      &sb, il, &sb, il, &ol, NULL)) {
    er = sb.sptd.ScsiStatus ? sb.sptd.ScsiStatus | 0x20000000 : 0;
  }
  else {
    er = GetLastError();
  }
  return er;
}
