// cdrom2.cpp
// 
// Direkter Zugriff auf SCSI-CD-ROM.
// Funktionen fr Typ 2 Laufwerke (HITACHI, SONY)
//
// Johannes Karanitsch, 01.12.1996

#include "cdrom.h"



CDROM_TYPE_2::CDROM_TYPE_2(char *d)
  : CDROM(d)
{
}



//
// Liest Audio Daten von CD-Rom.
//
// Parameter:
// lb - Block der gelesen werden soll.
// bc - Anzahl zu lesender Blcke.
// db - Zeiger zu Datenbuffer.
// dl - Lnge des Datenbuffers.
//
DWORD CDROM_TYPE_2::read(DWORD lb, DWORD bc, void *db, DWORD dl)
{
  DWORD er, il, ol;
  SCSI_PASS_THROUGH_DIRECT_WITH_BUFFER sb;

  ZeroMemory(&sb, sizeof(SCSI_PASS_THROUGH_DIRECT_WITH_BUFFER));
  sb.sptd.Length = sizeof(SCSI_PASS_THROUGH_DIRECT);
  sb.sptd.PathId = 0;
  sb.sptd.TargetId = 1;
  sb.sptd.Lun = 0;
  sb.sptd.CdbLength = 12;
  sb.sptd.DataIn = SCSI_IOCTL_DATA_IN;
  sb.sptd.SenseInfoLength = 32;
  sb.sptd.DataTransferLength = dl;
  sb.sptd.TimeOutValue = 4;
  sb.sptd.DataBuffer = db;
  sb.sptd.SenseInfoOffset =
     offsetof(SCSI_PASS_THROUGH_DIRECT_WITH_BUFFER, ucSenseBuf);
  sb.sptd.Cdb[0] = SCSIOP_READ_CDDA_12;
  sb.sptd.Cdb[2] = HIBYTE(HIWORD(lb));
  sb.sptd.Cdb[3] = LOBYTE(HIWORD(lb));
  sb.sptd.Cdb[4] = HIBYTE(LOWORD(lb));
  sb.sptd.Cdb[5] = LOBYTE(LOWORD(lb));
  sb.sptd.Cdb[6] = HIBYTE(HIWORD(bc));
  sb.sptd.Cdb[7] = LOBYTE(HIWORD(bc));
  sb.sptd.Cdb[8] = HIBYTE(LOWORD(bc));
  sb.sptd.Cdb[9] = LOBYTE(LOWORD(bc));
  il = sizeof(SCSI_PASS_THROUGH_DIRECT_WITH_BUFFER);
  if (DeviceIoControl(hFile, IOCTL_SCSI_PASS_THROUGH_DIRECT,
                      &sb, il, &sb, il, &ol, NULL)) {
    er = sb.sptd.ScsiStatus ? sb.sptd.ScsiStatus | 0x20000000 : 0;
  }
  else {
    er = GetLastError();
  }
  return er;
}
