// showlfn.c von Thomas Lauer, c't 5/97
// Das Programm zeigt mit Hilfe der Find[First/Next]File()-Funktionen einen
// Verzeichnisbaum an und gibt die Dateien aus, die einen kurzen und langen
// Dateinamen haben.
#include <windows.h>
#include <stdio.h>

CHAR szCurrDir[MAX_PATH];
CHAR szTempName[]="~!_$$_!~.TMP";
BOOL fRecurseDir=FALSE;
BOOL fIdenticalOnly=FALSE;
BOOL fOutputScript=FALSE;
UINT uCount=0;

INT Compare(LPSTR lp1,LPSTR lp2);
INT Compare(LPSTR lp1,LPSTR lp2)
{
  CHAR sz1[MAX_PATH],sz2[MAX_PATH];
  strcpy(sz1,lp1);
  strcpy(sz2,lp2);
  OemToChar(sz1,sz1);
  OemToChar(sz2,sz2);
  return lstrcmpi(sz1,sz2);
}

// Die Funktion gibt im Verzeichnis lpszDir alle Dateien aus, und  klettert
// dann ggf. rekursiv die Sub-Directories entlang.
VOID ShowDirectory(LPSTR lpszDir);
VOID ShowDirectory(LPSTR lpszDir)
{
  CHAR szSaveDir[MAX_PATH];
  HANDLE hSearch;
  WIN32_FIND_DATA wfd;
  BOOL fDirPrinted=FALSE;
  // Aktuelles Directory sichern
  GetCurrentDirectory(sizeof(szSaveDir),szSaveDir);
  if (lpszDir==NULL)
    lpszDir=szSaveDir;
  SetCurrentDirectory(lpszDir);
  hSearch=FindFirstFile("*.*",&wfd); // Erste Datei suchen
  if (hSearch!=INVALID_HANDLE_VALUE) { // Etwas gefunden?
    GetCurrentDirectory(sizeof(szCurrDir),szCurrDir);
    while (TRUE) { // Ja, ausgeben und weitermachen
      if (strcmp(wfd.cFileName,".")&&strcmp(wfd.cFileName,"..")) {
        // Nur "richtige" Dateien bearbeiten, kein . und ..
        BOOL fPrint=TRUE;
        if (strlen(wfd.cAlternateFileName)) {
          if (fOutputScript) {
            if (fIdenticalOnly)
              fPrint=Compare(wfd.cFileName,wfd.cAlternateFileName)==0;
            if (fPrint) {
              if (!fDirPrinted) {
                fDirPrinted=TRUE;
                OemToChar(szCurrDir,szCurrDir);
                GetShortPathName(szCurrDir,szCurrDir,sizeof(szCurrDir));
                CharToOem(szCurrDir,szCurrDir);
                printf("cd %s\n",szCurrDir);
              }
              printf("ren %s %s\n",wfd.cAlternateFileName,szTempName);
              printf("ren %s %s\n",szTempName,wfd.cAlternateFileName);
              uCount++;
            }
          }
          else {
            if (fIdenticalOnly)
              fPrint=Compare(wfd.cFileName,wfd.cAlternateFileName)==0;
            if (fPrint) {
              if (!fDirPrinted) {
                fDirPrinted=TRUE;
                printf("%s:\n",szCurrDir);
              }
              printf("  %s (%s)\n",wfd.cFileName,wfd.cAlternateFileName);
              uCount++;
            }
          }
        }
      }
      if (!FindNextFile(hSearch,&wfd)) // auf zur nchsten
        break;
    }
    FindClose(hSearch);
  }
  else // keine Datei gefunden, sollte nie vorkommen
    printf("In %s keine Dateien gefunden\n",lpszDir);
  if (fRecurseDir) {
    // Rekursiv durch alle Sub-Directories
    hSearch=FindFirstFile("*.*",&wfd);
    while (hSearch!=INVALID_HANDLE_VALUE)
    {
      if (wfd.dwFileAttributes&FILE_ATTRIBUTE_DIRECTORY) { // Directory?
        if (strcmp(wfd.cFileName,".")&&strcmp(wfd.cFileName,"..")) {
          // Nur "richtige" Directories bearbeiten
          ShowDirectory(wfd.cFileName); // und rein ins Vergngen
        }
      }
      if (!FindNextFile(hSearch,&wfd)) // weiter im Text mit der nchsten
        break;
    }
  }
  FindClose(hSearch);
  SetCurrentDirectory(szSaveDir);
}

INT main(INT argc,CHAR *argv[])
{
  CHAR szDir[MAX_PATH]="."; // Bearbeitet immer das aktuelle Directory
  SetFileApisToOEM();       // Damit die Zeichenstze bereinstimmen...
  argc--;
  while (argc) {            // Argumente?
    if (stricmp(argv[argc],"/r")==0)  // Rekursiv?
      fRecurseDir=TRUE;
    if (stricmp(argv[argc],"/i")==0)  // Nur identische Namen?
      fIdenticalOnly=TRUE;
    if (stricmp(argv[argc],"/b")==0)  // BAT-Datei ausgeben?
      fOutputScript=TRUE;
    argc--;
  }
  ShowDirectory(szDir);
  if (fOutputScript)
    printf("\necho %d Dateien/Directories bearbeitet.\n",uCount);
  else
    printf("\n%d Dateien/Directories gefunden.\n",uCount);
  return 0;
}
