package CTalk.server;

import java.rmi.*;
import java.rmi.server.*;
import java.util.*;

import CTalk.*;

public class ChatServerImpl extends UnicastRemoteObject implements ChatServer
{
  Hashtable events=new Hashtable ();
  Vector clients;
  
  public ChatServerImpl () throws RemoteException
  {
    clients=new Vector ();
  }
  
  public boolean login (String str) throws RemoteException
  {
    if (clients.indexOf (str)>-1)
      return false;
        
    clients.addElement (str);
    fireEvent (str,new ChatServerEvent (ChatServerEvent.LOGIN,null));
    fireEventToAll (new ChatServerEvent (ChatServerEvent.LIST_UPDATE,clients));
    
    return true;
  }
  
  public boolean logout (String str) throws RemoteException
  {
    events.remove (str);
 
    System.out.println (str + " logs out.");
        
    if (clients.indexOf (str)!=-1)
    {
      clients.removeElementAt (clients.indexOf (str)); 
      fireEvent (str,new ChatServerEvent (ChatServerEvent.LOGOUT,null));
      fireEventToAll (new ChatServerEvent (ChatServerEvent.LIST_UPDATE,clients));
    }
    
    return true;
  }
  
  void fireEventToAll (ChatServerEvent evt)
  {
    for (int i=0;i<clients.size();i++)
      fireEvent ("" + clients.elementAt (i),evt);
  }
  
  void fireEvent (String name, ChatServerEvent evt)
  {
    Vector v=(Vector) events.get (name);
    if (v==null)
      v=new Vector ();
      
    v.addElement (evt);
    events.put (name,v);
    
  }
  
  public ChatServerEvent waitForEvent (String str) throws RemoteException
  {
    ChatServerEvent evt=null;
          
    if (!events.containsKey (str))
      return null;
    
    Vector v=(Vector) events.get (str);
    evt=(ChatServerEvent) v.elementAt (0);
    v.removeElementAt (0);
    
    if (v.size()>0)
      events.put (str,v);
    else
      events.remove (str);
      
    return evt;
  }

  public void tell (String name, String m)
  {
    fireEventToAll (new ChatServerEvent (ChatServerEvent.MESSAGE,name +": " +m));
  }
  
  public static void main (String args[])
  {
    System.setSecurityManager (new RMISecurityManager ());
    
    try
    {
      ChatServerImpl impl=new ChatServerImpl ();
      
      Naming.rebind ("//"+java.net.InetAddress.getLocalHost().getHostName()+"/CTalk",impl);
      System.out.println ("Bound. Stubs could be found at: " + System.getProperty ("java.rmi.server.codebase"));
    }
    catch (Exception e)
    { }
  }
}

