

// includes
#include "CLogStrm.hpp"


BOOL CLogStream::open (const CHAR* fileName)
{
	if (INVALID_HANDLE_VALUE != hFile) {
		close();
	}
	// open/create the logfile with shared read access
	hFile = CreateFile(fileName, GENERIC_READ | GENERIC_WRITE, FILE_SHARE_READ, NULL, OPEN_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL);
	if (INVALID_HANDLE_VALUE != hFile) {
		// seek to EOF, assuming a file < 4GB
		SetFilePointer(hFile, 0L, NULL, FILE_END);
	}
	return (INVALID_HANDLE_VALUE != hFile);
} /* open */


BOOL CLogStream::close (VOID)
{
	if (INVALID_HANDLE_VALUE != hFile) {
		if (CloseHandle(hFile)) {
			hFile = INVALID_HANDLE_VALUE;
		}
	}
	return (INVALID_HANDLE_VALUE == hFile);
} /* close */


CLogStream& operator<< (CLogStream& logStream, const CHAR* oString)
{
	DWORD	bytesWritten;

	if (INVALID_HANDLE_VALUE != logStream.hFile) {
		WriteFile(logStream.hFile, oString, lstrlen(oString), &bytesWritten, NULL);
	}
	return logStream;
} /* operator<< (CHAR*) */


CLogStream& operator<< (CLogStream& logStream, const SYSTEMTIME& oTime)
{
	DWORD	bytesWritten;
	CHAR	datime[MAX_PATH];
	CHAR	tmpStr[MAX_PATH];

	if (INVALID_HANDLE_VALUE != logStream.hFile) {
		// convert date and time to a string and then write to file
		if (0 != GetDateFormat(LOCALE_SYSTEM_DEFAULT, DATE_SHORTDATE, &oTime, NULL, datime, MAX_PATH)) {
			if (0 != GetTimeFormat(LOCALE_SYSTEM_DEFAULT, LOCALE_NOUSEROVERRIDE, &oTime, NULL, tmpStr, MAX_PATH)) {
				lstrcat(datime, " ");
				lstrcat(datime, tmpStr);
				WriteFile(logStream.hFile, datime, lstrlen(datime), &bytesWritten, NULL);
			}
		}
	}
	return logStream;
} /* operator<< (SYSTEMTIME&) */


CLogStream::CLogStream (VOID)
{
	hFile = INVALID_HANDLE_VALUE;
} /* CLogStream */


CLogStream::~CLogStream (VOID)
{
	if (INVALID_HANDLE_VALUE != hFile) {
		close();
	}
} /* ~CLogStream */






