#!/usr/local/bin/perl -wT
#---------------------------------------------------------------------
# calc.pl - einfaches CGI fuer Arithmetik
# mit hoher Sicherheit
# -wT : Warnungen und Taint Check eingeschaltet

$ENV{'PATH'} = '/bin:/usr/bin';    # Path auf definierten Wert
                                   # sicher ist sicher
$OK_CHARS =  '0-9+*\/\-\(\) ';     # erlaubte Benutzerzeichen
                                   # eigentlich '0-9+*/-() '
$| = 1;                            # autoflush an, wichtig bei Fehlern

# Falls nph-script noetig (unter MS-IIS) folgendes auskommentieren:
# print 'HTTP/1.0 200 OK',"\n";        # Statuscode fuer nph-scripts

print "Content-type: text/html\n\n";   # Mime-type
print "<HTML><HEAD><TITLE>\n",
       "Einfacher Kalkulator\n",
       "</TITLE><HEAD><BODY>\n",
       "<H1>Kalkulator</H1>\n";        # Ueberschrift

# erzeugen der Eingabemaske.
# qq(..) enspricht ".." und ist nuetzlich wenn im String " vorkommen
print qq(<FORM METHOD="GET">\n),
      'Berechne:',
      qq(<INPUT TYPE="text" NAME="calc">\n),
      qq(<INPUT TYPE="submit">\n),
      "</FORM><HR>";

# Holen der Benutzereingabe. In der Environmentvariablen QUERY_STRING
# uebergibt der Webserver die Variablen in der Form
# name1=wert1&name2=wert2, viele Zeichen zusaetzlich in hex codiert
# in unseren Fall jedoch nur eine variable, z.B. "calc=4*5-2"
$userinput = $ENV{'QUERY_STRING'};
if(defined ($userinput) )             # nur falls Eingabeparameter
{
    $userinput =~ s/calc=//;          # loesche vorderen Teil
    $userinput =~ s/\+/ /g;           # Leerzeichen sind als + codiert
    # forme hexadezimal codierte Zeichen um
    $userinput =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C",hex($1))/eg;
    # jetzt haben wir unsere Benutzereingabe in $tocalc
                                      # ueberpruefe Benutzereingabe
    if($userinput =~ /^([$OK_CHARS]+)$/ )
    {
        $tocalc = $1;                 # $1 = erkannte "gute" Eingabe
        $result = eval($tocalc);      # lasse perl rechnen
                                      # nur Arithmetik moeglich
        print "Das Ergebnis von $tocalc ist $result";
    }
    else                              # schlechte Benutzereingabe
    {                                 # schreibe Logfile
        &log_usererror('calc', $userinput);
        print "Bitte geben Sie nur Zahlen und Rechenzeichen ein.";
    }
}
print end_html;                       # standard HTML Ende

#---------------------------------------------------------------------
# Unterrotine zum Aufzeichnen von fehlerhaften Eingaben.
# Auf diese Weise koennen Einbruchversuche registriert werden.
# Achtung: auf manchen Betriebsystemen muss das Logfile schon
# existieren. Der Webserver muss Schreibrechte haben!
#---------------------------------------------------------------------
sub log_usererror{

    my($paramname, $badinput) = @_;        # Parameteruebergabe
    my($Logfile)    = "../../usererr.log"; # ausserhalb Dokumentenroot

    my($lastpage)   = $ENV{'HTTP_REFERER'};
    $lastpage = "unbekannt" unless defined($lastpage);

    my($userbrowser) = $ENV{'HTTP_USER_AGENT'};
    $userbrowser = "unbekannt" unless defined($userbrowser);

    my($useripnr)    = $ENV{'REMOTE_ADDR'};
    $useripnr = "unbekannt" unless defined($useripnr);

    my($currenttime) = &showDate();

    my($scriptname)  = $ENV{'SCRIPT_NAME'};
    $scriptname = "unbekannt" unless defined($scriptname);

    my($logmessage)  = "--\n" .
                       "Skript: $scriptname\n" .
                       "Datum:  $currenttime\n" .
                       "Browser: $userbrowser\n" .
                       "Ip-nr:   $useripnr\n" .
                       "von:     $lastpage\n" .
                       "Feld:    $paramname\n".
                       "Eingabe: >>$badinput<<\n";
#   print($logmessage);            # Testausgabe, auskommentiert

    # Schreibe $logmessage an das Ende vom Logfile:
    open (LOGFILE, ">>$Logfile") ||
          print STDERR "can not open Log $Logfile\n";
    print LOGFILE $logmessage;
    close (LOGFILE);
}

#---------------------------------------------------------------------
# showdate liefert Datumsstempel im Format dd-mm-yyyy hh:mm
# funktioniert auch im Jahr 2000
# (perl zaehlt Jahre ab Jahr 1900,
# das Jahr 2001 wird als Jahr 101 dargestellt)
#---------------------------------------------------------------------
sub showDate{
    my(@datelist) = localtime(time);
    my($year) = $datelist[5] + 1900;
    return  "$datelist[3]-$datelist[4]-$year"
                . " $datelist[2]:$datelist[1]";
}
