/*
** Funktion zum lesen der Cgi-Post Parameter
** Diese wird ueber die Standardeingabe uebertragen,
** in der Umgebungsvariablen CONTENT_LENGTH meldet
** der Webserver die Laenge der Eingabe.
** Leider kann der Post-Parameter beliebig lang werden
** (siehe http://www.w3.org/Security/Faq/, Q34)
*/
#include <stdlib.h>
#include <stdio.h>

static char query_string[1024];
char* read_post_bad()
{
  int length;
  length = atoi( getenv( "CONTENT_LENGTH" ) );
  fread(query_string, length, 1, stdin);      /* <- Ueberlauf */
  return query_string;
}

/*
** verbesserte Version. Da aber eventuell nicht genug Speicher
** vorhanden ist, muss entweder der Aufrufer
** auf NULL testen, oder diese Funktion muss das Skript hart
** abbrechen, so dass der Webserver eine Fehlermeldung generiert
** Weiterhin muss der Speicher wieder freigegeben werden,
** bei kurzlebigen Cgi-Skripten ist dies aber oft nicht noetig
*/
char* read_post_good()
{
  int length = atoi(getenv("CONTENT_LENGTH"));
  char* query_string = (char*) malloc(length);
  if (query_string != NULL)
     fread(query_string,query_size,1,stdin);
 /* ggf Fehlerbehandlung falls query_string == NULL
 */
  return query_string;
}
