unit MandelServU;  // Apfelmnnchen-Server, 10-FEB-98 as

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls,
  Forms, Dialogs, MandelServ_COM, MandelServ_TLB, ExtCtrls,
  StdCtrls;

type
  TServerForm = class(TForm)
    Label1: TLabel;  // "Status:"
    lStatus: TLabel;  // Anzeige der laufenden Zeile
    procedure FormCreate(Sender: TObject);
  protected
    procedure IdleLoop(Sender: TObject; var Done: Boolean);
    procedure DoCalculation;
  public  // COM-Objekt setzt sich mit StartCalc hier ein
    CurCalcObj: IMandelCalc;
    procedure Shutdown;
  end;

var
  ServerForm: TServerForm;

implementation

{$R *.DFM}

procedure TServerForm.FormCreate(Sender: TObject);
begin
  Application.OnIdle := IdleLoop;
  lStatus.Caption := 'Idle';
end;

procedure TServerForm.Shutdown;
begin
  Close;
end;

// ber OnIdle aufgerufen
procedure TServerForm.DoCalculation;
var CalcObj: IMandelCalc;
  x,y, IterMax: Integer; ReStart, RePart, ImPart: Double;
  CalcResult: Variant; PPixels: ^TColor;
  ColorStretch: LongInt;
Label CalcStopped;

  // Reichlich standardmg, ohne Kreis-Zykloidentest, asm etc.
  function Iterate(Re, Im: Double): Integer;
  var x,y,x2,y2: Double; k: Integer;
  begin
    x := 0; y := 0; x2 := y; y2 := 0; k := 0;
    repeat
      y := 2 * x * y + Im; x := x2 - y2 + Re;
      x2 := Sqr(x); y2 := Sqr(y);
      Inc(k);
    until (x2+y2 > 4) or (k >= IterMax);
    Result := k;
  end;

begin
  CalcObj := CurCalcObj;  // erzeugt eine weitere Referenz
  CurCalcObj := nil;  // OnIdle: nicht nochmal aufrufen

  // Ergebnis (RGB-Werte) als Var-Array
  CalcResult := VarArrayCreate([0,
     CalcObj.Cols*CalcObj.Lines*SizeOf(TColor)], varByte);
  PPixels := VarArrayLock(CalcResult);

  ImPart := CalcObj.ImStart; IterMax := CalcObj.IterMax;
  ReStart := CalcObj.ReStart+CalcObj.ColStart*CalcObj.ReStep;
  ColorStretch := 256*256*256 div IterMax;

  for y := 0 to CalcObj.Lines-1 do
  begin
    RePart := ReStart; CalcObj.CurLine := y;
    lStatus.Caption := 'Calc, Line: '+IntToStr(y);
    for x := 0 to CalcObj.Cols-1 do
    begin
      // 0..MAXITER -> 0..MAXCOLOR (Farbskalierung)
      PPixels^ := TColor(Iterate(RePart,ImPart) * ColorStretch);
      Inc(PPixels);
      RePart := RePart + CalcObj.ReStep;
      // Label-Update, DCOM-Nachrichten...
      Application.ProcessMessages;
      // Abbruch von auen (.StopCalc)?
      if not CalcObj.Calculating  then goto CalcStopped;
    end;
    ImPart := ImPart + CalcObj.ImStep;
  end;
  CalcObj.CurLine := CalcObj.Lines;  // Berechnung beendet
CalcStopped:
  VarArrayUnlock(CalcResult);
  if CalcObj.Calculating then CalcObj.VPixels := CalcResult;
  lStatus.Caption := 'Idle';
  // Var-Array wird automatisch abgerumt
end;

// Zeitliche Entkoppelung: TMandelCalc.StartCalc setzt sich selbst
// als CurCalcObj ein und wird dann beim nchsten OnIdle bearbeitet
procedure TServerForm.IdleLoop(Sender: TObject; var Done: Boolean);
begin
  if (CurCalcObj <> nil) then DoCalculation;
  Done := True;
end;

end.
