// MFCLanguageCtl.h : Declaration of the CMFCLanguageCtrl OLE control class.

/////////////////////////////////////////////////////////////////////////////
// CMFCLanguageCtrl : See MFCLanguageCtl.cpp for implementation.

class CMFCLanguageCtrl : public COleControl
{
	DECLARE_DYNCREATE(CMFCLanguageCtrl)

// Constructor
public:
	CMFCLanguageCtrl();

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CMFCLanguageCtrl)
	public:
	virtual void OnDraw(CDC* pdc, const CRect& rcBounds, const CRect& rcInvalid);
	virtual void DoPropExchange(CPropExchange* pPX);
	virtual void OnResetState();
	virtual BOOL OnSetExtent(LPSIZEL lpSizeL);
	//}}AFX_VIRTUAL

// Implementation
protected:
	~CMFCLanguageCtrl();

	CImageList m_imlst;

	DECLARE_OLECREATE_EX(CMFCLanguageCtrl)    // Class factory and guid
	DECLARE_OLETYPELIB(CMFCLanguageCtrl)      // GetTypeInfo
	DECLARE_PROPPAGEIDS(CMFCLanguageCtrl)     // Property page IDs
	DECLARE_OLECTLTYPE(CMFCLanguageCtrl)		// Type name and misc status

// Message maps
	//{{AFX_MSG(CMFCLanguageCtrl)
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

// Dispatch maps
	//{{AFX_DISPATCH(CMFCLanguageCtrl)
	long m_language;
	afx_msg void OnLanguageChanged();
	//}}AFX_DISPATCH
	DECLARE_DISPATCH_MAP()

	afx_msg void AboutBox();

// Event maps
	//{{AFX_EVENT(CMFCLanguageCtrl)
	void FireLanguageChanged(long lang)
		{FireEvent(eventidLanguageChanged,EVENT_PARAM(VTS_I4), lang);}
	//}}AFX_EVENT
	DECLARE_EVENT_MAP()

// Dispatch and event IDs
public:
	enum {
	//{{AFX_DISP_ID(CMFCLanguageCtrl)
	dispidLanguage = 1L,
	eventidLanguageChanged = 1L,
	//}}AFX_DISP_ID
	};
};
