/*
	CCApplet
	(C) 1998 Jens von Pilgrim, Heise Verlag
	
	Applet zur Demonstration der Netscape Capabilities Classes
	bentigt Netscape 4.03 oder hher und zugehriges AWT 1.1-Patch
 */


import java.awt.*;
import java.applet.*;
import java.awt.event. ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

import netscape.security.PrivilegeManager;

import ImageComponent;

public class CCDemo extends Applet
implements ActionListener
{
	public void init()
	{
		setLayout(null);
		setSize(426,266);
		c_pbLoad = new java.awt.Button();
		c_pbLoad.setLabel("Lade Bild");
		c_pbLoad.setBounds(48,60,71,24);
		c_pbLoad.setBackground(new Color(12632256));
		add(c_pbLoad);
		c_icImage = new ImageComponent();
		c_icImage.setBounds(144,24,209,207);
		add(c_icImage);

	   	c_pbLoad.addActionListener(this);

	}
	
	public void actionPerformed(java.awt.event.ActionEvent event)
	{
		Object object = event.getSource();
		if (object == c_pbLoad)
			onLoadImage();
	}
	
	private void onLoadImage()
	{
	    try {
    		Image img = Toolkit.getDefaultToolkit().createImage(loadImageData());
    		c_icImage.setImage(img);
    	} catch (Exception e) {
    	    System.out.println("Fehler beim Laden des Bildes: "+e);
    	}
    		
	}
	
	// private wre sicherer  -  siehe Text
	public static 
	    byte[] loadImageData() throws Exception {
	    
	    PrivilegeManager pm = PrivilegeManager.getPrivilegeManager();
	    
	    try {
	        pm.enablePrivilege("UniversalFileRead");
	        System.out.println("UniversalFileRead freigeschaltet");
	    } catch (netscape.security.ForbiddenTargetException e)  {
	        System.out.println("Privileg fr UniversalFileRead wurde verweigert: "+e);
   	        throw new Exception ("Fehler beim Lesen");
   	    } catch (Exception e) {
   	        System.out.println("Unbekannter Fehler: "+e);
  	        throw new Exception ("Fehler beim Lesen");
   	    } 
   	    
    	Frame f = new Frame();
       	FileDialog fdlg = new FileDialog( f, "Browse thumbail", FileDialog.LOAD);
        String ExtList[] = { ".jpg", ".gif" };
        fdlg.setFile("*.gif;*.jpg");
        fdlg.show();
        String name = fdlg.getFile();
        if (name==null) throw new Exception ("Keine Datei ausgewhlt");
        String dir = fdlg.getDirectory();

	    try {
	        File finfo = new File(dir+name);
            if (!finfo.exists()) {
                throw new Exception("Datei \""+dir+name+"\" nicht gefunden.");
            }
            long length = finfo.length();
            FileInputStream in = new FileInputStream(dir+name);
            byte[] imageData = new byte[ (int) length ];
            in.read(imageData);
            return imageData;
        } catch (IOException e) {
            System.out.println("IOFehler: "+e);
            throw new Exception("Fehler beim Lesen");
        }
    } 

   	java.awt.Button c_pbLoad;
	ImageComponent c_icImage;
}