// MFCGameCtlDlg.cpp : implementation file
//

#include "stdafx.h"
#include "MFCGameCtl.h"
#include "MFCGameCtlDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

//////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);  // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

//////////////////////////////////////////////////////////////////////
// CMFCGameCtlDlg dialog

CMFCGameCtlDlg::CMFCGameCtlDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CMFCGameCtlDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CMFCGameCtlDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note: LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CMFCGameCtlDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMFCGameCtlDlg)
	DDX_Control(pDX, IDC_4X4, m_ctrl_4x4);
	DDX_Control(pDX, IDC_FELD, m_ctrl_feld);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CMFCGameCtlDlg, CDialog)
	//{{AFX_MSG_MAP(CMFCGameCtlDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_COMPSUGG, OnCompsugg)
	ON_BN_CLICKED(IDC_4X4, On4x4)
	ON_BN_CLICKED(IDC_NEWGAME, OnNewgame)
	ON_BN_CLICKED(IDC_ZUGMACHEN, OnZugmachen)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

//////////////////////////////////////////////////////////////////////
// CMFCGameCtlDlg message handlers

BOOL CMFCGameCtlDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	CString strAboutMenu;
	strAboutMenu.LoadString(IDS_ABOUTBOX);
	if (!strAboutMenu.IsEmpty())
	{
		pSysMenu->AppendMenu(MF_SEPARATOR);
		pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
	}

	// Set the icon for this dialog.  The framework does this 
	//  automatically when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// Automationobjekt holen
	CLSID clsid;
  
	// Die CLSID holen mit der gegebenen ProgID
	if(!SUCCEEDED(CLSIDFromProgID(OLESTR("mfcgame.application"),
		                            &clsid)))
	{
		EndDialog(IDABORT);
		return FALSE;
	}

	IUnknown *unk;
	IDispatch *disp;
	HRESULT hr;

	// Ist das Objekt schon da ?
	if(SUCCEEDED(GetActiveObject(clsid,0,&unk)))
	{
		hr=unk->QueryInterface(IID_IDispatch,(void**)&disp);
		unk->Release();
		if(SUCCEEDED(hr))
			m_gameobj.AttachDispatch(disp,1);
	}

	if(!m_gameobj.m_lpDispatch)
	{
		// wenn nicht, dann erzeugen
		if(!m_gameobj.CreateDispatch("mfcgame.application"))
		{
			EndDialog(IDABORT);
			return FALSE;
		}
	}
  
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CMFCGameCtlDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code
//  below to draw the icon.  For MFC applications using the document/
//  view model, this is automatically done for you by the framework.

void CMFCGameCtlDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the
//  user drags the minimized window.
HCURSOR CMFCGameCtlDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CMFCGameCtlDlg::OnCompsugg() 
{
	m_gameobj.ComputerSugg();
}

void CMFCGameCtlDlg::On4x4() 
{
	BOOL v;

	v=m_ctrl_4x4.GetCheck();
	m_gameobj.SetMode4x4(v);
}

void CMFCGameCtlDlg::OnNewgame() 
{
	m_gameobj.NewGame();
}

void CMFCGameCtlDlg::OnZugmachen() 
{
	long index;
	int l;
	CString s;

	m_ctrl_feld.GetWindowText(s);
	l=s.GetLength();
	if(l<1 || l>2)
		return;
	index=atol(s);

	m_gameobj.HitField(index);

	m_ctrl_feld.SetWindowText("");
}
