unit SLREdit;

{The Little Richard Editor
 (C) 1996, 1997 by Johannes Leckebusch
 22. 11. 97}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, StdCtrls, ComCtrls, ExtCtrls,
{$IFDEF Explorer}
  IExplorer,
{$ENDIF}
  OleCtnrs, Buttons;

type
  TEditForm = class(TForm)
    Textmenu: TMainMenu;
    Datei3: TMenuItem;
    Neu1: TMenuItem;
    Oeffnen1: TMenuItem;
    Speichern1: TMenuItem;
    Speichernunter1: TMenuItem;
    N2: TMenuItem;
    Beenden1: TMenuItem;
    Bearbeiten1: TMenuItem;
    Ausschneiden1: TMenuItem;
    Kopieren1: TMenuItem;
    Einfuegen1: TMenuItem;
    Loeschen1: TMenuItem;
    N3: TMenuItem;
    Allesauswhlen1: TMenuItem;
    Zeichen1: TMenuItem;
    Links1: TMenuItem;
    Rechts1: TMenuItem;
    Zentrieren1: TMenuItem;
    N4: TMenuItem;
    Zeilenumbruch1: TMenuItem;
    N5: TMenuItem;
    Schriftart1: TMenuItem;
    Schliessen1: TMenuItem;
    PopupMenu1: TPopupMenu;
    FontDialog1: TFontDialog;
    SaveFileDialog: TSaveDialog;
    PrinterSetupDialog1: TPrinterSetupDialog;
    PrintDialog1: TPrintDialog;
    N6: TMenuItem;
    {Datei2: TMenuItem;}
    Drucker1: TMenuItem;
    Drucken1: TMenuItem;
    Druckereinrichtung1: TMenuItem;
    Drucker2: TMenuItem;
    Speichern2: TMenuItem;
    Speichernunter2: TMenuItem;
    Druckereinrichten1: TMenuItem;
    Drucken2: TMenuItem;
    Zeichen2: TMenuItem;
    Links2: TMenuItem;
    Rechts2: TMenuItem;
    Zentrieren2: TMenuItem;
    N1: TMenuItem;
    Zeilenumbruch2: TMenuItem;
    Neu2: TMenuItem;
    Oeffnen2: TMenuItem;
    N8: TMenuItem;
    Beenden2: TMenuItem;
    Schliessen2: TMenuItem;
    Minimieren1: TMenuItem;
    Minimieren2: TMenuItem;
    Schriftart2: TMenuItem;
    N9: TMenuItem;
    N7: TMenuItem;
    Suchen1: TMenuItem;
    Ersetzen1: TMenuItem;
    Bearbeiten2: TMenuItem;
    Einfuegen2: TMenuItem;
    Ausschneiden2: TMenuItem;
    Kopieren2: TMenuItem;
    Loeschen2: TMenuItem;
    N10: TMenuItem;
    Allesauswhlen2: TMenuItem;
    N11: TMenuItem;
    Suchen3: TMenuItem;
    Ersetzen3: TMenuItem;
    Einstellungen: TMenuItem;
    Editoreinstellungen: TMenuItem;
    N12: TMenuItem;
    Einstellungen1: TMenuItem;
    Editoreinstellungen1: TMenuItem;
    DateiEnde: TMenuItem;
    GlobalEinstellungen: TMenuItem;
    GlobaleEinstellungen1: TMenuItem;
    History1: TMenuItem;
    AlleSchliessen: TMenuItem;
    AlleMinimieren: TMenuItem;
    AlleSpeichern: TMenuItem;
    AlleSpeichern1: TMenuItem;
    AlleSchliessen1: TMenuItem;
    AlleMinimieren1: TMenuItem;
    Editor: TRichEdit;
    N14: TMenuItem;
    Rueckgaengig1: TMenuItem;
    Rueckgaengig2: TMenuItem;
    AlleOeffnen1: TMenuItem;
    Alleffnen1: TMenuItem;
    Fenster1: TMenuItem;
    Nebeneinander1: TMenuItem;
    Ueberlappend1: TMenuItem;
    Symboleanordnen1: TMenuItem;
    N15: TMenuItem;
    HistoryListe2: TMenuItem;
    Statuspanel: TPanel;
    CursorLabel: TLabel;
    Geaendert: TLabel;
    N16: TMenuItem;
    DruckeFenster1: TMenuItem;
    N18: TMenuItem;
    Objekteinfuegen1: TMenuItem;
    N19: TMenuItem;
    Objekteinfuegen2: TMenuItem;
    NN20: TMenuItem;
    MaximaleTextlaenge1: TMenuItem;
    PanelTopleiste: TPanel;
    Lineal: TPanel;
    LinealLinie: TBevel;
    LinkeEinrueckung: TLabel;
    ErsteZeileEinrueckung: TLabel;
    RechteEinrueckung: TLabel;
    PanelEditButtons: TPanel;
    SpeedButtonSelectAll: TSpeedButton;
    Favorites1: TMenuItem;
    N17: TMenuItem;
    AktuellesVerzeichnisaufnehmen1: TMenuItem;
    AktuellesVerzeichnisentfernen1: TMenuItem;
    N20: TMenuItem;
    Favorites2: TMenuItem;
    AktuellesVerzeichnisinFavoritesaufnehmen1: TMenuItem;
    AktuellesVerzeichnisausFavoriteslschen1: TMenuItem;
    N21: TMenuItem;
    History2: TMenuItem;
    Favoritesspeichern1: TMenuItem;
    AktuellesVerzeichnisaufnehmen2: TMenuItem;
    AktuellesVerzeichnisentfernen2: TMenuItem;
    N23: TMenuItem;
    Favoritenspeichern1: TMenuItem;
    AktuellesVerzeichnisinFavoritenaufnehmen1: TMenuItem;
    AktuellesVerzeichnisausFavoritenlschen1: TMenuItem;
    N24: TMenuItem;
    N25: TMenuItem;
    HTMLBrowser1: TMenuItem;
    BeendenundallesSpeichern1: TMenuItem;
    NeuOeffnen1: TMenuItem;
    NeuOeffnen2: TMenuItem;
    SpeedButtonShowWeb: TSpeedButton;
    Tagauswaehlen1: TMenuItem;
    TagDialog1: TMenuItem;
    N26: TMenuItem;
    MarkierteDateiladen1: TMenuItem;
    N27: TMenuItem;
    MarkierteDateiladen2: TMenuItem;
    TagDialogmitSelectlink1: TMenuItem;
    Suchmarkenverwaltung1: TMenuItem;
    Suchmarkenverwaltung2: TMenuItem;
    GehezuZeile1: TMenuItem;
    GehezuZeile2: TMenuItem;
    procedure Beenden1Click(Sender: TObject);
    procedure Neu1Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Schliessen1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure AlignClick(Sender: TObject);
    procedure Zeilenumbruch1Click(Sender: TObject);
    procedure AllesAuswaehlen(Sender: TObject);
    procedure Ausschneiden(Sender: TObject);
    procedure Kopieren(Sender: TObject);
    procedure Einfuegen(Sender: TObject);
    procedure Loeschen(Sender: TObject);
    procedure Bearbeiten1Click(Sender: TObject);
    procedure Schriftart1Click(Sender: TObject);
    procedure Oeffnen1Click(Sender: TObject);
    procedure Speichern1Click(Sender: TObject);
    procedure Speichernunter1Click(Sender: TObject);
    procedure Druckereinrichtung1Click(Sender: TObject);
    procedure Drucken1Click(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure Minimieren1Click(Sender: TObject);
    procedure Suchen1Click(Sender: TObject);
    procedure Ersetzen1Click(Sender: TObject);
    procedure Activate(Sender: TObject);
    procedure UeberLittleRichard2Click(Sender: TObject);
    procedure CursorDaten(Sender: TObject);
    procedure EditoreinstellungenClick(Sender: TObject);
    procedure EditorKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure EditorKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormDestroy(Sender: TObject);
    procedure GlobalEinstellungenClick(Sender: TObject);
    procedure History1Click(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure AlleSchliessenClick(Sender: TObject);
    procedure AlleMinimierenClick(Sender: TObject);
    procedure AlleSpeichernClick(Sender: TObject);
    procedure LinealResize(Sender: TObject);
    procedure LinealElementMouseDown(Sender: TObject;
      Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure LinealElementMouseMove(Sender: TObject; Shift: TShiftState;
      X, Y: Integer);
    procedure LinkeEinrueckungMouseUp(Sender: TObject;
      Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure ErsteZeileEinrueckungMouseUp(Sender: TObject;
      Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure RechteEinrueckungMouseUp(Sender: TObject;
      Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure Rueckgaengig1Click(Sender: TObject);
    procedure AlleOeffnen1Click(Sender: TObject);
    procedure Nebeneinander1Click(Sender: TObject);
    procedure Ueberlappend1Click(Sender: TObject);
    procedure Symboleanordnen1Click(Sender: TObject);
    procedure HistoryListe2Click(Sender: TObject);
    procedure HistoryListe1Click(Sender: TObject);
    procedure DruckeFenster1Click(Sender: TObject);
    procedure Zeichen1Click(Sender: TObject);
//    procedure Hypertext1Click(Sender: TObject);
    procedure PopupMenu1Popup(Sender: TObject);
    procedure Objekteinfuegen1Click(Sender: TObject);
    procedure EditorEndDrag(Sender, Target: TObject; X, Y: Integer);
    procedure EditorDragOver(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
    procedure EditorDragDrop(Sender, Source: TObject; X, Y: Integer);
    procedure MaximaleTextlaenge1Click(Sender: TObject);
    procedure SpeedButtonSelectAllClick(Sender: TObject);
    procedure Favorites1Click(Sender: TObject);
    procedure AktuellesVerzeichnisaufnehmen1Click(Sender: TObject);
    procedure AktuellesVerzeichnisentfernen1Click(Sender: TObject);
    procedure Favoritesspeichern1Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure HTMLBrowser1Click(Sender: TObject);
    procedure BeendenundallesSpeichern1Click(Sender: TObject);
    procedure NeuOeffnen1Click(Sender: TObject);
    procedure Tagauswaehlen1Click(Sender: TObject);
    procedure TagDialog1Click(Sender: TObject);
    procedure MarkierteDateiladen1Click(Sender: TObject);
    procedure TagDialogmitSelectlink1Click(Sender: TObject);
    procedure History2Click(Sender: TObject);
    procedure GehezuZeile1Click(Sender: TObject);
  private
    { Private-Deklarationen }
    {Pfadname: string;}

    FRow:              LongInt;
    FColumn:           LongInt;

    FensterSchliessen: BOOLEAN;
    CursInsert:        BOOLEAN;
    SpeicherAbfrage: BOOLEAN;

    FDragOfs: Integer;
    FDragging: Boolean;
    FMyDateiManager: TForm;

    FTagname: String;

    procedure SetTagname (t: String);
    function GetTagname: String;

    procedure SetRow (Value: LongInt);
    procedure SetColumn (Value: LongInt);
    function GetRow: LongInt;
    function GetColumn: LongInt;

    procedure LinealEinrichten;
    procedure GetFontNames;
    function AktuellesVerzeichnis: String;
    procedure FavoritesClick (Sender: TObject);
  public
    { Public-Deklarationen }
    lasttarget: string;
    lasturl:    string;
    Pfadname: string;
    IsoAnzeige: BOOLEAN;
    AutoSave:   BOOLEAN;
    TextMakroListe: TStringList;
    TextMakroEditiert: BOOLEAN;
//    Hypertext: TWebBrowser;
{$IFDEF Explorer}
    Hypertext:  TIExplorerForm;
    Hypertextp: TIExplorerForm;
    Hypertextb: TIExplorerForm;
{$ENDIF}
    ZeichenProSeite: Integer;

// Hypertext, siehe SpeedButtonTagSelect in LRFrame
    tagstart, tagend,
    pairstart, pairend:       Integer;
    TagSelected:              BOOLEAN;
    dontShow:                 BOOLEAN;
    Tagassistent:             TForm;

    property Row: LongInt read GetRow write SetRow;
    property Column: LongInt read GetColumn write SetColumn;

    property Tagname: String read GetTagname write SetTagname;

    procedure Open (const AFileName: String);
    function CurrText: TTextAttributes;
    function SelectedText: TTextAttributes;
  end;

const
  cNamenvorgabe = 'Ohne Namen';
  RulerAdj = 4/3;
  GutterWid = 6;

var
  EditForm: TEditForm;

implementation

uses SmallLittleFrame, Clipbrd, Printers, STexteinstellungen, Filter,
  SGlobalEinstellungen{, olectnrs}, SDateimanager, HyperlinkForm;

{$R *.DFM}

CONST
  {cMaxHistory = 30;}
  cInsertBlink = 500;
  cOverBlink =   200;

procedure TEditForm.SetRow (Value: LongInt);
VAR sel: Integer;
begin
  WITH Editor DO BEGIN
    Value := Value - 1; IF Value < 0 THEN Value := 0;
    Sel := Perform (EM_LINEINDEX, Value, 0) {- 1};
    IF Sel < 0 THEN Sel := 0;
{showMessage ('SetRow SelStart := ' + IntToStr (Sel));}
    SelStart := Sel;
    FRow := SelStart;
  END (* WITH *);
end (* SetRow *);

function TEditForm.GetRow: LongInt;
begin
  WITH Editor DO
    Result := Perform (EM_LINEFROMCHAR, SelStart, 0) + 1;
end (* GetRow *);

procedure TEditForm.SetColumn (Value: LongInt);
VAR sel: Integer;
    row: Integer;
begin
  WITH Editor DO BEGIN
    DEC (Value); IF Value < 0 THEN Value := 0;
    row := GetRow - 1;
    FColumn := Perform (EM_LINELENGTH, Perform (EM_LINEINDEX, Row, 0), 0);
    if FColumn > Value then
      FColumn := Value; (* Cursor kann nicht hinter Zeilenende stehen *)
    Sel := Perform (EM_LINEINDEX, Row, 0) + FColumn;
{showMessage ('SetColumn SelStart := ' + IntToStr (Sel) + ', FCol: ' + IntToStr (FColumn));}
    SelStart := Sel;
  END (* WITH *);
end (* SetColumn *);

function TEditForm.GetColumn: LongInt;
begin
  WITH Editor DO
   Result := SelStart - Perform (EM_LINEINDEX, GetRow -1, 0) + 1;
end (* GetColumn *);

function TEditForm.CurrText: TTextAttributes;
begin
  IF Editor.SelLength > 0 THEN
    Result := Editor.SelAttributes
  ELSE
    Result := Editor.DefAttributes;
end (* CurrText *);

function TEditForm.SelectedText: TTextAttributes;
begin
  IF Editor.SelLength > 0 THEN
    Result := Editor.SelAttributes
  ELSE
    Result := NIL;
end (* CurrText *);

procedure TEditForm.SetTagname;
begin
  FTagname := ANSILowercase (t);
end (* SetTagname *);

function TEditForm.GetTagname;
begin
  Result := FTagname;
end (* GetTagName *);

function EnumFontsProc (VAR LogFont: TLogFont; VAR TextMetric: TTextMetric;
  FontType: Integer; Data: Pointer): Integer; stdcall;
BEGIN
  TStrings (Data).Add (LogFont.lfFacename);
  Result := 1;
END (* EnumFontsProc *);

procedure TEditForm.GetFontNames;
VAR DC: HDC;
BEGIN
  DC := GetDC (0);
  LRFrame.FontNamen.Clear;
  EnumFonts (DC, nil, @EnumFontsProc, Pointer (LRFrame.FontNamen.Items));
  ReleaseDC (0, DC);
  LRFrame.FontNamen.Sorted := TRUE;
END (* GetFontNames *);

procedure TEditForm.Beenden1Click(Sender: TObject);
begin
  LRFrame.Beenden1Click (Sender);
end;

procedure TEditForm.Neu1Click(Sender: TObject);
begin
  LRFrame.Neu1Click (Sender);
end;

procedure TEditForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  IF FensterSchliessen THEN BEGIN
    Action := caFree;
  END
  ELSE Action := caMinimize;
end;

procedure TEditForm.Minimieren1Click(Sender: TObject);
begin
  FensterSchliessen := FALSE;
  Close;
  FensterSchliessen := TRUE;
  {Sonst geht anschlieend Close-Button im Fenster nicht}
end;

procedure TEditForm.Schliessen1Click(Sender: TObject);
begin
  FensterSchliessen := TRUE;
  SpeicherAbfrage := TRUE;
  Close;
end;

procedure TEditForm.LinealEinrichten;
VAR I: Integer;
    S: String;
begin
  SetLength (S, 201);
  I := 1;
  WHILE I < 200 DO BEGIN
    S [I] := #9;
    IF (I + 1) MOD 4 = 0 THEN S [I + 1] := ':'
    ELSE S [I + 1] := '|';
    INC (I, 2);
  END;
  Lineal.Caption := S;
END;

procedure TEditForm.FormCreate(Sender: TObject);
VAR i: Integer;
begin
{$IFDEF Explorer}
  SpeedButtonShowWeb.Enabled := LRFrame.IExplorerInstalliert;
  HTMLBrowser1.Enabled := LRFrame.IExplorerInstalliert;
{$ELSE}
  SpeedButtonShowWeb.Visible := FALSE;
{$ENDIF}

  FensterSchliessen := TRUE; CursInsert := TRUE;

  WITH LRFrame.DefaultWindow DO BEGIN
    IF ChildWinDefault THEN BEGIN
      {Position := ChildPos;}
      (* - fhrt komischerweise zu doppeltem Fensterversatz.
         Aber wieso mu das nicht gesetzt werden??? *)
      WindowState := ChildWin;
      CASE ChildPos OF
        poDefaultPosOnly,
        poScreenCenter: BEGIN
                            Height := ChildHeight; Width := ChildWidth;
                          END;
        poDefaultSizeOnly: BEGIN
                             Top := ChildTop; Left := ChildLeft;
                           END;

      END (* CASE *);
    END (* IF ChildWinDefault *)
    ELSE BEGIN
      Top := ChildTop; Left := ChildLeft;
      Height := ChildHeight; Width := ChildWidth;
    END (* ELSE *);
  END (* WITH *);

  Pfadname := cNamenVorgabe + ' ' + IntToStr (LRFrame.Zaehler);
  Caption := Pfadname; (* Steht nicht im Handbuch? *)
  IsoAnzeige := LRFrame.Konfig.IsoAnzeigen;
  IF LRFrame.Konfig.AutoSaveAbfrage THEN
    AutoSave := MessageDlg ('Text alle ' + IntToStr (LRFrame.Konfig.saveIntervall) +
                            ' Sekunden sichern?', mtConfirmation,
                     [mbYes, mbNo], 0) = id_Yes
  ELSE
    AutoSave := LRFrame.Konfig.saveIntervall > 0;

//showMessage ('ZeichenAufSeite: ' + IntToStr (LRFrame.Konfig.ZeichenAufSeite));
  ZeichenProSeite := LRFrame.Konfig.ZeichenAufSeite;
//showMessage ('ZeichenProSeite: ' + IntToStr (ZeichenProSeite));
  Editor.WordWrap := LRFrame.Konfig.WortUmbruch;
  {Editor.MaxLength := LRFrame.Konfig.MaxTextLaenge;}
  Editor.MaxLength := 0;

  Editor.RegisterConversionFormat ('dos', TDOSConversion);
  Editor.RegisterConversionFormat ('asc', TDOSConversion);
  Editor.RegisterConversionFormat ('tmp', TDOSConversion);
  Editor.RegisterConversionFormat ('sys', TDOSConversion);
  Editor.RegisterConversionFormat ('bat', TDOSConversion);
  Editor.RegisterConversionFormat ('xps', TDOSConversion);
  {Editor.RegisterConversionFormat ('tmp', TMausConversion);}
  Editor.RegisterConversionFormat ('mac', TMacConversion);
  Editor.RegisterConversionFormat ('mrf', TMacConversion);
  TextMakroEditiert := FALSE;
  TextMakroListe := TStringList.Create;
  IF FileExists (ChangeFileExt (Application.Exename, '.MAK')) THEN
    TextMakroListe.LoadFromFile (ChangeFileExt (Application.Exename, '.MAK'))
  ELSE
    FOR i := 0 TO 9 DO
      TextMakroListe.Add ('');

  LRFrame.FUpdating := TRUE;
  GetFontNames;
  LinealEinrichten;
  Lineal.Visible := LRFrame.Konfig.LinealAnzeigen;
  SaveFileDialog.FilterIndex := LRFrame.Konfig.DateiFilterIndex;
{$IFDEF Explorer}
  Hypertext := NIL; Hypertextp := NIL; Hypertextb := NIL;
{$ENDIF}
  WITH LRFrame DO BEGIN
    IF {ActiveMDIChild = NIL} NOT SpeedSpeichern.Enabled THEN BEGIN
//      SpeedButtonHTMLBody.Enabled := TRUE;
      SpeedButtonHorLine.Enabled := TRUE;
      SpeedButtonAbsatz.Enabled := TRUE;
      SpeedButtonBreak.Enabled := TRUE;
      SpeedButtonFonttag.Enabled := TRUE;
      SpeedButtonAttrtag.Enabled := TRUE;
      SpeedButtonKonvertiere.Enabled := TRUE;
      SpeedButtonAbsaetze.Enabled := TRUE;
      SpeedButtonLinks.Enabled := TRUE;
      SpeedButtonSelLinks.Enabled := TRUE;
      SpeedButtonNoframes.Enabled := TRUE;
      SpeedButtonTagselect.Enabled := TRUE;
      SpeedButtonRemoveTags.Enabled := TRUE;
      SpeedButtonSyntax.Enabled := TRUE;
      SpeedButtonRekonvertiere.Enabled := TRUE;
      SpeedButtonHTMLInsert.Enabled := TRUE;
      SpeedButtonGrafik.Enabled := TRUE;
      SpeedButtonLink.Enabled := TRUE;
      SpeedButtonZiel.Enabled := TRUE;
      SpeedButtonHeadline.Enabled := TRUE;

      SpeedSpeichern.Enabled := TRUE;
      SpeedSchliessen.Enabled := TRUE;
      SpeedSuchliste.Enabled := TRUE;
      SpeedSuchen.Enabled := TRUE;
      SpeedErsetzen.Enabled := TRUE;
      SpeedCut.Enabled := TRUE;
      SpeedKopieren.Enabled := TRUE;
      SpeedEinfuegen.Enabled := TRUE;
      SpeedLoeschen.Enabled := TRUE;
      SpeedEinstellungen.Enabled := TRUE;
      SpeedFonts.Enabled := TRUE;
      SpeedDrucken.Enabled := TRUE;
//      SpeedHighlight.Enabled := TRUE;
      SpeedUndo.Enabled := TRUE;
      SpeedFett.Enabled := TRUE;
      SpeedKursiv.Enabled := TRUE;
      SpeedUnter.Enabled := TRUE;
      SpeedLinks.Enabled := TRUE;
      SpeedMitte.Enabled := TRUE;
      SpeedRechts.Enabled := TRUE;
      SpeedPunkte.Enabled := TRUE;
      FontNamen.Visible := TRUE;
      FontGroesse.Visible := TRUE;
      FontGroesseUpDown1.Visible := TRUE;
    END (* IF *);
  END (* WITH *);
end;

procedure TEditForm.AlignClick(Sender: TObject);
begin
  Links1.Checked := FALSE;
  Links2.Checked := FALSE;
  Rechts1.Checked := FALSE;
  Rechts2.Checked := FALSE;
  Zentrieren1.Checked := FALSE;
  Zentrieren2.Checked := FALSE;
  WITH Sender as TMenuItem do
   Checked := TRUE;
    WITH Editor.Paragraph DO BEGIN
      IF Links1.Checked OR Links2.Checked THEN
        Alignment := taLeftJustify
      ELSE IF Rechts1.Checked OR Rechts2.Checked THEN
        Alignment := taRightJustify
      ELSE IF Zentrieren1.Checked OR Zentrieren2.Checked THEN
        Alignment := taCenter;
    END (* WITH Editor *);
  END;

procedure TEditForm.Zeilenumbruch1Click(Sender: TObject);
begin
  WITH Editor DO BEGIN
    WordWrap := NOT WordWrap;
    IF WordWrap THEN
      Scrollbars := ssVertical
    ELSE
      Scrollbars := ssBoth;
    Zeilenumbruch1.Checked := WordWrap;
  END (* WITH *);
end;

procedure TEditForm.AllesAuswaehlen(Sender: TObject);
begin
  Editor.SelectAll;
end;

procedure TEditForm.Ausschneiden(Sender: TObject);
begin
  Editor.CutToClipboard;
end;

procedure TEditForm.Kopieren(Sender: TObject);
begin
  Editor.CopyToClipboard;
end;

procedure TEditForm.Einfuegen(Sender: TObject);
begin
  Editor.PasteFromClipboard;
end;

procedure TEditForm.Loeschen(Sender: TObject);
begin
  Editor.ClearSelection;
end;

procedure TEditForm.Bearbeiten1Click(Sender: TObject);
VAR HasSelection: Boolean;
begin
  Einfuegen1.Enabled := Clipboard.HasFormat (CF_TEXT);
  HasSelection := Editor.SelLength > 0;
  Ausschneiden1.Enabled := HasSelection;
  Kopieren1.Enabled := HasSelection;
  Loeschen1.Enabled := HasSelection;
  Einfuegen2.Enabled := Clipboard.HasFormat (CF_TEXT);
  Ausschneiden2.Enabled := HasSelection;
  Kopieren2.Enabled := HasSelection;
  Loeschen2.Enabled := HasSelection;
end;

procedure TEditForm.Schriftart1Click(Sender: TObject);
begin
  FontDialog1.Font.Assign (Editor.SelAttributes);
  IF FontDialog1.Execute THEN
    Editor.SelAttributes.Assign (FontDialog1.Font);
end;

procedure TEditForm.Oeffnen1Click(Sender: TObject);
begin
  LRFrame.Oeffnen1Click (Sender);
end;

procedure TEditForm.Open (Const AFileName: String);
BEGIN
  PfadName := AFileName;
  {Caption := ExtractFileName (AFileName);}
  Caption := PfadName;

  IF FileExists (ChangeFileExt (PfadName, '.MAK')) THEN BEGIN
    TextMakroListe.LoadFromFile (ChangeFileExt (PfadName, '.MAK'));
    TextMakroEditiert := FALSE;
  END (* IF Makrofile *);
  
  WITH Editor DO BEGIN
    PlainText := (AnsiUpperCase (ExtractFileExt (PfadName)) <> '.RTF') AND
                 (AnsiUpperCase (ExtractFileExt (Pfadname)) <> '.MRF') AND
                 (AnsiUpperCase (ExtractFileExt (Pfadname)) <> '.MED');
    Lines.LoadFromFile (PfadName);
    SelStart := 0;
    Modified := FALSE;
  END (* WITH *);
  CursorDaten (Self);
END (* Open *);

procedure TEditForm.Speichern1Click(Sender: TObject);
VAR BackUpDateiname: STRING;
    Index:           Integer;
    FilterFile:      TextFile;
CONST BackUpExt = '.BAK';
begin
  IF Pos (cNamenVorgabe, PfadName) = 1 THEN
    SpeichernUnter1Click (Sender)
  ELSE BEGIN
    Editor.PlainText := (AnsiUpperCase (ExtractFileExt (PfadName)) <> '.RTF') AND
                        (AnsiUpperCase (ExtractFileExt (Pfadname)) <> '.MRF') AND
                        (AnsiUpperCase (ExtractFileExt (Pfadname)) <> '.MED');
    IF LRFrame.Konfig.BAKErstellen THEN BEGIN
      BackUpDateiname := ChangeFileExt (PfadName, BackupExt);
      DeleteFile (BackUpDateiname);
      RenameFile (PfadName, BackUpDateiname);
    END (* IF BAKErstellen *);
    Editor.Lines.SaveToFile (PfadName);
    Editor.Modified := FALSE;

    (* Wenn es eine History-Datei war, diese aktualisieren, sonst nichts tun: *)
    IF PfadName = ChangeFileExt (Application.Exename, '.his') THEN BEGIN
      WITH LRFrame DO
        HistoryListe.LoadFromFile (ChangeFileExt (Application.Exename, '.his'));
      Exit;
    END;

    (* Wenn es eine Favorite-Datei war, diese aktualisieren, sonst nichts tun: *)
    IF PfadName = ChangeFileExt (Application.Exename, '.fav') THEN BEGIN
      WITH LRFrame DO
        FavouriteListe.LoadFromFile (ChangeFileExt (Application.Exename, '.fav'));
      Exit;
    END;

    (* Wenn es eine Filter-Datei war, diese aktualisieren, sonst nichts tun: *)
    IF PfadName = ChangeFileExt (Application.Exename, '.fil') THEN BEGIN
      WITH LRFrame DO BEGIN
        IF FileExists (ChangeFileExt (Application.Exename, '.FIL')) THEN BEGIN
          AssignFile (FilterFile, ChangeFileExt (Application.Exename, '.FIL'));
          Reset (FilterFile);
          Read (FilterFile, Dateifilter);
          CloseFile (FilterFile);
        END
        ELSE Dateifilter := '';
      END (* WITH *);
      Exit;
    END (* IF *);

    (* Bei anderen Dateien - auer .TMP - die History-Liste aktualisieren: *)
    WITH LRFrame.HistoryListe DO BEGIN
      IF (NOT (AnsiUpperCase (ExtractFileExt (PfadName)) = '.TMP')) THEN BEGIN
        Index := IndexOf (PfadName);
        IF Index <> -1 THEN Delete (Index);
        IF Count > 0 THEN
          WHILE Count >= LRFrame.Konfig.MaxHistory Do Delete (Count - 1);
        IF LRFrame.Konfig.MaxHistory > 0 THEN Insert (0, PfadName);
      END (* IF neu aufnehmen *);
    END (* WITH *);

  END (* ELSE *);
  CursorDaten (Sender);
end (* Speichern1Click *);

procedure TEditForm.SpeichernUnter1Click(Sender: TObject);
VAR mr:           TModalResult;
    Verzeichnis:  String;
begin
  IF FMyDateiManager = NIL THEN BEGIN
//    FMyDateiManager := TDateiManagerForm.Create (Self);
    FMyDateiManager := TDateiManagerForm.ECreate (Self, TRUE, 'Textdatei speichern unter',
      'Text speichern', PfadName, Copy (ExtractFileExt (PfadName), 2, 10), 0, FALSE, FALSE, TRUE, TRUE);
  END (* IF *);
  WITH FMyDateiManager AS TDateiManagerForm DO BEGIN
    MyEditor := Self;
//    Caption := 'Textdatei speichern';
{    IF NOT NameSet THEN BEGIN
      ComboBoxDateiauswahlHistory.Text := PfadName;
      NameSet := TRUE;
    END;
}
    IF NOT visible THEN mr := ShowModal ELSE mr := mrNone;
    IF mr = mrOK THEN BEGIN
      PfadName := DateiAuswahl;
//showMessage (PfadName);
      LRFrame.Konfig.DateiFilterIndex := FilterIndex;
      IF ExtractFileDir (PfadName) = '' THEN BEGIN
        Verzeichnis := VerzeichnisStruktur.Directory;
        IF Verzeichnis [Length (Verzeichnis)] <> '\' THEN
          Verzeichnis := Verzeichnis + '\';
        PfadName := Verzeichnis + PfadName;
      END (* IF kein Pfad *);
      IF (DateiFilterComboBox.Mask <> '*.*') AND
         (ExtractFileExt (PfadName) = '') AND
         (ExtractFileExt (PfadName) <> ExtractFileExt (DateiFilterComboBox.Mask)) THEN
        PfadName := PfadName + ExtractFileExt (DateiFilterComboBox.Mask);
      Self.Caption := (* ExtractFileName (*)PfadName(*)*);
      {LRFrame.DateiFilterIndex := SaveFileDialog.FilterIndex;}
      NameSet := FALSE;
      Speichern1Click (Sender);
    END (* IF mr = mrOK *);
  END (* WITH *);
end (* SpeichernUnter1Click *);

procedure TEditForm.Druckereinrichtung1Click(Sender: TObject);
begin
  PrinterSetupDialog1.Execute;
end;

procedure TEditForm.Drucken1Click(Sender: TObject);
begin
  IF Editor.SelLength > 0 THEN BEGIN
    PrintDialog1.Options := [poSelection];
    PrintDialog1.PrintRange := prSelection;
  END
  ELSE BEGIN
    PrintDialog1.Options := [];
    PrintDialog1.PrintRange := prAllPages;
  END;
  IF PrintDialog1.Execute THEN
    IF PrintDialog1.PrintRange = prSelection THEN BEGIN
      With TEditForm.Create (LRFrame) DO BEGIN
        AutoSave := FALSE;
        Caption := 'Block aus "' + PfadName + '" drucken';
        Editor.SelText := Self.Editor.SelText;
        Editor.Modified := FALSE;
        Editor.Print (PfadName);
        Close;
      END (* WITH *);
    END
  ELSE
    Editor.Print (PfadName);
{
  IF PrintDialog1.Execute THEN BEGIN
    Printer.BeginDoc;
    try
      Editor.Print (PfadName);
    finally
      Printer.EndDoc;
    END;
  END;
}
end;

procedure TEditForm.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
CONST Warntext = 'nderungen in %s speichern?';
begin
  IF NOT FensterSchliessen THEN BEGIN
    CanClose := TRUE; EXIT;
  END; 
  BringToFront;
  IF Editor.Modified THEN BEGIN
    IF SpeicherAbfrage = FALSE THEN BEGIN
      Speichern1Click (Self); EXIT;
    END;
    CASE MessageDlg (Format (Warntext, [PfadName]), mtConfirmation,
                     [mbYes, mbNo, mbCancel], 0)
      OF
        id_Yes: Speichern1Click (Self);
        id_Cancel: CanClose := FALSE;
    END (* CASE *);
  END (* IF *);
end;

procedure TEditForm.Suchen1Click(Sender: TObject);
begin
  WITH Owner AS TLRFrame DO
    FindDialog1.Execute;
end;

procedure TEditForm.Ersetzen1Click(Sender: TObject);
begin
  WITH Owner AS TLRFrame DO
    ReplaceDialog1.Execute
end;

procedure TEditForm.Activate(Sender: TObject);
begin
  {Editor.MaxLength := High (Integer) - 1024;}
  Editor.MaxLength := LRFrame.Konfig.MaxTextLaenge;

  CursorDaten (Sender);
  SpeicherAbfrage := TRUE;
  IF LRFrame.DefaultFont <> NIL THEN Editor.Font.Assign (LRFrame.DefaultFont)
  ELSE ShowMessage ('Kein DefaultFont');

  IF TextFormatDialog <> NIL THEN BEGIN
//showMessage ('TextFormatDialog.updateEinstellungen;');
    TextFormatDialog.updateEinstellungen;
//showMessage ('Update fertig');    
  END (* IF *);
end;

procedure TEditForm.UeberLittleRichard2Click(Sender: TObject);
begin
  LRFrame.UeberLittleRichard1Click (Sender);
end;

procedure TEditForm.CursorDaten(Sender: TObject);

VAR Zch:         Char;
    Seite:       Integer;

    ASCIIStr:    String [40];
    CursorName:  String [10];

begin
  IF dontShow THEN EXIT;
  TagSelected := FALSE;
  IF Editor.Modified THEN BEGIN
    Geaendert.Caption := 'Verndert ';
    Geaendert.Font.Color := clRed;
  END
  ELSE BEGIN
    Geaendert.Caption := 'Gesichert ';
    Geaendert.Font.Color := clGreen;
  END;

{ Nachtrag: Ich habe am 5. 4. 97 entdeckt, da man einfach direkt auf die
  Property "Text" eines TRichEdit zugreifen kann - ist aber in der Online-
  Hile nicht zu finden (?), auer als Verweis bei "Lines".
  Das erspart natrlich das zeitraubende Kopieren!
  -- andererseits scheinen solche Zugriffe an sich sehr ineffizient!!! }

  IF IsoAnzeige THEN BEGIN

    IF Editor.GetTextLen > 0 THEN Zch := Editor.Text [Editor.SelStart]
    Else Zch := #0;

    ASCIIStr := ' Zeichen [' + IntToStr (ORD (Zch)) + ']:';

  END
  ELSE ASCIIStr := '';

  IF CursInsert THEN BEGIN
    CursorName := ' Einf: ';
    SetCaretBlinkTime (cInsertBlink);
  END
  ELSE BEGIN
    CursorName := ' ber: ';
    SetCaretBlinkTime (cOverBlink);
  END;
  {Statusleiste.Panels.Items [0].Text}
//showMessage ('Zeichen pro Seite: ' + IntToStr (ZeichenProSeite));
   Seite := (Editor.SelStart + 1) DIV ZeichenProSeite + 1;
   CursorLabel.Caption :=

   'Spa: ' + IntToStr (Column) +
   '  Zei: ' + IntToStr (Row) +
   '  Sei: ' + IntToStr (Seite) +

   ASCIIStr + CursorName +
   {Format ('%10d', [Editor.SelStart]) +}
   IntToStr (Editor.SelStart + 1) +
   '  Block: ' +
   {Format ('%10d', [Editor.SelLength]);}
   IntToStr (Editor.SelLength) +
   '  Zchn: ' + IntToStr (Editor.GetTextLen) +
   {Format ('%10d', [Editor.GetTextLen]) +}
   '  Zln: ' + IntToStr (Editor.Lines.Count);
  {StrDispose (Zeichen);}

  (* Lineal *)

  WITH Editor.Paragraph DO
    Try
      LRFrame.FUpdating := TRUE;
      ErsteZeileEinrueckung.Left := Trunc (FirstIndent * RulerAdj) - 4 + GutterWid;
      LinkeEinrueckung.Left := Trunc ((LeftIndent + FirstIndent) * RulerAdj) - 4 + GutterWid;
      RechteEinrueckung.Left := Lineal.ClientWidth - 6 - Trunc ((RightIndent + GutterWid) * RulerAdj);
      LRFrame.FontGroesse.Text := IntToStr (Editor.SelAttributes.Size);
      LRFrame.FontNamen.Text := Editor.SelAttributes.Name;
      LRFrame.SpeedFett.Down := fsBold in Editor.SelAttributes.Style;
      LRFrame.SpeedKursiv.Down := fsItalic in Editor.SelAttributes.Style;
      LRFrame.SpeedUnter.Down := fsUnderline in Editor.SelAttributes.Style;
      CASE ORD (Alignment) OF
        0: LRFrame.SpeedLinks.Down := TRUE;
        1: LRFrame.SpeedRechts.Down := TRUE;
        2: LRFrame.SpeedMitte.Down := TRUE;
      END (* CASE *);
    Finally
      LRFrame.FUpdating := FALSE;
    END;
end (* CursorDaten *);

procedure TEditForm.EditoreinstellungenClick(Sender: TObject);
begin
  IF TextFormatDialog = NIL THEN
    TextFormatDialog := TTextFormatDialog.Create (Editor)
  ELSE BEGIN
    TextFormatDialog.Visible := TRUE;
    TextFormatDialog.BringToFront;
  END;
end;

procedure TEditForm.EditorKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);

// VAR ScrollV: TWMVScroll;

begin
  IF (Shift = []) AND (Key = VK_Insert) THEN BEGIN
     {CreateCaret (Editor.Handle, 1, 1, 13);}
     CursInsert := NOT CursInsert;
     CursorDaten (Sender);
{     IF CursInsert THEN BEGIN
       CursInsert := FALSE; CursorDaten (Sender);
     END
     ELSE BEGIN
       CursInsert := TRUE; CursorDaten (Sender);
     END;}
     {ShowCaret (Editor.Handle);}
  END
  ELSE
  IF Shift = [ssShift] THEN
    WITH LRFrame DO
    CASE Key OF
      VK_F1: Editor.SelText := TextMakroListe.Strings [0];
      VK_F2: Editor.SelText := TextMakroListe.Strings [1];
      VK_F3: Editor.SelText := TextMakroListe.Strings [2];
      VK_F4: Editor.SelText := TextMakroListe.Strings [3];
      VK_F5: Editor.SelText := TextMakroListe.Strings [4];
      VK_F6: Editor.SelText := TextMakroListe.Strings [5];
      VK_F7: Editor.SelText := TextMakroListe.Strings [6];
      VK_F8: Editor.SelText := TextMakroListe.Strings [7];
      VK_F9: Editor.SelText := TextMakroListe.Strings [8];
      VK_F10: Editor.SelText := TextMakroListe.Strings [9];
    END (* CASE *)
  ELSE IF (Shift = [ssAlt]) {AND (Key = VK_X)} THEN BEGIN
    CASE Key OF
{      VK_X: BEGIN
              SpeicherAbfrage := FALSE;
              WITH Owner AS TLRFrame DO Close;
            END;
}
      VK_Up: BEGIN  SendMessage (Editor.Handle, EM_SCROLL, SB_LINEUP, 0);
             END;
      VK_Down: BEGIN SendMessage (Editor.Handle, EM_SCROLL, SB_LINEDOWN, 0);
               END;

    END (* CASE *);
  END (* ELSE *);
end;

procedure TEditForm.EditorKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  IF Shift = [ssCtrl] THEN
    WITH LRFrame DO
    CASE Key OF
      (*Sems Return - Einfgen nach! CR*)
      VK_RETURN: BEGIN
                   Editor.SelText := ':';
                 END;
    END (* CASE *);
end;

procedure TEditForm.FormDestroy(Sender: TObject);
VAR   i:     Integer;
      count: Integer;
begin
  WITH Editor DO BEGIN
//showMessage ('Componentcount: ' + IntToStr (ComponentCount));
    FOR i := 0 TO ComponentCount - 1 DO BEGIN
      showMessage (Components [i].Name);
    END (* FOR *);
    DestroyComponents;
  END (* WITH *);

  IF TextMakroEditiert THEN
    TextMakroListe.SaveToFile (ChangeFileExt (Pfadname, '.MAK'));
  TextMakroListe.Free;
{$IFDEF Explorer}
  IF Hypertext <> NIL THEN Hypertext.SourceEditor := NIL;
  IF Hypertextp <> NIL THEN Hypertextp.EventProtokoll := NIL;
  IF Hypertextb <> NIL THEN Hypertextb.BefehlsProtokoll := NIL;
{$ENDIF}
  WITH LRFrame DO BEGIN
    IF ShutDown THEN EXIT;
    IF MDIChildCount <=1 THEN BEGIN
      SpeedSchliessen.Enabled := FALSE;
    END;
    count := 0;
    FOR i := 0 TO MDIChildCount-1 DO BEGIN
      IF MDIChildren [i] is TEditForm THEN INC (count);
    END (* FOR *);
    IF {MDIChild}Count <=1 THEN BEGIN
      SpeedSpeichern.Enabled := FALSE;
//      SpeedSchliessen.Enabled := FALSE;
//      SpeedButtonHTMLBody.Enabled := FALSE;
      SpeedButtonHorLine.Enabled := FALSE;
      SpeedButtonAbsatz.Enabled := FALSE;
      SpeedButtonBreak.Enabled := FALSE;
      SpeedButtonFonttag.Enabled := FALSE;
      SpeedButtonAttrtag.Enabled := FALSE;
      SpeedButtonKonvertiere.Enabled := FALSE;
      SpeedButtonAbsaetze.Enabled := FALSE;
      SpeedButtonLinks.Enabled := FALSE;
      SpeedButtonSelLinks.Enabled := FALSE;
      SpeedButtonNoframes.Enabled := FALSE;
      SpeedButtonTagselect.Enabled := FALSE;
      SpeedButtonRemoveTags.Enabled := FALSE;
      SpeedButtonSyntax.Enabled := FALSE;
      SpeedButtonRekonvertiere.Enabled := FALSE;
      SpeedButtonHTMLInsert.Enabled := FALSE;
      SpeedButtonGrafik.Enabled := FALSE;
      SpeedButtonLink.Enabled := FALSE;
      SpeedButtonZiel.Enabled := FALSE;
      SpeedButtonHeadline.Enabled := FALSE;

      SpeedSuchliste.Enabled := FALSE;
      SpeedSuchen.Enabled := FALSE;
      SpeedErsetzen.Enabled := FALSE;
      SpeedCut.Enabled := FALSE;
      SpeedKopieren.Enabled := FALSE;
      SpeedEinfuegen.Enabled := FALSE;
      SpeedLoeschen.Enabled := FALSE;
      SpeedEinstellungen.Enabled := FALSE;
      SpeedFonts.Enabled := FALSE;
      SpeedDrucken.Enabled := FALSE;
//      SpeedHighlight.Enabled := FALSE;
      SpeedUndo.Enabled := FALSE;
      SpeedFett.Enabled := FALSE;
      SpeedKursiv.Enabled := FALSE;
      SpeedUnter.Enabled := FALSE;
      SpeedLinks.Enabled := FALSE;
      SpeedMitte.Enabled := FALSE;
      SpeedRechts.Enabled := FALSE;
      SpeedPunkte.Enabled := FALSE;
      FontNamen.Visible := FALSE;
      FontGroesse.Visible := FALSE;
      FontGroesseUpDown1.Visible := FALSE;
    END;
  END (* WITH LRFrame *);
//showMessage ('FormDestroy - FMyDateiManager.Release');
  IF FMyDateiManager <> NIL THEN FMyDateiManager.Release;
  IF TextFormatDialog <> NIL THEN TextFormatDialog.Close;
end (* FormDestroy *);

procedure TEditForm.GlobalEinstellungenClick(Sender: TObject);
begin
  LRFrame.GlobalEinstellungenClick (Sender);
end;

procedure TEditForm.History1Click(Sender: TObject);
VAR i: Integer;
    menitem: TMenuItem;
begin
{  i := History1.Count;
  WHILE (History1.Items [i - 1].Caption <> '-') DO BEGIN
    DEC (i); History1.Delete (i);
  END (* WHILE *);

  FOR i := 0 TO LRFrame.HistoryListe.Count - 1 DO BEGIN
    menitem := TMenuItem.Create (PopupMenu1);
    WITH menitem DO BEGIN
      Caption := LRFrame.HistoryListe.Strings [i];
      OnClick := LRFrame.DateiMenuEndeClick;
    END (* WITH *);
    History1.Add (menitem);
  END (* FOR *);}
end;

procedure TEditForm.FormResize(Sender: TObject);
begin
  IF NOT Visible THEN EXIT;
    (* Sonst gibt es Nebeneffekte beim Verstellen einzelner Parameter in
       FormCreate! *)
  WITH LRFrame.DefaultWindow DO BEGIN
    IF WindowState <> wsMinimized THEN ChildWin := WindowState;
    ChildTop := Top; ChildLeft := Left;
    ChildHeight := Height; ChildWidth := Width;
  END;
  CursorDaten (Sender);
end;

procedure TEditForm.AlleSchliessenClick(Sender: TObject);
begin
  LRFrame.AlleSchliessen;
end;

procedure TEditForm.AlleMinimierenClick(Sender: TObject);
VAR i: Integer;
begin
  WITH LRFRame DO BEGIN
    FOR i := 0 TO MDIChildCount - 1 DO BEGIN
      IF MDIChildren [i] IS TEditForm THEN
        WITH MDIChildren [0] AS TEditForm DO
          Minimieren1Click (Sender);
    END (* FOR *);
  END (* WITH LRFrame *);
end;

procedure TEditForm.AlleSpeichernClick(Sender: TObject);
VAR i: Integer;
begin
  WITH LRFRame DO BEGIN
    FOR i := 0 TO MDIChildCount - 1 DO BEGIN
      IF MDIChildren [i] IS TEditForm THEN
        WITH MDIChildren [i] AS TEditForm DO
          Speichern1Click (Sender);
    END (* FOR *);
  END (* WITH LRFrame *);
end;

procedure TEditForm.LinealResize(Sender: TObject);
begin
  LinealLinie.Width := Lineal.ClientWidth - (LinealLinie.Left * 2);
end;

procedure TEditForm.LinealElementMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
  (* diese Prozeduren fr alle Linealelemente *)
begin
  FDragOfs := (TLabel (Sender).Width div 2);
  TLabel (Sender).Left := TLabel (Sender).Left + X - FDragOfs;
  FDragging := True;
end;

procedure TEditForm.LinealElementMouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
  (* diese Prozeduren fr alle Linealelemente *)
begin
  IF FDragging THEN
    TLabel (Sender).Left := TLabel (Sender).Left + X - FDragOfs;
end;

procedure TEditForm.LinkeEinrueckungMouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  FDragging := FALSE;
  Editor.Paragraph.LeftIndent := Trunc ((LinkeEinrueckung.Left + FDragOfs - GutterWid) /
    RulerAdj) - Editor.Paragraph.FirstIndent;
    {SelectionChange (Sender);}
    CursorDaten (Sender);
end;

procedure TEditForm.ErsteZeileEinrueckungMouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  FDragging := FALSE;
  Editor.Paragraph.FirstIndent := Trunc ((ErsteZeileEinrueckung.Left + FDragOfs - GutterWid) /
    RulerAdj);
  LinkeEinrueckungMouseUp (Sender, Button, Shift, X, Y);
end;

procedure TEditForm.RechteEinrueckungMouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  FDragging := FALSE;
  Editor.Paragraph.RightIndent :=
    Trunc ((Lineal.ClientWidth - RechteEinrueckung.Left + FDragOfs -2) / RulerAdj)
      -2 * GutterWid;
  CursorDaten (Sender);
end;

procedure TEditForm.Rueckgaengig1Click(Sender: TObject);
begin
  WITH Editor DO
    IF HandleAllocated THEN SendMessage (Handle, EM_UNDO, 0, 0);
end;

procedure TEditForm.AlleOeffnen1Click(Sender: TObject);
begin
  LRFrame.AlleOeffnen1Click (Sender);
end;

procedure TEditForm.Nebeneinander1Click(Sender: TObject);
begin
  LRFrame.Nebeneinander1Click (Sender);
end;

procedure TEditForm.Ueberlappend1Click(Sender: TObject);
begin
  LRFrame.UeberlappendClick (Sender);
end;

procedure TEditForm.Symboleanordnen1Click(Sender: TObject);
begin
  LRFrame.Symboleanordnen1Click (Sender);
end;

procedure TEditForm.HistoryListe2Click(Sender: TObject);
begin
  LRFrame.HistoryListe2Click (Sender);
end;

procedure TEditForm.HistoryListe1Click(Sender: TObject);
VAR i: Integer;
    menitem: TMenuItem;
CONST cBreak =  30;
begin
{  i := History1.Count;
  WHILE (History1.Items [i - 1].Caption <> '-') DO BEGIN
    DEC (i); History1.Delete (i);
  END (* WHILE *);

  i := History2.Count;
  WHILE (History2.Items [i - 1].Caption <> '-') DO BEGIN
    DEC (i); History2.Delete (i);
  END (* WHILE *);

  FOR i := 0 TO LRFrame.HistoryListe.Count - 1 DO BEGIN
    IF (i + 1) MOD cBreak = 0 THEN BEGIN
      menitem := TMenuItem.Create (PopupMenu1);
      menitem.break := mbBarBreak;
      History2.Add (menitem);
      menitem := TMenuItem.Create (TextMenu);
      menitem.break := mbBarBreak;
      History1.Add (menitem);
    END (* IF *);

    menitem := TMenuItem.Create (PopupMenu1);
    WITH menitem DO BEGIN
      Caption := LRFrame.HistoryListe.Strings [i];
      OnClick := LRFrame.DateiMenuEndeClick;
    END (* WITH *);
    History1.Add (menitem);

    menitem := TMenuItem.Create (TextMenu);
    WITH menitem DO BEGIN
      Caption := LRFrame.HistoryListe.Strings [i];
      OnClick := LRFrame.DateiMenuEndeClick;
    END (* WITH *);
    History2.Add (menitem);
  END (* FOR *);
}
end;

procedure TEditForm.DruckeFenster1Click(Sender: TObject);
begin
  Print;
end;

procedure TEditForm.Zeichen1Click(Sender: TObject);
begin
  Links1.Checked := FALSE; Links2.Checked := FALSE;
  Rechts1.Checked := FALSE; Rechts2.Checked := FALSE;
  Zentrieren1.Checked := FALSE; Zentrieren2.Checked := FALSE;
  WITH Editor.Paragraph DO BEGIN
    CASE Alignment OF
      taLeftJustify: BEGIN Links1.Checked := TRUE; Links2.Checked := TRUE;
                     END;
      taRightJustify: BEGIN Rechts1.Checked := TRUE; Rechts2.Checked := TRUE;
                      END;
      taCenter:      BEGIN Zentrieren1.Checked := TRUE; Zentrieren2.Checked := TRUE;
                     END;
    END (* CASE *);
    Zeilenumbruch1.Checked := Editor.WordWrap;
    Zeilenumbruch2.Checked := Editor.WordWrap;
  END (* WITH *);
end;

procedure TEditForm.PopupMenu1Popup(Sender: TObject);
begin
  HistoryListe1Click (Sender);
  Bearbeiten1Click (Sender);
end;

procedure TEditForm.Objekteinfuegen1Click(Sender: TObject);
VAR OleContainer: TOleContainer;
begin
  {OleContainer := TOleContainer.Create (Editor);}
  OleContainer := TOleContainer.Create (Self);
  WITH OleContainer DO BEGIN
    Enabled := TRUE;
    Dragmode := dmAutomatic;
    Align := alNone;
    SizeMode := smAutoSize;
    Parent := Editor;
    BorderStyle := bsSingle;
    Cursor := crUpArrow;
    IF InsertObjectDialog THEN BEGIN
      {Editor.InsertControl (OleContainer);}
      OleContainer.Visible := TRUE;
      {AutoActivate := aaGetFocus;}
      DoVerb (PrimaryVerb)
    END
    ELSE OleContainer.Destroy;
  END (* WITH *);
end;

procedure TEditForm.EditorEndDrag(Sender, Target: TObject; X, Y: Integer);
begin
  IF Target <> NIL THEN Update;
end;

procedure TEditForm.EditorDragOver(Sender, Source: TObject; X, Y: Integer;
  State: TDragState; var Accept: Boolean);
begin
  IF Source is TOleContainer THEN Accept := TRUE;
end;

procedure TEditForm.EditorDragDrop(Sender, Source: TObject; X, Y: Integer);
begin
  IF Source is TOleContainer THEN BEGIN
    WITH Source as TOleContainer DO BEGIN
      Left := X; Top := Y;
    END (* WITH *);
  END;
end;

procedure TEditForm.MaximaleTextlaenge1Click(Sender: TObject);
begin
  showMessage ('Maximale Textlnge: ' + IntToStr (Editor.MaxLength));
end;

procedure TEditForm.SpeedButtonSelectAllClick(Sender: TObject);
begin
  IF Editor.SelLength = 0 THEN
    Editor.SelectAll
  ELSE Editor.SelLength := 0;
end;

procedure TEditForm.Favorites1Click(Sender: TObject);
VAR i: Integer;
    menitem: TMenuItem;
begin
  i := Favorites1.Count;
  WHILE (Favorites1.Items [i - 1].Caption <> '-') DO BEGIN
    DEC (i); Favorites1.Delete (i);
  END (* WHILE *);

  i := Favorites2.Count;
  WHILE (Favorites2.Items [i - 1].Caption <> '-') DO BEGIN
    DEC (i); Favorites2.Delete (i);
  END (* WHILE *);

  FOR i := 0 TO LRFrame.FavouriteListe.Count - 1 DO BEGIN
    menitem := TMenuItem.Create (PopupMenu1);
    WITH menitem DO BEGIN
      Caption := Copy (LRFrame.FavouriteListe.Strings [i], 1, Pos ('/', LRFrame.FavouriteListe.Strings [i]) - 1);
      OnClick := LRFrame.FavoritesClick;
    END (* WITH *);
    Favorites1.Add (menitem);

    menitem := TMenuItem.Create (Textmenu);
    WITH menitem DO BEGIN
      Caption := Copy (LRFrame.FavouriteListe.Strings [i], 1, Pos ('/', LRFrame.FavouriteListe.Strings [i]) - 1);
      OnClick := LRFrame.FavoritesClick;
    END (* WITH *);
    Favorites2.Add (menitem);
  END (* FOR *);
end;

function TEditForm.AktuellesVerzeichnis: String;
begin
  Result := ExtractFilePath (PfadName) + '*' + ExtractFileExt (PfadName) +
                '/' + SaveFileDialog.Filter + '#' + IntToStr (SaveFileDialog.FilterIndex);
end (* AktuellesVerzeichnis *);

procedure TEditForm.AktuellesVerzeichnisaufnehmen1Click(Sender: TObject);
VAR Index: Integer;
begin
  IF PfadName = ChangeFileExt (Application.Exename, '.fav') THEN BEGIN
showmessage ('Lade Fav: ' + ChangeFileExt (Application.Exename, '.fav'));
    WITH LRFrame DO
      FavouriteListe.LoadFromFile (ChangeFileExt (Application.Exename, '.fav'));
  END
  ELSE
  WITH LRFrame.FavouriteListe DO BEGIN
      Index := IndexOf (AktuellesVerzeichnis);
      IF Index <> -1 THEN Delete (Index);
      IF Count > 0 THEN
        WHILE Count >= LRFrame.Konfig.MaxFavorite Do Delete (Count - 1);
//showmessage ('Add Fav: ' + PfadName);
      IF LRFrame.Konfig.MaxFavorite > 0 THEN
//        Insert (0, AktuellesVerzeichnis {ExtractFilePath (PfadName) + '*' + ExtractFileExt (PfadName) +
//                '/' + SaveFileDialog.Filter + '#' + IntToStr (SaveFileDialog.FilterIndex)});
        Add (AktuellesVerzeichnis);
  END (* WITH *);
end (* AktuellesVerzeichnisaufnehmen *);

procedure TEditForm.AktuellesVerzeichnisentfernen1Click(Sender: TObject);
VAR Index: Integer;
begin
  WITH LRFrame.FavouriteListe DO BEGIN
      Index := IndexOf (AktuellesVerzeichnis);
      IF Index <> -1 THEN Delete (Index);
  END (* WITH *);
end;

procedure TEditForm.Favoritesspeichern1Click(Sender: TObject);
VAR i: Integer;
    menitem: TMenuItem;
begin
  i := Favoritesspeichern1.Count;
  WHILE (Favoritesspeichern1.Items [i - 1].Caption <> '-') DO BEGIN
    DEC (i); Favoritesspeichern1.Delete (i);
  END (* WHILE *);

  i := Favoritenspeichern1.Count;
  WHILE (Favoritenspeichern1.Items [i - 1].Caption <> '-') DO BEGIN
    DEC (i); Favoritenspeichern1.Delete (i);
  END (* WHILE *);

  FOR i := 0 TO LRFrame.FavouriteListe.Count - 1 DO BEGIN
    menitem := TMenuItem.Create (PopupMenu1);
    WITH menitem DO BEGIN
      Caption := Copy (LRFrame.FavouriteListe.Strings [i], 1, Pos ('/', LRFrame.FavouriteListe.Strings [i]) - 1);
      OnClick := FavoritesClick;
    END (* WITH *);
    Favoritesspeichern1.Add (menitem);

    menitem := TMenuItem.Create (Textmenu);
    WITH menitem DO BEGIN
      Caption := Copy (LRFrame.FavouriteListe.Strings [i], 1, Pos ('/', LRFrame.FavoUriteListe.Strings [i]) - 1);
      OnClick := FavoritesClick;
    END (* WITH *);
    Favoritenspeichern1.Add (menitem);
  END (* FOR *);
end (* Favoritesspeichern1Click *);

procedure TEditForm.FavoritesClick (Sender: TObject);
VAR FavFilter: String;
    FavStart, FavEnd: Integer;
    FavStr:    String;
begin
  WITH Sender AS TMenuItem DO BEGIN
    SaveFileDialog.Title := 'Textdatei speichern';
    SaveFileDialog.InitialDir := ExtractFilePath (Caption);
//showMessage (Pfadname);
    SaveFileDialog.FileName := ExtractFilename (Pfadname);
    FavStr := LRFrame.FavouriteListe [MenuIndex - 3];
    FavStart := Pos ('/', FavStr);
    FavEnd := Pos ('#', FavStr);
    IF FavStart > 0 THEN
      FavFilter := Copy (FavStr, FavStart + 1, FavStart - FavEnd)
    ELSE FavFilter := LRFrame.DateiFilter;
//showMessage ('Fav: ' + FavStr + ', FS: ' + IntToStr (FavStart) + ', FE: ' + IntToStr (FavEnd));
    IF Favfilter <> '' THEN SaveFileDialog.Filter := Favfilter;
    IF FavEnd > 0 THEN
      SaveFileDialog.FilterIndex := StrToInt (Copy (FavStr, FavEnd + 1, Length (FavStr)))
    ELSE SaveFileDialog.FilterIndex := LRFrame.Konfig.DateiFilterIndex;
  END (* WITH *);
  IF SaveFileDialog.Execute THEN BEGIN
    PfadName := SaveFileDialog.FileName;
    Caption := {ExtractFileName (}PfadName{)};
    LRFrame.Konfig.DateiFilterIndex := SaveFileDialog.FilterIndex;
    Speichern1Click (Sender);
  END (* IF *);
END (* FavoritesClick *);

procedure TEditForm.FormShow(Sender: TObject);
begin
  LRFrame.FormShow (Sender);
end;

procedure TEditForm.HTMLBrowser1Click(Sender: TObject);
VAR  urlstr:   String;
begin
{$IFDEF Explorer}
  (* HTML-Code im WWW-Browser anschauen *)
  IF Hypertext = NIL THEN BEGIN
    Hypertext := TIExplorerForm.Create (Self);
    Hypertext.SourceEditor := SELF;
  END (* IF *);
  AlleSpeichernClick (Sender);
  urlstr := Pfadname;
//  IF (Length (urlstr) > 2) AND (urlstr [2] = ':') THEN
//    urlstr [2] := '|';
  Hypertext.ComboBoxURL.text := 'file:///' + urlstr;
  Hypertext.ButtonLoadClick (Sender);
  Hypertext.BringToFront;
{$ENDIF}  
end;

procedure TEditForm.BeendenundallesSpeichern1Click(Sender: TObject);
begin
  SpeicherAbfrage := FALSE;
  WITH Owner AS TLRFrame DO Close;
end;

procedure TEditForm.NeuOeffnen1Click(Sender: TObject);
VAR mr: TModalResult;
    DatMan: TDateiManagerForm;
begin
  IF Editor.Modified THEN
    IF NOT (MessageDlg ('nderungen im aktuellen Textfenster berschreiben?', mtConfirmation,
      [mbYes, mbNo], 0) = mrYes) THEN Exit;
  IF NOT FileExists (Pfadname) THEN BEGIN
    DatMan := TDateiManagerForm.Create (Self);
    WITH DatMan AS TDateiManagerForm DO BEGIN
      Caption := 'Textdatei laden';
      DateiFilterComboBox.ItemIndex := LRFrame.Konfig.DateiFilterIndex;
      ButtonLaden.Enabled := TRUE; (* hm ... *)
      ButtonLaden.Default := TRUE;
      mr := ShowModal;
      IF mr = mrOk THEN BEGIN
        LRFrame.Konfig.DateiFilterIndex := DateiFilterComboBox.ItemIndex;
   //showMessage (ComboBoxDateiauswahlHistory.Text);
        Pfadname := Dateiauswahl; //ComboBoxDateiauswahlHistory.Text;
        WITH TEditForm.Create (Self) DO
          Open (Dateiauswahl);
      END (* IF mrOk *)
      ELSE EXIT;
    END (* WITH *);
  END (* Datei nicht gefunden *);
  Editor.Lines.LoadFromFile (Pfadname);
  Editor.Modified := FALSE;
  CursorDaten (Sender);
end;

procedure TEditForm.Tagauswaehlen1Click(Sender: TObject);
begin
  LRFrame.SpeedButtonTagselectClick (Sender);
end;

procedure TEditForm.TagDialog1Click(Sender: TObject);
begin
  LRFrame.SpeedButtonLinksClick (Sender);
end;

procedure TEditForm.MarkierteDateiladen1Click(Sender: TObject);
VAR  Dateiname: String;
     mr:        TModalResult;
begin
//
  Dateiname := Editor.SelText;
  WHILE Dateiname [Length (Dateiname)] IN [#10, #13] DO BEGIN
    Delete (Dateiname, Length (Dateiname), 1);
  END (* WHILE Zeilenumbruch entfernen *);
  IF NOT FileExists (Dateiname) THEN BEGIN
    WITH TDateiManagerForm.ECreate (Self, FALSE,
      'Textdatei laden', 'In Textfenster laden', Dateiname, '', 
      LRFrame.Konfig.DateiFilterIndex, TRUE, TRUE, FALSE, FALSE) DO BEGIN
      mr := ShowModal;
      IF mr = mrOk THEN BEGIN
        WITH TEditForm.Create (LRFrame) DO
          Open (Dateiauswahl);
      END (* IF mrOk *);
      Release;
    END (* WITH *);
  END (* Datei nicht gefunden *)
  ELSE
    WITH TEditForm.Create (LRFrame) DO
      Open (Dateiname);
end;

procedure TEditForm.TagDialogmitSelectlink1Click(Sender: TObject);
begin
  LRFrame.SpeedButtonSelLinksClick (Sender);
end;

procedure TEditForm.History2Click(Sender: TObject);
begin
  LRFrame.SpeedButtonStringDialogClick (Sender);
end;

procedure TEditForm.GehezuZeile1Click(Sender: TObject);
VAR Zeile: String;
    ZeilNr: Integer;
begin
  Zeile := InputBox('Sprung zu Zeile', 'Zeilennummer eingeben', IntToStr (Row));
  TRY
    ZeilNr := StrToInt (Zeile);
    IF ZeilNr > Editor.Lines.Count THEN ZeilNr := Editor.Lines.Count;
    Row := ZeilNr;
  EXCEPT
    showMessage ('"' + Zeile + '" ist keine gltige Zeilennumer!');
  END;
end;

end.
