procedure TIExplorerForm.WebBrowser1StatusTextChange(Sender: TObject;
  const Text: WideString);
begin
  IF Text <> '' THEN PanelStatus.Caption := Text;
end;

procedure TIExplorerForm.WebBrowser1ProgressChange(Sender: TObject;
                                    Progress, ProgressMax: Integer);
VAR Prozent: Integer;
begin
  IF ProgressMax = 0 THEN BEGIN
    LabelLoadProzent.Caption := '';
    ProgressBarLoadpage.Visible := FALSE;
  END
  ELSE BEGIN
    LabelLoadProzent.Caption := IntToStr ((Progress * 100)
                                          DIV ProgressMax) + '% ';
    ProgressBarLoadpage.Visible := TRUE;
  END;
  ProgressBarLoadpage.Max := ProgressMax;
  ProgressBarLoadpage.Position := Progress;
end;

procedure TIExplorerForm.WebBrowser1CommandStateChange(Sender:
                 TObject; Command: Integer; Enable: WordBool);
begin
  IF EventsAnzeigen THEN
    EventProt ('OnCommandStateChange');
  CASE Command OF
    CSC_NAVIGATEFORWARD: SpeedButtonForward.Enabled := Enable;
    CSC_NAVIGATEBACK: SpeedButtonBack.Enabled := Enable;
  END (* CASE *);
end;

procedure TIExplorerForm.WebBrowser1TitleChange(Sender: TObject;
  const Text: WideString);
begin
  Caption := Text;
end;

procedure TIExplorerForm.WebBrowser1DocumentComplete(Sender: TObject;
                               pDisp: IDispatch; var URL: OleVariant);
VAR location: String;
begin
  location := cleanLocation (WebBrowser1.LocationURL);
  ComboBoxURL.Text := location;
end (* WebBrowser1DocumentComplete *);

