procedure THyperlinkForm1.StringGridTablesDrawCell(Sender: TObject; 
Col,
  Row: Integer; Rect: TRect; State: TGridDrawState);
var  Box: TRect;
     cellAttr: TCellAttribs;
begin
  cellAttr := StringGridTables.Objects [Col, Row] AS TCellAttribs;
  IF cellAttr = NIL THEN Exit;
  IF (cellAttr.rowspan = 0) OR (cellAttr.colspan = 0) THEN EXIT;
  Box := Rect;
  WITH Box DO BEGIN
    Right := Left + (Right - Left + 1) * cellAttr.colspan - 1;
    Bottom := Top + (Bottom - Top + 1) * cellAttr.rowspan - 1;
  END (* WITH Box *);
  StringGridTables.Canvas.FillRect (Box);
  IF (Col = StringGridTables.Col) AND 
     (Row = StringGridTables.Row) THEN BEGIN
    IF StringGridTables.Focused THEN
      StringGridTables.Canvas.Brush.Color := clred
    ELSE
      StringGridTables.Canvas.Brush.Color := clmaroon;

    StringGridTables.Canvas.FrameRect (Box);
    StringGridTables.Canvas.Brush.Color := clwhite;
  END
  ELSE BEGIN
    StringGridTables.Canvas.Brush.Color := clblack;
    StringGridTables.Canvas.FrameRect (Box);
    StringGridTables.Canvas.Brush.Color := clwhite;
  END (* ELSE *);
  StringGridTables.Canvas.TextOut (Box.Left + 2, Box.Top + 2, 
                            StringGridTables.Cells [Col, Row]);
end;
