procedure THyperlinkForm1.StringGridTablesClick(Sender: TObject);
begin
  WITH StringGridTables DO BEGIN

    IF pressedKey = VK_Right THEN BEGIN
      WHILE ((Objects [Col, Row] AS TCellAttribs).colspan <= 0) AND
             (Col < ColCount - 1) DO BEGIN
        WITH Objects [Col, Row] AS TCellAttribs DO BEGIN
          IF (colspan <= 0) AND (Col < ColCount - 1)
            THEN Col := Col + 1;
        END (* WITH *);
      END (* WHILE *);
    END;

    IF pressedKey = VK_Down THEN BEGIN
      WHILE ((Objects [Col, Row] AS TCellAttribs).rowspan <= 0) AND 
             Row < RowCount - 1) DO BEGIN
        WITH Objects [Col, Row] AS TCellAttribs DO BEGIN
          IF (rowspan <= 0) AND (Row < RowCount - 1)
            THEN Row := Row + 1;
        END (* WITH *);
      END (* WHILE *);
    END;

    PressedKey := 0;

    WHILE ((Objects [Col, Row] AS TCellAttribs).colspan <= 0) OR
          ((Objects [Col, Row] AS TCellAttribs).rowspan <= 0) DO BEGIN
      WITH Objects [Col, Row] AS TCellAttribs DO BEGIN
        IF (colspan <= 0) AND (Col > 0) THEN Col := Col - 1;
        IF (rowspan <= 0) AND (Row > 0) THEN Row := Row - 1;
      END (* WITH *);
    END (* WHILE *);

    IF Objects [Col, Row] <> NIL THEN BEGIN
      WITH Objects [Col, Row] AS TCellAttribs DO BEGIN
        UpDownSpanCols.Position := colspan;
        UpDownSpanRows.Position := rowspan;
        EditZellTyp.Text := celltype;
        EditX.Text := IntToStr (Col);
        EditY.Text := IntToStr (Row);
      END (* WITH TCellAttribs *);
      RichEditTabCell.Text := Cells [Col, Row];
    END (* IF *);
  END (* WITH StringGridTables *);
end;
