procedure THyperlinkForm1.ButtonTablesClick(Sender: TObject);
VAR tabstring, rowstring, cellstring:  String;
    co, ro:                            Integer;
begin
  // Tabellensyntax generieren
  WITH StringGridTables DO BEGIN
    // Starttag zusammenbasteln:
    tabstring := '<table';
    IF (EditFormBorder.Text <> '') THEN
      tabstring := tabstring + ' border="' +
                   EditFormBorder.Text + '"';
    IF (EditTabellenbreite.Text <> '') THEN
      tabstring := tabstring + ' width="' +
                   EditTabellenbreite.Text + '"';
    CASE RadioGroupTableAlign.ItemIndex OF
      0: tabstring := tabstring + ' align="left"';
      1: tabstring := tabstring + ' align="center"';
      2: tabstring := tabstring + ' align="right"';
    END (* CASE *);
    IF (RichEditTabSummary.Text <> '') THEN
      tabstring := tabstring + #13#10 +
                   '  summary="' + RichEditTabSummary.Text + '"';
    tabstring := tabstring + '>'+#13#10;
    IF (EditFormCaption.Text <> '') THEN
      tabstring := tabstring + '  <caption>' +
                   EditFormCaption.Text + '</caption>' + #13#10;

    // Tabellenzeilen generieren:
    FOR ro := 0 TO RowCount - 1 DO BEGIN
      rowstring := '';
      FOR co := 0 TO ColCount - 1 DO BEGIN
        cellstring := '';
        IF (((Objects [co, ro] AS TCellAttribs).colspan <> 0) AND
            ((Objects [co, ro] AS TCellAttribs).rowspan <> 0)) 
        THEN BEGIN
          WITH (Objects [co, ro] AS TCellAttribs) DO BEGIN
            IF celltype <> '' THEN cellstring := '<' + celltype
            ELSE cellstring := '<th';
          END (* WITH *);
          IF ((Objects [co, ro] AS TCellAttribs).rowspan > 1) THEN
            cellstring := cellstring + ' rowspan="' +
            IntToStr((Objects [co, ro] AS TCellAttribs).rowspan)+
            '"';
          IF ((Objects [co, ro] AS TCellAttribs).colspan > 1) THEN
            cellstring := cellstring + ' colspan="' +
            IntToStr ((Objects [co, ro] AS TCellAttribs).colspan) +
            '"';
          cellstring := cellstring + '>' + Cells [co, ro];
        END (* IF *);
        IF cellstring <> '' THEN rowstring := rowstring + cellstring;
      END (* FOR co *);
      IF rowstring <> '' THEN tabstring := tabstring + '<tr>' + 
                                           rowstring + #13#10;
    END (* FOR ro *);
    tabstring := tabstring + '</table>';
  END (* WITH *);
  EditSelected.Text := tabstring;
  definiert := TRUE;
end (* ButtonTablesClick *);
