// Installationsberwachung fr Windows 95/NT
// iwatchsu.cpp     Support Functions
// 1998 by c't / Matthias Withopf

#include "iwatchsu.h"

// Hilfsfunktionen

void MemSet(Pointer s,Byte b,unsigned int Size)
{
  PByte p = (PByte)s;
  while (Size-- > 0)
    *p++ = b;
}

void MemCpy(Pointer Dest,Pointer Src,unsigned int Size)
{
  PByte Src1 = (PByte)Src;
  PByte Dst1 = (PByte)Dest;
  while (Size-- > 0)
    *Dst1++ = *Src1++;
}

void MemMove(Pointer Dest,Pointer Src,unsigned int Size)
{
  if (Dest < Src)
    MemCpy(Dest,Src,Size);
  else if (Dest > Src)
    {
      PByte Src1 = ((PByte)Src)  + Size - 1;
      PByte Dst1 = ((PByte)Dest) + Size - 1;
      while (Size-- > 0)
        *Dst1-- = *Src1--;
    }
}

// String-Funktionen

int StrLen(PChar s)
{
  int l = 0;
  while (*s++) ++l;
  return l;
}

void StrCpy(PChar Dest,PChar Src)
{
  while (*Src) *Dest++ = *Src++;
  *Dest = '\0';
}

void StrCopy(PChar Dest,PChar Src,unsigned int MaxLen)
{
  if (!MaxLen) return;
  while (*Src && (--MaxLen > 0)) *Dest++ = *Src++;
  *Dest = '\0';
}

void StrCat(PChar Dest,PChar Src)
{
  while (*Dest) ++Dest;
  while (*Src) *Dest++ = *Src++;
  *Dest = '\0';
}

Boolean StrConcat(PChar Dest,PChar Src,unsigned int MaxLen)
{
  if (!MaxLen) return False;
  int l1 = StrLen(Src);
  int l2 = StrLen(Dest);
  if (l2 + l1 + 1 < MaxLen) { MemCpy(Dest + l2,Src,l1 + 1); return True; }
  int l3 = MaxLen - l2 - 1;
  if (l3 < 0) return False;
  MemCpy(Dest + l2,Src,l3); Dest[MaxLen - 1] = '\0';
  return False;
}

int StrCmp(PChar s1,PChar s2)
{
  for (;;)
    {
      if (!*s1) { if (!*s2) return 0; return -1; }
      if (!*s2) { if (!*s1) return 0; return  1; }
      int d = *s1++ - *s2++;
      if (d) return d;
    }
}

int StrNCmp(PChar s1,PChar s2,unsigned int MaxLen)
{
  while (MaxLen-- > 0)
    {
      if (!*s1) { if (!*s2) return 0; return -1; }
      if (!*s2) { if (!*s1) return 0; return  1; }
      int d = *s1++ - *s2++;
      if (d) return d;
    }
  return 0;
}

int StrICmp(PChar s1,PChar s2)
{
  for (;;)
    {
      if (!*s1) { if (!*s2) return 0; return -1; }
      if (!*s2) { if (!*s1) return 0; return  1; }
      int d = (Char)CharUpper((LPTSTR)*s1++) - (Char)CharUpper((LPTSTR)*s2++);
      if (d) return d;
    }
}

int StrNICmp(PChar s1,PChar s2,unsigned int MaxLen)
{
  while (MaxLen-- > 0)
    {
      if (!*s1) { if (!*s2) return 0; return -1; }
      if (!*s2) { if (!*s1) return 0; return  1; }
      int d = (Char)CharUpper((LPTSTR)*s1++) - (Char)CharUpper((LPTSTR)*s2++);
      if (d) return d;
    }
  return 0;
}

void Write(PChar s)
{
  int l = StrLen(s);
  DWORD R;
  WriteFile(GetStdHandle(STD_OUTPUT_HANDLE),s,(DWORD)l,&R,NULL);
}

LongWord StrToLongWord(PChar s)
{
  if (!s) return 0;
  LongWord x = 0;
  Char c;
  if ((s[0] == '0') && ((Char)CharUpper((LPTSTR)(s[1])) == 'X'))
    {
      s += 2;
      while (c = *s++)
        if (('0' <= c) && (c <= '9'))
          x = 16 * x + (c - '0');
        else if (('A' <= c) && (c <= 'F'))
          x = 16 * x + (c - 'A' + 10);
        else if (('a' <= c) && (c <= 'f'))
          x = 16 * x + (c - 'a' + 10);
        else
          break;
    }
  else
    {
      while (c = *s++)
        if (('0' <= c) && (c <= '9'))
          x = 10 * x + (c - '0');
        else
          break;
    }
  return x;
}

// Heap-Verwaltung

HANDLE OwnHeap = 0;

void InitHeap(int MaxSize)
{
  OwnHeap = HeapCreate(0,8 * 1024,MaxSize * 1024);
}

void DoneHeap(void)
{
  if (OwnHeap) HeapDestroy(OwnHeap); OwnHeap = 0;
}

extern "C" Pointer _cdecl malloc(unsigned int Size)
{
  if (!Size) ++Size;
  return (Pointer)HeapAlloc(OwnHeap,0,Size);
}

extern "C" void _cdecl free(Pointer p)
{
  if (!p) return;
  HeapFree(OwnHeap,0,p);
}

Pointer _cdecl operator new(unsigned int Size)
{
  if (!Size) ++Size;
  return malloc(Size);
}

void _cdecl operator delete(Pointer p)
{
  free(p);
}

#if defined(__BORLANDC__)
Pointer _cdecl operator new[](unsigned int Size)
{
  return ::operator new(Size);
}

void _cdecl operator delete[](Pointer p)
{
  ::operator delete(p);
}
#endif

static PChar EmptyStr = (PChar)"";

PChar NewStr(PChar s)
{
  if (!s) return NULL;
  int   l = 1;    // fr abschlieendes 0-Byte
  PChar s1 = s;
  while (*s1++)
    ++l;
  PChar p = (PChar)malloc(l);
  if (p)
    {
      MemCpy(p,s,l);
      return p;
    }
  return EmptyStr;
}

void DisposeStr(PChar s)
{
  if (s) if (s != EmptyStr) free(s);
}

void FileSplit(PChar Path1,PChar Dir,PChar Name,PChar Ext)
{
  Char Path[512];
  StrCopy(Path,Path1,sizeof Path);
  int l = StrLen(Path);
  int i;
  int NameStart = 0;
  int NameEnd   = l;
  if (Dir)  Dir [0] = '\0';
  if (Name) Name[0] = '\0';
  if (Ext)  Ext [0] = '\0';
  for (i = l;i >= 0;--i)
    if ((Path[i] == '\\') || (Path[i] == ':'))
      {
        NameStart = i + 1;
        break;
      }
  if (Dir && NameStart)
    {
      MemCpy(Dir,Path,NameStart);
      Dir[NameStart] = '\0';
    }
  for (i = l;i >= NameStart;--i)
    if (Path[i] == '.')
      {
        if (Ext)
          StrCpy(Ext,&Path[i]);
        NameEnd = i;
        break;
      }
  i = NameEnd - NameStart;
  if (Name && (i > 0))
    {
      MemCpy(Name,&Path[NameStart],i);
      Name[i] = '\0';
    }
}

