// Installationsberwachung fr Windows 95/NT
// iwatchsu.cpp    Support Functions
// 1998 by c't / Matthias Withopf

#ifndef _IWATCHSU_H_
#define _IWATCHSU_H_

#if defined(_M_IX86)
  #define CPU_INTEL   1
#elif defined(_M_ALPHA)
  #define CPU_ALPHA   1
#endif

#define STRICT
#define WIN32_LEAN_AND_MEAN
#include <windows.h>

typedef                char Boolean;
typedef unsigned       char Char;
typedef unsigned       char Byte;
typedef unsigned short int  Word;
typedef unsigned long  int  LongWord;
typedef void *              Pointer;
typedef Boolean *           PBoolean;
typedef char *              Pchar;
typedef Char *              PChar;
typedef Byte *              PByte;
typedef Word *              PWord;
typedef LongWord *          PLongWord;

#define NULL   0
#define False  0
#define True   1

void MemSet(Pointer s,Byte b,unsigned int Size);
void MemCpy(Pointer Dest,Pointer Src,unsigned int Size);
void MemMove(Pointer Dest,Pointer Src,unsigned int Size);
int StrLen(PChar s);
void StrCpy(PChar Dest,PChar Src);
void StrCopy(PChar Dest,PChar Src,unsigned int MaxLen);
void StrCat(PChar Dest,PChar Src);
Boolean StrConcat(PChar Dest,PChar Src,unsigned int MaxLen);
int StrCmp(PChar s1,PChar s2);
int StrNCmp(PChar s1,PChar s2,unsigned int MaxLen);
int StrICmp(PChar s1,PChar s2);
int StrNICmp(PChar s1,PChar s2,unsigned int MaxLen);
void Write(PChar s);
LongWord StrToLongWord(PChar s);
void InitHeap(int MaxSize);
void DoneHeap(void);
extern "C" Pointer _cdecl malloc(unsigned int Size);
extern "C" void _cdecl free(Pointer p);
PChar NewStr(PChar s);
void DisposeStr(PChar s);
void FileSplit(PChar Path1,PChar Dir,PChar Name,PChar Ext);

#endif

