 program Apfel; { c't Mai 98, Original in c't 3/89, as }
 {$N+,E+}
 {$L MANSIN }
 Uses  crt, timerx, Graph,DOS;

 { Berechnet ein Apfelmaennchen. mit
    R0 = I0 = 0; Vergroesserung = 100; Tiefe = 1024  }

   Type paratyp=integer;

 Var
   I0,R0,Del				  : single;
   Treiber, Modus, X, Y, Color            : integer;
   Tiefe, Count, Grenze                   : Paratyp;
   MaxX, MaxY                             : integer;
   Vergroesserung                         : integer;
   te,ta                                  : real;
   wo                                     : boolean;
   umleitung                              : boolean;
   con                                    : text;
   iter                                   : longint;

Procedure EGAVGADriverProc; External;
{$L EGAVGA.OBJ }

Type Proctype=(S87,S487,S487b,K3D,L87);
const mitgrafik:boolean=true;
      bench:boolean=true;
      rexit:boolean=true;
var   Proc:Proctype;


Function IterAsm87
 (I,R :single; Grenze,Tiefe :Paratyp):Paratyp; External;

Function IterAsmK3D
 (I,R :single; Grenze,Tiefe :Paratyp):Paratyp; External;

Function IterAsmK3DJ
 (I,R :single; Grenze,Tiefe :Paratyp):Paratyp; External;



Function IterAsm487
 (I,R :Single; Grenze,Tiefe :Paratyp):Paratyp; External;

Function IterAsm487b
 (I,R :Single; Grenze,Tiefe :Paratyp):Paratyp; External;

Function Test3Dnow:integer; External;

Function IterPasS
     (I,R :single; Grenze, Tiefe :Paratyp):Paratyp;
  var A,B,C:Single;
  Begin
   Count:= 0;
   A:=0; B:=0;
   Repeat
      C:= SQR(A) - SQR(B) + R;
      B:= 2*A*B + I;
      A:= C;
      INC (Count);
   Until (abs (A) >Grenze) or (Abs (B) > Grenze)
           or (Count=Tiefe);
  IterpasS:=Count;
  End;



Function IterPasD
     (I,R :Double; Grenze, Tiefe :Paratyp):Paratyp;
     var A,B,C:double;
  Begin
   Count:= 0;
   A:=0; B:=0;
   Repeat
      C:= SQR(A) - SQR(B) + R;
      B:= 2*A*B + I;
      A:= C;
      INC (Count);
   Until (abs (A) >Grenze) or (Abs (B) > Grenze)
           or (Count=Tiefe);
  IterpasD:=Count;
  End;

function upstr (x:string):string;
var i:Integer;
begin
 upstr[0]:=x[0];
 for i:=1 to length(x) do upstr[i]:=upcase (x[i]);
end;

Procedure errorexit (x:string;n:word);
begin
 writeln (x);
 halt(n);
end;


Procedure TestUmleitung (var umleitung:boolean);

begin
umleitung:= mem[prefixseg:$19]<> 1;
{if umleitung then}
 begin
 assignCRT (con);
 rewrite(con);
 assign (output,'');
 rewrite (output);
 end;
end;



Function Strtoreal (s:string):real;
var xresult:integer;
var r:real; p:byte;
begin
p:= pos (',',s); if p> 0 then s[p]:='.';
val (s,r,xresult);
if xresult > 0 then errorexit ('Fehler in Zahl:'+s,3);
strtoreal:=r;
end;

Function Strtoint (s:string):longint;
var xresult:integer;
var l:longint;
begin
val (s,l,xresult);
if xresult > 0 then errorexit ('Fehler in Zahl:'+s,3);
strtoint:=l;
end;


Procedure ReadReal (var x:single);
var rstr:string;
begin
Readln (rstr);
if (rstr='') or (rstr=^[) then halt;
x:=strtoreal (rstr);
end;

Procedure ReadInt (var x:integer);
var rstr:string;
begin
Readln (rstr);
if (rstr='') or (rstr=^[) then halt;
x:=strtoint (rstr);
end;


var FPU:boolean;
const Pascal:boolean=false;

Procedure MessApfelS (I0s,R0s,del:single;mitgrafik:boolean;var tx:real);
Var I,R:Single;
begin
  starttimer;
  MaxX:=640;
  MaxY:=350;
  Grenze:= 3;
  I:=I0S-MaxY/2*del;
    Y:=0;
    Repeat
       X:=0;
       R:=R0s-MaxX/2*del;
       Repeat
         if FPU and not Pascal then Color := Iterasm87 (I,R,Grenze,Tiefe)
         else  Color := IterpasS (I,R,Grenze,Tiefe);
           if mitgrafik then PutPixel (X, Y, Color);
           INC (X);
           R:=R+del;
           INC (Iter,color);
       Until X=MaxX;
       INC (Y);
       I:=I+del;
       IF keypressed then y:=Maxy;
    Until Y=MaxY;
tx:=ztime;
end;

Procedure ListApfelS (I0s,R0s,del:single;mitgrafik:boolean;var tx:real);
Var I,R:Single;
begin
  MaxX:=640;
  MaxY:=350;
  Grenze:= 3;
  Y:=72;
  I:=I0S-MaxY/2*del+Y*del;
    Repeat
       X:=304;
       R:=R0s-MaxX/2*del+X*del;
       Repeat
         Color := IterpasS (I,R,Grenze,Tiefe);
         if color =tiefe then
             Writeln (X:4, Y:4, Color:8);
           INC (X);
           R:=R+del;
           INC (Iter,color);
       Until X=MaxX;

       INC (Y);
       I:=I+del;
       IF keypressed then y:=Maxy;
    Until Y=MaxY;
end;

Procedure MessApfelK3D (I0s,R0s,del:single;mitgrafik:boolean;var tx:real);
Var I,R:Single;
begin
  starttimer;
  MaxX:=640;
  MaxY:=350;
  Grenze:= 3;
  I:=I0S-MaxY/2*del;
    Y:=0;
    Repeat
       X:=0;
       R:=R0s-MaxX/2*del;
       Repeat
         if FPU and not Pascal
          then Color := IterasmK3DJ (I,R,Grenze,Tiefe)
          else Color := IterpasS (I,R,Grenze,Tiefe);
           if mitgrafik then PutPixel (X, Y, Color);
           INC (X);
           R:=R+del;
           INC (Iter,color);

       Until X=MaxX;
       INC (Y);
       I:=I+del;
       IF keypressed then y:=Maxy;
    Until Y=MaxY;
tx:=ztime;
end;


Procedure MessApfel487 (I0D,R0D,del:Single;mitgrafik:boolean;var tx:real);
Var I,R:Double;
begin
  starttimer;
  MaxX:=640;
  MaxY:=350;
  Grenze:= 3;
  I:=I0D-MaxY/2*del;
    Y:=0;
    Repeat
       X:=0;
       R:=R0D-MaxX/2*del;
       Repeat

         if FPU and not Pascal then Color := Iterasm487 (I,R,Grenze,Tiefe)
         else  Color := IterpasS (I,R,Grenze,Tiefe);
           if mitgrafik then PutPixel (X, Y, Color);
           INC (X);
           R:=R+del;
       INC (Iter,color);

       Until X=MaxX;
       INC (Y);
       I:=I+del;
       IF keypressed then y:=Maxy;
    Until Y=MaxY;
tx:=ztime;
end;

Procedure MessApfel487b (I0D,R0D,del:Single;mitgrafik:boolean;var tx:real);
Var I,R:Double;
begin
  starttimer;
  MaxX:=640;
  MaxY:=350;
  Grenze:= 3;
  I:=I0D-MaxY/2*del;
    Y:=0;
    Repeat
       X:=0;
       R:=R0D-MaxX/2*del;
       Repeat
         if FPU and not Pascal then Color := Iterasm487b (I,R,Grenze,Tiefe)
         else  Color := IterpasS (I,R,Grenze,Tiefe);
           if mitgrafik then PutPixel (X, Y, Color);
           INC (X);
           R:=R+del;
       INC (Iter,color);

       Until X=MaxX;
       INC (Y);
       I:=I+del;
       IF keypressed then y:=Maxy;
    Until Y=MaxY;
tx:=ztime;
end;


Procedure int06; interrupt;
begin
Writeln ('error: unknown Opcode Interrupt');
halt;
end;


var exitsave,alt06:pointer;
Procedure myexit; far;
var i6:pointer;
begin
getintvec($06,i6);
if i6=@int06 then setintvec($06,alt06);
exitproc:=exitsave;
end;



var para:string;
var ch:char;
var doit:boolean;
Begin
 getintvec($06,alt06);
 exitsave:=exitproc;
 exitproc:=@myexit;
 setintvec ($06,@int06);
 testumleitung (umleitung);
 doit:=true;
 ta:=0; te:=0;
 if RegisterBGIDriver(@EGAVGADriverProc)<0 then begin
  writeln('Fehler beim Registrieren des Grafiktreibers: ',GraphErrorMSG(Graphresult));
  halt;
 end;
  Treiber:=0; Modus:=0;
  InitGraph (Treiber, Modus,''); { hier ggf. BGI-Pfad }


  FPU:=test8087>0;
  para:=upstr(paramstr(1));
  if (para <>'') and ((para[1]='/') or (para[1]='-')) then delete (para,1,1);

repeat
  doit:=true;
  if pos('E',para) >0 then bench:=false;
  if pos('P',para) >0 then Pascal:=true;
  Proc:=S87;
  if pos('2',para)>0 then Proc:=S487;
  if pos('B',para)>0 then Proc:=S487b;
  if pos('3',para)>0 then Proc:=K3D;
  if pos ('L',para)>0 then Proc:=L87;
  if proc=K3D then

   begin
   If Test3Dnow <> 0 then
    begin
    Writeln (' Sorry, 3DNow! not detected');
    doit:=false;
    end;
   end;
if doit then
 begin
  if bench then
    begin
    R0:=0; I0:=0; Vergroesserung:=100; Tiefe:=1024;
    rexit:=true;
    end
    else
    begin
    gotoxy (1,23);
    write ('c''t-Apfelmnnchen');
    gotoxy (20,23);
    Write ('R0=');  ReadReal (R0);
    gotoxy (30,23);
    Write ('I0=');  ReadReal (I0);
    gotoxy (40,23);
    Write ('Vergroesserung ='); readint (Vergroesserung);
    gotoxy (60,23);
    Write ('Tiefe='); Readint (Tiefe);
    Writeln;
    Writeln;
    rexit:=false;
    end;
  iter:=0;
  delay(1000);
  del:=1.0/Vergroesserung;
  gotoxy (1,23);
  Writeln ('c''t-Fractals (c) Andreas Stiller  Mai 1998');
  {
  Writeln ('Syntax ctapfel /d :double Precision, /s: single Precion /3: 3Dnow!');
  }

  if FPU then Write ('uses FPU')
         else write ('uses FPU-Emulator');
  case Proc of
    S87 : Write (' (8087-Mode)');
    S487: Write (' (80487-Mode)');
    K3D : Write (' Single Precision, 3DNow!');
   end;

  if Pascal then Write (', with Pascal procedure') else
                 Write (', with assembler procedure');
  Writeln (', 640x350 Pixel');
  Writeln ('Range:R0=',R0:4:3,', I0=',I0:4:3,', Zoom:',1/del:4:3, ', Depth: ',Tiefe,', Limits=+3/-3');

  case Proc of
  S87:   MessApfelS  (I0,R0,Del,true,te);   { mit Grafik }
  S487:  MessApfel487(I0,R0,Del,true,te);   { mit Grafik }
  S487b: MessApfel487(I0,R0,Del,true,te);   { mit Grafik }
  K3D:   MessApfelK3D  (I0,R0,Del,true,te);   { mit Grafik }
  L87:   ListApfelS (I0,R0,Del,true,te);
  end;
  Writeln ('Iterations: ', iter);
  If proc <> L87 then
   begin
   write ('Time with pixel graphic    : ',(te) :6:2,' s');
   Writeln (' => ',iter/te/1e6:6:2,' Million Iterations per s');
   end;
  outtextxy (500,300,' wait a second');
  iter:=0;
  case Proc of
  S87:  MessApfelS    (I0,R0,Del,False,ta);  { ohne grafik }
  S487: MessApfel487 (I0,R0,Del,False,ta);  { ohne grafik }
  S487b:MessApfel487b(I0,R0,Del,False,ta);  { ohne grafik }

  K3D:  MessApfelK3D  (I0,R0,Del,False,ta);  { ohne grafik }
  end;
 if proc <> l87 then
 begin
  write ('Time without pixel graphic : ',(ta):6:2,' s');
  Writeln (' => ',iter/ta/1e6:6:2,' Million Iterations per s');
 end;
end;
If bench and not umleitung then
 begin
  Writeln ('enter 1: FPU 87-Mode, 2: FPU 487-Mode 3:3Dnow! or ret for exit');
  ch:=upcase(readkey);
  rexit:=(ch=^M) or (ch=^[) or (ch='Q') ;
  para:=ch;
  clearviewport;
 end;
until rexit;

restorecrtmode;


if umleitung then
 begin
      writeln (con,'Time with Pixels: ',(te) :6:2,'s');
      writeln (con,'Time without Pixels: ',(ta):6:2,'s');
 end;

end.

